// Placed in /usr/share/plasma/shells/org.kde.plasma.desktop/contents/updates/
// This script is run for newly created users and sets the default
// wallpaper for all desktops
//
// Copyright 2016 Aurélien COUDERC <zecoucou@free.fr>
// SPDX-License-Identifier: GPL-3.0+

d = desktops()

for (i in d) {
    // Only set up the wallpaper if the plugin is the default.
    // Otherwise it means the user chose another plugin and we don’t want to override that.
    if (d[i].wallpaperPlugin == 'org.kde.image') {
        d[i].currentConfigGroup = Array('Wallpaper', 'org.kde.image', 'General')
        if (!d[i].readConfig('Image')) {
            // Only set up the wallpaper if the wallpaper image is empty (=default).
            // Otherwise it means the user selected a picture and we don’t want to override that.
            d[i].writeConfig('Image', 'PureOS');
        }
    }
}
