#!/bin/bash
set -e

#
# Automatically add Flatpak repositories to the system
# based on repository files found in a directory.
#

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
STABLE_REPO_DIR="$SCRIPT_DIR/repos"
BETA_REPO_DIR="$SCRIPT_DIR/repos/beta"

# Add stable repositories
for repofile in "$STABLE_REPO_DIR/"*.flatpakrepo
do
  reponame="${repofile##*/}"
  reponame=${reponame%.flatpakrepo}
  flatpak remote-add --system --if-not-exists "$reponame" "$repofile"
done

# Add beta repositories, in disabled state
if [ -d "$BETA_REPO_DIR" ]; then

  for repofile in "$BETA_REPO_DIR/"*.flatpakrepo
  do
    reponame="${repofile##*/}"
    reponame=${reponame%.flatpakrepo}
    flatpak remote-add --system --if-not-exists --disable "$reponame" "$repofile"
  done

fi
