# -*- coding: utf-8 -*-
#
# Copyright (C) 2018 Matthias Klumpp <matthias.klumpp@puri.sm>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.

import os
import sys
import dbus
import locale
from gi.repository import GLib
from dbus.mainloop.glib import DBusGMainLoop
import logging as log
from argparse import ArgumentParser
from .dbus_interface import InitDiskCryptoDBus


def run(mainfile, args):

    parser = ArgumentParser(description='OEM Disk Encryption Helper')

    parser.add_argument('--debug', action='store_true', default=False, help='Enable debugging messages.')
    parser.add_argument('--session-bus', default=False, action='store_true', help='Run on the session bus (useful for testing)')
    options = parser.parse_args(args)

    if options.debug:
        log.basicConfig(level=log.DEBUG)
    else:
        log.basicConfig(level=log.INFO)

    if sys.getfilesystemencoding() == 'ascii' and 'LANG' not in os.environ:
        try:
            locale.setlocale(locale.LC_ALL, 'C.UTF-8')
            os.putenv('LC_CTYPE', 'C.UTF-8')
        except locale.Error:
            pass

    # cryptsetup wants a shell set
    os.environ['SHELL'] = '/bin/sh'

    # set PATH, although we should probably use absolute executable
    # paths everywhere...
    os.environ['PATH'] = '/usr/sbin:/usr/bin:/sbin:/bin'

    # create the server
    DBusGMainLoop(set_as_default=True)
    if options.session_bus:
        bus = dbus.SessionBus()
        use_polkit = False
    else:
        bus = dbus.SystemBus()
        use_polkit = True

    mainloop = GLib.MainLoop()
    server = InitDiskCryptoDBus(bus, mainloop, enforce_polkit=use_polkit)
    mainloop.run()
