# pureos-meta

This is the seed package for PureOS which defines (default) package sets.

## How to modify seeds

1. When adding packages, first determine to which seeds a package belongs (refer to the package descriptions
   in `debian/control` for a description of the purpose of the respective seed. The desktop-common seed is absorbed
   by all GUI desktop seeds, currently "plasma" and "gnome").

2. Add the new package to the respective seed in `seed/byzantium/<name>`, ideally add a comment on why it was added.
   Packages in brackets are added as recommends to the final package, so the user may remove them without uninstalling
   the metapackage, while packages without brackets are essential and can not be removed. Choose wisely.
   For removing a package, just remove its line.

3. Commit the change to Git as a single commit.

4. When releasing the package, run the `./update` script in the current package directory. Make sure `germinate`
   is installed. This will generate a changelog entry for you and update the package lists. You may need to install
   the PureOS archive keyring if you are not on PureOS.

5. Set the right release suite in `debian/changelog`, do *not* change any of the changelog lines
   (except for removing duplicates).

6. This packages' version number at the moment is `0.<pureos-release>.<revision>`, so only ever change the
   revision number for now. Due to a mistake, the current "pureos-release" number is assumed 9, even though
   PureOS 8.0 is current (the version number should be "0.8.x").
   This will get fixed eventually at some point in the future when we utilize the major revision for the
   PureOS release.

7. Commit the generated changes by the `update` script as well as the new changelog, use `gbp` to tag the
   changes (make sure your tag is signed) and push the result.

The package and its sources are used by our image build system to estimate space amounts. The data is also used by
PureOS QA to determine which packages are "more important" than others and should be treated with preference in
QA processes.
We also use the data to generate reports of things that are available in PureOS by default, with explanations on
why they are pulled in (explicitly or by dependency).

## Where can I find the germinator reports?

You can either generate them yourself, or go to [master.pureos.net/raw/germinate/pureos.byzantium](http://master.pureos.net/raw/germinate/pureos.byzantium/)
for an always up-to-date version.
