# PureOS Store

PureOS Store lets you install and update applications and system extensions.
A plugin system is used to access software from different sources.
Plugins are provided for:
 - Traditional package installation via PackageKit (e.g. Debian package, RPM).
 - Next generation packages: [Flatpak](https://flatpak.org/).
 - Firmware updates.
 - Ratings and reviews using [ODRS](https://odrs.gnome.org/).

PureOS Store supports showing metadata that closely matches the [AppStream](https://www.freedesktop.org/wiki/Distributions/AppStream/) format.

PureOS Store runs as a background service to provide update notifications and be a search provider for [GNOME Shell](https://wiki.gnome.org/Projects/GnomeShell).

# Building

Build locally with:
```
$ meson --prefix $PWD/install build/
$ ninja -C build/ all install
$ killall pureos-store
$ XDG_DATA_DIRS=install/share:$XDG_DATA_DIRS ./install/bin/pureos-store
```

# Debugging

Running with `--verbose` will give detailed logging information.
