#!/usr/bin/python

"""pwrkap test routines."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import discovery
import time
import pwrkap_pickle
import sys
import pwrkap_train

def discover_world():
	"""Discovery and assemble power domains."""
	print "Probing hardware..."
	discovery.load_pwrkap_drivers()
	discovery.discover_devices()
	discovery.discover_meters()
	discovery.discover_power_domains()

discover_world()

print ("devices", discovery.PWRKAP_DEVICES)
print ("pmeters", discovery.PWRKAP_POWER_METERS)
print ("emeters", discovery.PWRKAP_ENERGY_METERS)
print ("devdomains", discovery.PWRKAP_DEVICE_DOMAINS)
print ("pwrdomains", discovery.PWRKAP_POWER_DOMAINS)

# Speed things up if we're using fakedomain
def train():
	if "fake_cpudomain" in discovery.PWRKAP_DRIVERS:
		pwrkap_train.STABILIZE_TIME = 0
		pwrkap_train.MAX_MEASUREMENTS = 10
	pwrkap_train.train()

def quick_simulate():
	if len(discovery.PWRKAP_POWER_DOMAINS) == 0:
		return

	for pd in discovery.PWRKAP_POWER_DOMAINS:
		print pd.inventory()

	while True:
		for pd in discovery.PWRKAP_POWER_DOMAINS:
			print pd.snapshot()
		time.sleep(1)

def pickle_test():
	for i in range(0, 500):
		for dm in discovery.PWRKAP_POWER_DOMAINS:
			dm.process_snapshot()

	count = 0
	for dm in discovery.PWRKAP_POWER_DOMAINS:
		count = count + 1
		fname = "/tmp/pdom%d" % count
		print "Saving to '%s'..." % fname
		fp = open(fname, "w")
		dm.save_snapshots(fp)
		fp.close()

def pickle2():
	for i in range(0, 500):
		for dm in discovery.PWRKAP_POWER_DOMAINS:
			dm.process_snapshot()

	pwrkap_pickle.save_domains(discovery.PWRKAP_POWER_DOMAINS)
	fubar = pwrkap_pickle.load_domains(discovery.PWRKAP_POWER_DOMAINS)
	if fubar == None:
		print "Screw up?!"
		return False

	print "INVENTORY"
	for dm in discovery.PWRKAP_POWER_DOMAINS:
		print dm.inventory()

	print "INVENTORY PICKLED"
	for dm in fubar:
		print dm.inventory()

	print "SNAPSHOT"
	for dm in fubar:
		print dm.snapshot()

def pickle3():
	pwrkap_pickle.save_domains(discovery.PWRKAP_POWER_DOMAINS)
	fubar = pwrkap_pickle.load_domains(discovery.PWRKAP_POWER_DOMAINS)
	if fubar == None:
		print "Screw up?!"
		return False

	print "INVENTORY"
	for dm in discovery.PWRKAP_POWER_DOMAINS:
		print dm.inventory()

	print "INVENTORY PICKLED"
	for dm in fubar:
		print dm.inventory()

	print "SNAPSHOT"
	for dm in fubar:
		print dm.snapshot()

def pickle4():
	fubar = pwrkap_pickle.load_domains(discovery.PWRKAP_POWER_DOMAINS)
	if fubar == None:
		print "Screw up?!"
		return False

	print "INVENTORY"
	for dm in discovery.PWRKAP_POWER_DOMAINS:
		print dm.inventory()

	print "INVENTORY PICKLED"
	for dm in fubar:
		print dm.inventory()

	print "SNAPSHOT"
	for dm in fubar:
		print dm.snapshot()

def simulate():
	for i in range(0, 300):
		for dm in discovery.PWRKAP_POWER_DOMAINS:
			dm.process_snapshot()

	for dm in discovery.PWRKAP_POWER_DOMAINS:
		print dm.trans_store.trans_table
		x = dm.get_cap()
		x = x * 0.75
		while x > 10:
			y = dm.set_cap(x)
			if y < 0:
				print "Missed cap %(cap)dW by %(miss)dW usage %(use)dW" \
					% {"miss": y, "cap": x, "use": dm.get_power_use()}
			x = dm.get_cap()
			x = x * 0.75

tests = []
if len(sys.argv) < 2:
	tests = ["train", "pickle3"]
else:
	tests = sys.argv[1:]

for test in tests:
	print "Executing %s()" % test
	exec "%s()" % test
