# spec file for package pwrkap
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.

%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_rhel %(test -e /etc/redhat-release && echo 1 || echo 0)

Name:      pwrkap
Summary:   Energy Monitor and Power Capping software for Linux.
Version:   7.20
Release:   1
License:   GPL
Vendor:    Darrick J. Wong <djwong@us.ibm.com>
BuildArch: noarch
Group:     Administration
Source0:   %{name}-%version.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-build
%if %is_suse
Requires:  ipmitool python python-gtk
%endif
%if %is_rhel
Requires:  OpenIPMI-tools python pygtk2
%endif

%description
pwrkap is a set of utilities that monitor computer energy
consumption and enforces an upper limit on the amount of power consumed
by the computer at any given time.
 
%prep
echo Building %{name}-%{version}-%{release}
%setup -q -n %{name}

%build
make PREFIX=%_prefix all

%install
make INST_PREFIX=%buildroot PREFIX=%_prefix install
mkdir -p %buildroot/etc/init.d/
cp -pRdu redhat/init-script %buildroot/etc/init.d/pwrkap

%clean
make clean

%post
chkconfig pwrkap on

%preun
chkconfig pwrkap off

%files
%defattr(-,root,root)

%dir %_prefix/lib/pwrkap/
%dir %_prefix/share/pwrkap/

/etc/init.d/pwrkap
%_prefix/lib/pwrkap/*
%_prefix/share/pwrkap/*
%_prefix/bin/pwrkap_*

%changelog
* Mon May 21 2008 - djwong (at) us.ibm.com
- Initial package creation
