# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0
from __future__ import annotations

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from helper.usesqapplication import UsesQApplication

from PySide6.QtWidgets import QFrame, QWidget
from PySide6.QtUiTools import QUiLoader


class BugTest(UsesQApplication):
    def testCase(self):
        w = QWidget()
        loader = QUiLoader()

        filePath = os.path.join(os.path.dirname(__file__), 'test.ui')
        result = loader.load(filePath, w)
        self.assertTrue(isinstance(result.child_object, QFrame))


if __name__ == '__main__':
    unittest.main()
