% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeature.R
\name{plotFeature}
\alias{plotFeature}
\title{Basic plot function of the raw or normalized data.}
\usage{
plotFeature(obj, otuIndex, classIndex, col = "black", sort = TRUE,
  sortby = NULL, norm = TRUE, log = TRUE, sl = 1000, ...)
}
\arguments{
\item{obj}{A MRexperiment object with count data.}

\item{otuIndex}{The row to plot}

\item{classIndex}{A list of the samples in their respective groups.}

\item{col}{A vector to color samples by.}

\item{sort}{Boolean, sort or not.}

\item{sortby}{Default is sort by library size, alternative vector for sorting}

\item{norm}{Whether or not to normalize the counts - if MRexperiment object.}

\item{log}{Whether or not to log2 transform the counts - if MRexperiment object.}

\item{sl}{Scaling factor - if MRexperiment and norm=TRUE.}

\item{...}{Additional plot arguments.}
}
\value{
counts and classindex
}
\description{
This function plots the abundance of a particular OTU by class. The function
is the typical manhattan plot of the abundances.
}
\examples{

data(mouseData)
classIndex=list(Western=which(pData(mouseData)$diet=="Western"))
classIndex$BK=which(pData(mouseData)$diet=="BK")
otuIndex = 8770

par(mfrow=c(2,1))
dates = pData(mouseData)$date
plotFeature(mouseData,norm=FALSE,log=FALSE,otuIndex,classIndex,
col=dates,sortby=dates,ylab="Raw reads")

}
\seealso{
\code{\link{cumNorm}}
}
