% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{fitZigResults-class}
\alias{fitZigResults-class}
\title{Class "fitZigResults" -- a formal class for storing results from a fitZig call}
\description{
This class contains all of the same information expected from a fitZig call, 
but it is defined in the S4 style as opposed to being stored as a list.
}
\section{Slots}{

\describe{
\item{\code{call}}{the call made to fitZig}

\item{\code{fit}}{'MLArrayLM' Limma object of the weighted fit}

\item{\code{countResiduals}}{standardized residuals of the fit}

\item{\code{z}}{matrix of the posterior probabilities. It is defined as $z_ij = pr(delta_ij=1 | data)$}

\item{\code{zUsed}}{used in \code{\link{getZ}}}

\item{\code{eb}}{output of eBayes, moderated t-statistics, moderated F-statistics, etc}

\item{\code{taxa}}{vector of the taxa names}

\item{\code{counts}}{the original count matrix input}

\item{\code{zeroMod}}{the zero model matrix}

\item{\code{zeroCoef}}{the zero model fitted results}

\item{\code{stillActive}}{convergence}

\item{\code{stillActiveNLL}}{nll at convergence}

\item{\code{dupcor}}{correlation of duplicates}
}}

