\name{MutationalPatterns}
\alias{MutationalPatterns-package}
\alias{MutationalPatterns}
\docType{package}
\title{
MutationalPatterns: an integrative R package for studying patterns in
base substitution catalogues
}
\description{
This package provides an extensive toolset for the characterization and
visualization of a wide range of mutational patterns from base
substitution catalogues. These patterns include: mutational signatures,
transcriptional strand bias, genomic distribution and association with
genomic features.
}
\details{
The package provides functionalities for both extracting mutational
signatures de novo and inferring the contribution of previously
identified mutational signatures. Furthermore, MutationalPatterns allows
for easy exploration and visualization of other types of patterns such
as transcriptional strand asymmetry, genomic distribution and
associations with (publically available) annotations such as chromatin
organization. In addition to identification of active mutation-inducing
processes, this approach also allows for determining the involvement of
specific DNA repair pathways. For example, presence of a transcriptional
strand bias in genic regions may indicate activity of transcription
coupled repair.
}

\author{
Francis Blokzijl, Roel Janssen, Ruben van Boxtel, Edwin Cuppen
Maintainers: Francis Blokzijl, UMC Utrecht <f.blokzijl@umcutrecht.nl>
Roel Janssen, UMC Utrecht <R.R.E.Janssen-10@umcutrecht.nl>
}
\references{
Alexandrov,L.B. et al. (2013) Signatures of mutational processes in
human cancer. Nature, 500, 415–21.

Blokzijl,F. et al. (2016) Tissue-specific mutation accumulation in human
adult stem cells during life. Nature, in press.

Borchers,H.W. (2016) pracma: Practical Numerical Math Functions.

Durinck,S. et al. (2005) BioMart and Bioconductor: A powerful link
between biological databases and microarray data
analysis. Bioinformatics, 21, 3439–3440.

Gaujoux,R. and Seoighe,C. (2010) A flexible R package for nonnegative
matrix factorization. BMC Bioinformatics, 11, 367.

Haradhvala,N.J. et al. (2016) Mutational Strand Asymmetries in Cancer
Genomes Reveal Mechanisms of DNA Damage and Repair. Cell, 1–12.

Helleday,T. et al. (2014) Mechanisms underlying mutational signatures in
human cancers. Nat. Rev. Genet., 15, 585–598.

Lawrence,M. et al. (2013) Software for computing and annotating genomic
ranges. PLoS Comput. Biol., 9, e1003118.

Pleasance,E.D. et al. (2010) A comprehensive catalogue of somatic
mutations from a human cancer genome. Nature, 463, 191–196.
}
\keyword{package}
\seealso{
\url{https://github.com/CuppenResearch/MutationalPatterns}
}
