% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\docType{methods}
\name{contentNorm,RccSet-method}
\alias{contentNorm,RccSet-method}
\alias{contentNorm}
\title{Content normalization}
\usage{
\S4method{contentNorm}{RccSet}(rccSet, method = c("global", "housekeeping"),
  summaryFunction = "median", hk = NULL, inputMatrix = c("bgCorrData",
  "posCtrlData", "exprs"), quietly = FALSE)
}
\arguments{
\item{rccSet}{An RccSet.}

\item{method}{Specifies the features to be used for normalization. "global" indicates that all
features should be used and "housekeeping" indicates that only housekeeping
features should be used. If "housekeeping" is specified and the `hk' argument
(below) is also specified, then the features indicated by `hk' will be used.
If "housekeeping" is specified and `hk' is left NULL, then the default
housekeeping features (i.e. those with CodeClass == "Housekeeping") will be used.}

\item{summaryFunction}{Character specifying the summary function to apply to the selected features
(e.g. "mean" or "median"). User-defined functions similar to these can be
specified here as well.}

\item{hk}{Logical vector defining, for each feature, whether or not it shall
be used for housekeeping normalization if housekeeping is specified as the
normalization method.}

\item{inputMatrix}{Name of the matrix in the RccSet's assayData to use as input for performing
content normalization (one of "exprs", "posCtrlData", or "bgCorrData"). If
posCtrlData or bgCorrData are specified but not found in the assayData, an
error will be generated.}

\item{quietly}{Boolean specifying whether or not messages and warnings should be omitted.}
}
\value{
A copy of the input is returned with a new matrix named `normData' added to
the assayData that contains the content-normalized counts. (\bold{NOTE}: normData
contains values on a log2 scale while all other matrices in assayData are
on a linear scale.) If housekeeping is specified as the normalization method,
then the housekeeping features used will be recorded in the returned RccSet in
a new featureData column named `Housekeeping'. Parameters specified in the
function call are also recorded in the output's experimentData@preprocessing
list.
}
\description{
Performs content normalization on the given RccSet.
}
\examples{
data(example_rccSet)

pcnorm_example_rccSet <- posCtrlNorm(example_rccSet)
bg <- getBackground(pcnorm_example_rccSet)
bgcorr_example_rccSet <- subtractBackground(pcnorm_example_rccSet, bg)

gmnorm_example_rccSet <- contentNorm(bgcorr_example_rccSet, method="global",
    inputMatrix="exprs")
hknorm_example_rccSet <- contentNorm(bgcorr_example_rccSet, method="housekeeping",
    summaryFunction="mean")

}
\author{
Dorothee Nickles
}
