% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlevel64.R
\name{qtile}
\alias{qtile}
\alias{qtile.integer64}
\alias{quantile.integer64}
\alias{median.integer64}
\alias{mean.integer64}
\alias{summary.integer64}
\title{(Q)uan(Tile)s}
\usage{
qtile(x, probs = seq(0, 1, 0.25), ...)

\method{qtile}{integer64}(x, probs = seq(0, 1, 0.25), names = TRUE, method = NULL, ...)

\method{quantile}{integer64}(
  x,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  type = 0L,
  ...
)

\method{median}{integer64}(x, na.rm = FALSE, ...)

\method{mean}{integer64}(x, na.rm = FALSE, ...)

\method{summary}{integer64}(object, ...)
}
\arguments{
\item{x}{a integer64 vector}

\item{probs}{numeric vector of probabilities with values in \verb{[0,1]} - possibly containing \code{NA}s}

\item{...}{ignored}

\item{names}{logical; if \code{TRUE}, the result has a \code{names} attribute. Set to \code{FALSE} for speedup with many probs.}

\item{method}{NULL for automatic method selection or a suitable low-level method, see details}

\item{na.rm}{logical; if \code{TRUE}, any \code{NA} and \code{NaN}'s are removed from
\code{x} before the quantiles are computed.}

\item{type}{an integer selecting the quantile algorithm, currently only
0 is supported, see details}

\item{object}{a integer64 vector}
}
\value{
\code{prank} returns a numeric vector of the same length as \code{x}.

\code{qtile} returns a vector with elements from \code{x}
at the relative positions specified by \code{probs}.
}
\description{
Function \code{\link[=prank.integer64]{prank.integer64()}}  projects the values \verb{[min..max]} via ranks
\verb{[1..n]} to \verb{[0..1]}.
}
\details{
\code{qtile.ineger64} is the inverse function of 'prank.integer64' and projects
\verb{[0..1]} to \verb{[min..max]}.

Functions \code{quantile.integer64} with \code{type=0} and \code{median.integer64} are
convenience wrappers to \code{qtile}.

Function \code{qtile} behaves very similar to \code{quantile.default} with \code{type=1}
in that it only returns existing values, it is mostly symmetric but it is
using 'round' rather than 'floor'.

Note that this implies that \code{median.integer64} does not interpolate for even
number of values (interpolation would create values that could not be
represented as 64-bit integers).

This function automatically chooses from several low-level functions
considering the size of \code{x} and the availability of a cache.

Suitable methods are
\itemize{
\item \code{\link{sortqtl}} (fast sorting)
\item \code{\link{orderqtl}} (memory saving ordering).
}
}
\examples{
x <- as.integer64(sample(c(rep(NA, 9), 1:9), 32, TRUE))
qtile(x, probs=seq(0, 1, 0.25))
quantile(x, probs=seq(0, 1, 0.25), na.rm=TRUE)
median(x, na.rm=TRUE)
summary(x)

x <- x[!is.na(x)]
stopifnot(identical(x,  unname(qtile(x, probs=prank(x)))))
}
\seealso{
\code{\link[=rank.integer64]{rank.integer64()}} for simple ranks and \code{\link[=quantile]{quantile()}} for quantiles.
}
\keyword{univar}
