% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{HttpResponse}
\alias{HttpResponse}
\title{Base HTTP response object}
\description{
Class with methods for handling HTTP responses
}
\details{
\strong{Additional Methods}
\describe{
\item{\code{raise_for_ct(type, charset = NULL, behavior = "stop")}}{
Check response content-type; stop or warn if not matched. Parameters:
\itemize{
\item type: (character) a mime type to match against; see
\link[mime:mimemap]{mime::mimemap} for allowed values
\item charset: (character) if a charset string given, we check that
it matches the charset in the content type header. default: NULL
\item behavior: (character) one of stop (default) or warning
}
}
\item{\code{raise_for_ct_html(charset = NULL, behavior = "stop")}}{
Check that the response content-type is \code{text/html}; stop or warn if
not matched. Parameters: see \code{raise_for_ct()}
}
\item{\code{raise_for_ct_json(charset = NULL, behavior = "stop")}}{
Check that the response content-type is \code{application/json}; stop or
warn if not matched. Parameters: see \code{raise_for_ct()}
}
\item{\code{raise_for_ct_xml(charset = NULL, behavior = "stop")}}{
Check that the response content-type is \code{application/xml}; stop or warn if
not matched. Parameters: see \code{raise_for_ct()}
}
}
}
\section{R6 classes}{

This is an R6 class from the package \pkg{R6}. Find out more
about R6 at \url{https://r6.r-lib.org/}. After creating an instance of an R6
class (e.g., \code{x <- HttpClient$new(url = "https://httpbin.org")}) you can
access values and methods on the object \code{x}.
}

\examples{
\dontrun{
x <- HttpResponse$new(method = "get", url = "https://httpbin.org")
x$url
x$method

x <- HttpClient$new(url = 'https://httpbin.org')
(res <- x$get('get'))
res$request_headers
res$response_headers
res$parse()
res$status_code
res$status_http()
res$status_http()$status_code
res$status_http()$message
res$status_http()$explanation
res$success()

x <- HttpClient$new(url = 'https://httpbin.org/status/404')
(res <- x$get())
# res$raise_for_status()

x <- HttpClient$new(url = 'https://httpbin.org/status/414')
(res <- x$get())
# res$raise_for_status()
}
}
\seealso{
\link{content-types}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{method}}{(character) one or more URLs}

\item{\code{url}}{(character) one or more URLs}

\item{\code{opts}}{(character) one or more URLs}

\item{\code{handle}}{(character) one or more URLs}

\item{\code{status_code}}{(character) one or more URLs}

\item{\code{request_headers}}{(character) one or more URLs}

\item{\code{response_headers}}{(character) one or more URLs}

\item{\code{response_headers_all}}{(character) one or more URLs}

\item{\code{modified}}{(character) one or more URLs}

\item{\code{times}}{(character) one or more URLs}

\item{\code{content}}{(character) one or more URLs}

\item{\code{request}}{(character) one or more URLs}

\item{\code{raise_for_ct}}{for ct method (general)}

\item{\code{raise_for_ct_html}}{for ct method (html)}

\item{\code{raise_for_ct_json}}{for ct method (json)}

\item{\code{raise_for_ct_xml}}{for ct method (xml)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HttpResponse-print}{\code{HttpResponse$print()}}
\item \href{#method-HttpResponse-new}{\code{HttpResponse$new()}}
\item \href{#method-HttpResponse-parse}{\code{HttpResponse$parse()}}
\item \href{#method-HttpResponse-success}{\code{HttpResponse$success()}}
\item \href{#method-HttpResponse-status_http}{\code{HttpResponse$status_http()}}
\item \href{#method-HttpResponse-raise_for_status}{\code{HttpResponse$raise_for_status()}}
\item \href{#method-HttpResponse-clone}{\code{HttpResponse$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-print"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-print}{}}}
\subsection{Method \code{print()}}{
print method for HttpResponse objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-new"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-new}{}}}
\subsection{Method \code{new()}}{
Create a new HttpResponse object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$new(
  method,
  url,
  opts,
  handle,
  status_code,
  request_headers,
  response_headers,
  response_headers_all,
  modified,
  times,
  content,
  request
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(character) HTTP method}

\item{\code{url}}{(character) A url, required}

\item{\code{opts}}{(list) curl options}

\item{\code{handle}}{A handle}

\item{\code{status_code}}{(integer) status code}

\item{\code{request_headers}}{(list) request headers, named list}

\item{\code{response_headers}}{(list) response headers, named list}

\item{\code{response_headers_all}}{(list) all response headers, including
intermediate redirect headers, unnamed list of named lists}

\item{\code{modified}}{(character) modified date}

\item{\code{times}}{(vector) named vector}

\item{\code{content}}{(raw) raw binary content response}

\item{\code{request}}{request object, with all details}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-parse"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-parse}{}}}
\subsection{Method \code{parse()}}{
Parse the raw response content to text
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$parse(encoding = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encoding}}{(character) A character string describing the
current encoding. If left as \code{NULL}, we attempt to guess the
encoding. Passed to \code{from} parameter in \code{iconv}}

\item{\code{...}}{additional parameters passed on to \code{iconv} (options: sub,
mark, toRaw). See \code{?iconv} for help}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-success"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-success}{}}}
\subsection{Method \code{success()}}{
Was status code less than or equal to 201
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$success()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-status_http"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-status_http}{}}}
\subsection{Method \code{status_http()}}{
Get HTTP status code, message, and explanation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$status_http(verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{(logical) whether to get verbose http status description,
default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of class "http_code", a list with slots for status_code,
message, and explanation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-raise_for_status"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-raise_for_status}{}}}
\subsection{Method \code{raise_for_status()}}{
Check HTTP status and stop with appropriate
HTTP error code and message if >= 300. otherwise use \pkg{httpcode}.
If you have \code{fauxpas} installed we use that.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$raise_for_status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
stop or warn with message
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpResponse-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HttpResponse-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpResponse$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
