% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historic_co2.R
\docType{data}
\name{historic_co2}
\alias{historic_co2}
\title{Atmospheric carbon dioxide concentration over 800,000 years}
\format{An object of class \code{"data.frame"}.}
\source{
Mauna Loa data from \href{https://www.esrl.noaa.gov/gmd/ccgg/trends/data.html}{NOAA}. Ice core data from Bereiter et al. 2015 via \href{https://www.ncdc.noaa.gov/paleo-search/study/17975}{NOAA}.
}
\usage{
data(historic_co2)
}
\description{
Concentration of carbon dioxide in ppm by volume from direct measurements at Mauna Loa (1959-2018 CE) and indirect measurements from a series of Antarctic ice cores (approx. -800,000-2001 CE).
}
\details{
\itemize{
 \item year. Year (CE).
 \item co2. Carbon dioxide concentration in ppm by volume.
 \item source. Source of carbon dioxide measurement: direct CO2 annual mean concentrations from Mauna Loa (`Mauna Loa`) or indirect CO2 concentrations from air trapped in ice cores (`Ice Cores`).
}
}
\examples{
data(historic_co2)
head(historic_co2)
}
\keyword{datasets}
