% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_dots_used}
\alias{check_dots_used}
\title{Check that all dots have been used}
\arguments{
\item{env}{Environment in which to look for \code{...} and to set up handler.}

\item{action}{The action to take when the dots have not been used. One of
\code{\link[rlang:abort]{rlang::abort()}}, \code{\link[rlang:abort]{rlang::warn()}}, \code{\link[rlang:abort]{rlang::inform()}} or \code{\link[rlang:abort]{rlang::signal()}}.}
}
\description{
Automatically sets exit handler to run when function terminates, checking
that all elements of \code{...} have been evaluated. If you use \code{\link[=on.exit]{on.exit()}}
elsewhere in your function, make sure to use \code{add = TRUE} so that you
don't override the handler set up by \code{check_dots_used()}.
}
\examples{
f <- function(...) {
  check_dots_used()
  g(...)
}

g <- function(x, y, ...) {
  x + y
}
f(x = 1, y = 2)

try(f(x = 1, y = 2, z = 3))
try(f(x = 1, y = 2, 3, 4, 5))
}
