% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centr_degree}
\alias{centr_degree}
\alias{centralization.degree}
\title{Centralize a graph according to the degrees of vertices}
\usage{
centr_degree(graph, mode = c("all", "out", "in", "total"),
  loops = TRUE, normalized = TRUE)
}
\arguments{
\item{graph}{The input graph.}

\item{mode}{This is the same as the \code{mode} argument of
\code{degree}.}

\item{loops}{Logical scalar, whether to consider loops edges when
calculating the degree.}

\item{normalized}{Logical scalar. Whether to normalize the graph level
centrality score by dividing by the theoretical maximum.}
}
\value{
A named list with the following components:
  \item{res}{The node-level centrality scores.}
  \item{centralization}{The graph level centrality index.}
  \item{theoretical_max}{The maximum theoretical graph level
    centralization score for a graph with the given number of vertices,
    using the same parameters. If the \code{normalized} argument was
    \code{TRUE}, then the result was divided by this number.}
}
\description{
See \code{\link{centralize}} for a summary of graph centralization.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_degree(g)$centralization
centr_clo(g, mode = "all")$centralization
centr_betw(g, directed = FALSE)$centralization
centr_eigen(g, directed = FALSE)$centralization
}
\seealso{
Other centralization related: \code{\link{centr_betw_tmax}},
  \code{\link{centr_betw}}, \code{\link{centr_clo_tmax}},
  \code{\link{centr_clo}}, \code{\link{centr_degree_tmax}},
  \code{\link{centr_eigen_tmax}},
  \code{\link{centr_eigen}}, \code{\link{centralize}}
}
\concept{centralization related}
