% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.R
\name{cbind.mids}
\alias{cbind.mids}
\title{Combine \code{mids} objects by columns}
\usage{
cbind.mids(x, y = NULL, ...)
}
\arguments{
\item{x}{A \code{mids} object.}

\item{y}{A \code{mids} object, or a \code{data.frame}, \code{matrix},
\code{factor} or \code{vector}.}

\item{\dots}{Additional \code{data.frame}, \code{matrix}, \code{vector}
or \code{factor}. These can be given as named arguments.}
}
\value{
An S3 object of class \code{mids}
}
\description{
This function combines two \code{mids} objects columnwise into a single
object of class \code{mids}, or combines a single \code{mids} object with
a \code{vector}, \code{matrix}, \code{factor} or \code{data.frame}
columnwise into a \code{mids} object.
}
\details{
\emph{Pre-requisites:} If \code{y} is a \code{mids}-object, the rows
of \code{x$data} and \code{y$data} should match, as well as the number
of imputations (\code{m}). Other \code{y} are transformed into a
\code{data.frame} whose rows should match with \code{x$data}.

The function renames any duplicated variable or block names by
appending \code{".1"}, \code{".2"} to duplicated names.
}
\note{
The function constructs the elements of the new \code{mids} object as follows:
\tabular{ll}{
\code{data}     \tab Columnwise combination of the data in \code{x} and \code{y}\cr
\code{imp}      \tab Combines the imputed values from \code{x} and \code{y}\cr
\code{m}        \tab Taken from \code{x$m}\cr
\code{where}    \tab Columnwise combination of \code{x$where} and \code{y$where}\cr
\code{blocks}   \tab Combines \code{x$blocks} and \code{y$blocks}\cr
\code{call}     \tab Vector, \code{call[1]} creates \code{x}, \code{call[2]}
is call to \code{cbind.mids}\cr
\code{nmis}     \tab Equals \code{c(x$nmis, y$nmis)}\cr
\code{method}   \tab Combines \code{x$method} and \code{y$method}\cr
\code{predictorMatrix} \tab Combination with zeroes on the off-diagonal blocks\cr
\code{visitSequence}   \tab Combined as \code{c(x$visitSequence, y$visitSequence)}\cr
\code{formulas}  \tab Combined as \code{c(x$formulas, y$formulas)}\cr
\code{post}      \tab Combined as \code{c(x$post, y$post)}\cr
\code{blots}     \tab Combined as \code{c(x$blots, y$blots)}\cr
\code{ignore}    \tab Taken from \code{x$ignore}\cr
\code{seed}            \tab Taken from \code{x$seed}\cr
\code{iteration}       \tab Taken from \code{x$iteration}\cr
\code{lastSeedValue}   \tab Taken from \code{x$lastSeedValue}\cr
\code{chainMean}       \tab Combined from \code{x$chainMean} and \code{y$chainMean}\cr
\code{chainVar}        \tab Combined from \code{x$chainVar} and \code{y$chainVar}\cr
\code{loggedEvents}    \tab Taken from \code{x$loggedEvents}\cr
\code{version}    \tab Current package version\cr
\code{date}       \tab Current date\cr
}
}
\examples{

# impute four variables at once (default)
imp <- mice(nhanes, m = 1, maxit = 1, print = FALSE)
imp$predictorMatrix

# impute two by two
data1 <- nhanes[, c("age", "bmi")]
data2 <- nhanes[, c("hyp", "chl")]
imp1 <- mice(data1, m = 2, maxit = 1, print = FALSE)
imp2 <- mice(data2, m = 2, maxit = 1, print = FALSE)

# Append two solutions
imp12 <- cbind(imp1, imp2)

# This is a different imputation model
imp12$predictorMatrix

# Append the other way around
imp21 <- cbind(imp2, imp1)
imp21$predictorMatrix

# Append 'forgotten' variable chl
data3 <- nhanes[, 1:3]
imp3 <- mice(data3, maxit = 1, m = 2, print = FALSE)
imp4 <- cbind(imp3, chl = nhanes$chl)

# Of course, chl was not imputed
head(complete(imp4))

# Combine mids object with data frame
imp5 <- cbind(imp3, nhanes2)
head(complete(imp5))
}
\seealso{
\code{\link[base:cbind]{cbind}}, \code{\link{rbind.mids}}, \code{\link{ibind}},
\code{\link[=mids-class]{mids}}
}
\author{
Karin Groothuis-Oudshoorn, Stef van Buuren
}
\keyword{manip}
