% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{convergence}
\alias{convergence}
\title{Computes convergence diagnostics for a \code{mids} object}
\usage{
convergence(data, diagnostic = "all", parameter = "mean", ...)
}
\arguments{
\item{data}{An object of class \code{mids} as created by the function
\code{mice()}.}

\item{diagnostic}{A keyword. One of the following keywords: \code{"ac"},
\code{"all"}, \code{"gr"} and \code{"psrf"}. See the Details section
for the interpretation.
The default is \code{diagnostic = "all"} which returns both the
autocorrelation and potential scale reduction factor per iteration.}

\item{parameter}{A keyword. One of the following keywords: \code{"mean"}
or \code{"sd"} to evaluate chain means or chain standard deviations,
respectively.}

\item{\dots}{Additional arguments. Not used.}
}
\value{
A \code{data.frame} with the autocorrelation and/or potential
scale reduction factor per iteration of the MICE algorithm.
}
\description{
Takes an object of class \code{mids}, computes the autocorrelation
and/or potential scale reduction factor, and returns a \code{data.frame}
with the specified diagnostic(s) per iteration.
}
\details{
The argument \code{diagnostic} can be length-1 character, which is
matched to one of the following keywords:
\describe{
\item{\code{"all"}}{computes both the lag-1 autocorrelation as well as
the potential scale reduction factor (cf. Vehtari et al., 2021) per
iteration of the MICE algorithm;}
\item{\code{"ac"}}{computes only the autocorrelation per iteration;}
\item{\code{"psrf"}}{computes only the potential scale reduction factor
per iteration;}
\item{\code{"gr"}}{same as \code{psrf}, the potential scale reduction
factor is colloquially called the Gelman-Rubin diagnostic.}
}
In the unlikely event of perfect convergence, the autocorrelation equals
zero and the potential scale reduction factor equals one. To interpret
the convergence diagnostic(s) in the output of the function, it is
recommended to plot the diagnostics (ac and/or psrf) against the
iteration number (.it) per imputed variable (vrb). A persistently
decreasing trend across iterations indicates potential non-convergence.
}
\examples{

# obtain imputed data set
imp <- mice(nhanes2, print = FALSE)
# compute convergence diagnostics
convergence(imp)
}
\references{
Vehtari, A., Gelman, A., Simpson, D., Carpenter, B., & Burkner,
P.-C. (2021). Rank-Normalization, Folding, and Localization: An Improved
R for Assessing Convergence of MCMC. Bayesian Analysis, 1(1), 1-38.
https://doi.org/10.1214/20-BA1221
}
\seealso{
\code{\link{mice}}, \code{\link[=mids-class]{mids}}
}
\keyword{none}
