% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.R
\name{gini}
\alias{gini}
\alias{gini.default}
\alias{gini.glm}
\alias{gini.randomForest}
\alias{gini.glmerMod}
\alias{gini.gbm}
\alias{gini.rpart}
\title{GINI Coefficient}
\usage{
gini(...)

\method{gini}{default}(actual, predicted, ...)

\method{gini}{glm}(modelObject, ...)

\method{gini}{randomForest}(modelObject, ...)

\method{gini}{glmerMod}(modelObject, ...)

\method{gini}{gbm}(modelObject, ...)

\method{gini}{rpart}(modelObject, ...)
}
\arguments{
\item{\dots}{additional parameters to be passed the the s3 methods}

\item{actual}{A vector of the labels. Can be \code{numeric, character, or factor}}

\item{predicted}{A vector of predicted values}

\item{modelObject}{the model object. Currently supported \code{glm, randomForest, glmerMod, gbm}}
}
\description{
Calculates the GINI coefficient for a binary classifcation model
}
\examples{
data(testDF)
glmModel <- glm(y ~ ., data = testDF, family="binomial")
Preds <- predict(glmModel, type = 'response')

gini(testDF$y, Preds)
# using s3 method for glm
gini(glmModel)

}
