% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_factorstructure.R
\name{check_factorstructure}
\alias{check_factorstructure}
\title{Check suitability of data for Factor Analysis (FA)}
\usage{
check_factorstructure(x, ...)
}
\arguments{
\item{x}{A dataframe.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A list of lists of indices related to sphericity and KMO.
}
\description{
This checks whether the data is appropriate for Factor Analysis (FA) by
running the \link[=check_sphericity_bartlett]{Bartlett's Test of Sphericity} and
the \link[=check_kmo]{Kaiser, Meyer, Olkin (KMO) Measure of Sampling Adequacy (MSA)}.
}
\examples{
library(performance)
check_factorstructure(mtcars)
}
\seealso{
\code{\link[=check_kmo]{check_kmo()}}, \code{\link[=check_sphericity_bartlett]{check_sphericity_bartlett()}} and \code{\link[=check_clusterstructure]{check_clusterstructure()}}.
}
