% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.vsel}
\alias{plot.vsel}
\title{Plot summary statistics related to variable selection}
\usage{
\method{plot}{vsel}(
  x,
  nterms_max = NULL,
  stats = "elpd",
  deltas = FALSE,
  alpha = 0.32,
  baseline = NULL,
  ...
)
}
\arguments{
\item{x}{The object returned by \link[=varsel]{varsel} or
\link[=cv_varsel]{cv_varsel}.}

\item{nterms_max}{Maximum submodel size for which the statistics are
calculated. For \code{plot.vsel} it must be at least 1.}

\item{stats}{One or several strings determining which statistics to
  calculate. Available statistics are:
\itemize{
 \item{elpd:} {(Expected) sum of log predictive densities}
 \item{mlpd:} {Mean log predictive density, that is, elpd divided by the
  number of datapoints.} \item{mse:} {Mean squared error (gaussian family
  only)}
 \item{rmse:} {Root mean squared error (gaussian family only)}
 \item{acc/pctcorr:} {Classification accuracy (binomial family only)}
 \item{auc:} {Area under the ROC curve (binomial family only)}
}
Default is \code{"elpd"}.}

\item{deltas}{If \code{TRUE}, the submodel statistics are estimated relative
to the baseline model (see argument \code{baseline}) instead of estimating
the actual values of the statistics. Defaults to \code{FALSE}.}

\item{alpha}{A number indicating the desired coverage of the credible
intervals. For example \code{alpha=0.32} corresponds to 68\% probability
mass within the intervals, that is, one standard error intervals.}

\item{baseline}{Either 'ref' or 'best' indicating whether the baseline is the
reference model or the best submodel found. Default is 'ref' when the
reference model exists, and 'best' otherwise.}

\item{...}{Currently ignored.}
}
\description{
Plot summary statistics related to variable selection
}
\examples{
\donttest{
### Usage with stanreg objects
if (requireNamespace('rstanarm', quietly=TRUE)) {
  n <- 30
  d <- 5
  x <- matrix(rnorm(n*d), nrow=n)
  y <- x[,1] + 0.5*rnorm(n)
  data <- data.frame(x,y)

  fit <- rstanarm::stan_glm(y ~ X1 + X2 + X3 + X4 + X5, gaussian(),
    data=data, chains=2, iter=500)
  vs <- cv_varsel(fit)
  plot(vs)
}
}

}
