% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmap.R
\name{dmap}
\alias{dmap}
\alias{dmap_at}
\alias{dmap_if}
\title{Map over the columns of a data frame}
\usage{
dmap(.d, .f, ...)

dmap_at(.d, .at, .f, ...)

dmap_if(.d, .p, .f, ...)
}
\arguments{
\item{.d}{A data frame.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.at}{A character vector of names, positive numeric vector of
positions to include, or a negative numeric vector of positions to
exlude. Only those elements corresponding to \code{.at} will be modified.
If the \code{tidyselect} package is installed, you can use \code{vars()} and
the \code{tidyselect} helpers to select elements.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}
}
\description{
\code{dmap()} is just like \code{\link[purrr:map]{purrr::map()}} but always returns a
data frame. In addition, it handles grouped or sliced data frames.
}
\details{
\code{dmap_at()} and \code{dmap_if()} recycle length 1 vectors to
the group sizes.
}
\examples{
# dmap() always returns a data frame:
dmap(mtcars, summary)

# dmap() also supports sliced data frames:
sliced_df <- mtcars[1:5] \%>\% slice_rows("cyl")
sliced_df \%>\% dmap(mean)
sliced_df \%>\% dmap(~ .x / max(.x))

# This is equivalent to the combination of by_slice() and dmap()
# with 'rows' collation of results:
sliced_df \%>\% by_slice(dmap, mean, .collate = "rows")
}
