# Auto-generated by internal/make-exports.R

#' RcppRoll
#'
#' Efficient windowed / rolling operations. Each function
#' here applies an operation over a moving window of
#' size \code{n}, with (customizable) weights specified
#' through \code{weights}.
#'
#' The functions postfixed with \code{l} and \code{r}
#' are convenience wrappers that set \strong{l}eft
#' / \strong{r}ight alignment of the windowed operations.
#'
#' @name RcppRoll-exports
#' @param x A numeric vector or a numeric matrix.
#' @param n The window size. Ignored when \code{weights} is non-\code{NULL}.
#' @param weights A vector of length \code{n}, giving the weights for each
#'   element within a window. If \code{NULL}, we take unit weights of width \code{n}.
#' @param by Calculate at every \code{by}-th point rather than every point.
#' @param fill Either an empty vector (no fill), or a vector (recycled to)
#'   length 3 giving left, middle and right fills.
#' @param partial Partial application? Currently unimplemented.
#' @param align Align windows on the \code{"left"}, \code{"center"} or
#'   \code{"right"}.
#' @param normalize Normalize window weights, such that they sum to \code{n}.
#' @param na.rm Remove missing values?
NULL
#' @rdname RcppRoll-exports
#' @export
roll_mean <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_mean_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_meanr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_mean_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_meanl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_mean_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_median <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_median_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_medianr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_median_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_medianl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_median_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_min <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_min_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_minr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_min_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_minl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_min_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_max <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_max_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_maxr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_max_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_maxl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_max_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_prod <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_prod_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_prodr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_prod_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_prodl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_prod_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_sum <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sum_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_sumr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sum_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_suml <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sum_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_sd <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sd_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_sdr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sd_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_sdl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_sd_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
#' @rdname RcppRoll-exports
#' @export
roll_var <- function(x,
                    n = 1L,
                    weights = NULL,
                    by = 1L,
                    fill = numeric(0),
                    partial = FALSE,
                    align = c("center", "left", "right"),
                    normalize = TRUE,
                    na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_var_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_varr <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "right",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_var_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}

##' @rdname RcppRoll-exports
##' @export
roll_varl <- function(x,
                     n = 1L,
                     weights = NULL,
                     by = 1L,
                     fill = NA,
                     partial = FALSE,
                     align = "left",
                     normalize = TRUE,
                     na.rm = FALSE)
{
  if (!identical(partial, FALSE)) {
    warning("'partial' argument is currently unimplemented; using 'partial = FALSE'")
    partial <- FALSE
  }

  result <- roll_var_impl(
    x,
    as.integer(n),
    as.numeric(weights),
    as.integer(by),
    as.numeric(fill),
    as.logical(partial),
    as.character(match.arg(align)),
    as.logical(normalize),
    as.logical(na.rm)
  )
  colnames(result) <- colnames(x)
  result
}
