% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{populate}
\alias{populate}
\title{Add Assessment Indices}
\usage{
populate(x, ...)
}
\arguments{
\item{x}{A \code{rsplit} and \code{rset} object.}

\item{...}{Not currently used}
}
\value{
An object of the same kind with the integer indices.
}
\description{
Many \code{rsplit} and \code{rset} objects do not contain indicators for
the assessment samples. \code{populate()} can be used to fill the slot
for the appropriate indices.
}
\examples{
set.seed(28432)
fold_rs <- vfold_cv(mtcars)

fold_rs$splits[[1]]$out_id
complement(fold_rs$splits[[1]])

populate(fold_rs$splits[[1]])$out_id

fold_rs_all <- populate(fold_rs)
fold_rs_all$splits[[1]]$out_id
}
