% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateSelectInput}
\alias{updateSelectInput}
\alias{updateSelectizeInput}
\alias{updateVarSelectInput}
\alias{updateVarSelectizeInput}
\title{Change the value of a select input on the client}
\usage{
updateSelectInput(session, inputId, label = NULL, choices = NULL,
  selected = NULL)

updateSelectizeInput(session, inputId, label = NULL, choices = NULL,
  selected = NULL, options = list(), server = FALSE)

updateVarSelectInput(session, inputId, label = NULL, data = NULL,
  selected = NULL)

updateVarSelectizeInput(session, inputId, label = NULL, data = NULL,
  selected = NULL, options = list(), server = FALSE)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{choices}{List of values to select from. If elements of the list are
named, then that name rather than the value is displayed to the user.
This can also be a named list whose elements are (either named or
unnamed) lists or vectors. If this is the case, the outermost names
will be used as the "optgroup" label for the elements in the respective
sublist. This allows you to group and label similar choices. See the
example section for a small demo of this feature.}

\item{selected}{The initially selected value (or multiple values if
\code{multiple = TRUE}). If not specified then defaults to the first value
for single-select lists and no values for multiple select lists.}

\item{options}{A list of options. See the documentation of \pkg{selectize.js}
for possible options (character option values inside \code{\link[base]{I}()} will
be treated as literal JavaScript code; see \code{\link{renderDataTable}()}
for details).}

\item{server}{whether to store \code{choices} on the server side, and load
the select options dynamically on searching, instead of writing all
\code{choices} into the page at once (i.e., only use the client-side
version of \pkg{selectize.js})}

\item{data}{A data frame. Used to retrieve the column names as choices for a \code{\link{selectInput}}}
}
\description{
Change the value of a select input on the client
}
\details{
The input updater functions send a message to the client, telling it to
change the settings of an input object. The messages are collected and sent
after all the observers (including outputs) have finished running.

The syntax of these functions is similar to the functions that created the
inputs in the first place. For example, \code{\link{numericInput}()} and
\code{updateNumericInput()} take a similar set of arguments.

Any arguments with NULL values will be ignored; they will not result in any
changes to the input object on the client.

For \code{\link{radioButtons}()}, \code{\link{checkboxGroupInput}()} and
\code{\link{selectInput}()}, the set of choices can be cleared by using
\code{choices=character(0)}. Similarly, for these inputs, the selected item
can be cleared by using \code{selected=character(0)}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  p("The checkbox group controls the select input"),
  checkboxGroupInput("inCheckboxGroup", "Input checkbox",
    c("Item A", "Item B", "Item C")),
  selectInput("inSelect", "Select input",
    c("Item A", "Item B", "Item C"))
)

server <- function(input, output, session) {
  observe({
    x <- input$inCheckboxGroup

    # Can use character(0) to remove all choices
    if (is.null(x))
      x <- character(0)

    # Can also set the label and select items
    updateSelectInput(session, "inSelect",
      label = paste("Select input label", length(x)),
      choices = x,
      selected = tail(x, 1)
    )
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{selectInput}} \code{\link{varSelectInput}}
}
