# .starts must be before .stops

    Code
      (expect_error(hop(1:5, c(2, 3, 1), c(1, 1, 2), identity)))
    Output
      <error/rlang_error>
      Error:
      i In locations: 1 and 2
      i In the ranges generated by `.starts` and `.stops`:
      ! The start of the range can't be after the end of the range.
    Code
      (expect_error(hop(1:5, c(2, 3, 1), c(1, 1, 2), identity)))
    Output
      <error/rlang_error>
      Error:
      i In locations: 1 and 2
      i In the ranges generated by `.starts` and `.stops`:
      ! The start of the range can't be after the end of the range.

# empty `.x`, but size `n > 0` `.starts` and `.stops`: sizes and types are checked first

    Code
      (expect_error(hop(integer(), 1:3, 1:2, ~.x), class = "vctrs_error_incompatible_size")
      )
    Output
      <error/vctrs_error_incompatible_size>
      Error in `hop()`:
      ! Can't recycle `starts` (size 3) to match `stops` (size 2).
    Code
      (expect_error(hop(integer(), 1, "x", ~.x), class = "vctrs_error_subscript_type")
      )
    Output
      <error/vctrs_error_subscript_type>
      Error in `hop()`:
      ! Can't subset elements with `.stops`.
      x `.stops` must be numeric, not the string "x".

# .starts must not contain NA values

    Code
      (expect_error(hop(1:2, c(1, NA), 1:2, identity), class = "slider_error_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_endpoints_cannot_be_na>
      Error in `hop()`:
      i In locations: 2
      ! `.starts` can't be `NA`.
    Code
      (expect_error(hop(1:2, c(NA, 1), 1:2, identity), class = "slider_error_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_endpoints_cannot_be_na>
      Error in `hop()`:
      i In locations: 1
      ! `.starts` can't be `NA`.

# .stops must not contain NA values

    Code
      (expect_error(hop(1:2, 1:2, c(1, NA), identity), class = "slider_error_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_endpoints_cannot_be_na>
      Error in `hop()`:
      i In locations: 2
      ! `.stops` can't be `NA`.
    Code
      (expect_error(hop(1:2, 1:2, c(NA, 1), identity), class = "slider_error_endpoints_cannot_be_na")
      )
    Output
      <error/slider_error_endpoints_cannot_be_na>
      Error in `hop()`:
      i In locations: 1
      ! `.stops` can't be `NA`.

# recycling is used for .starts/.stops

    Code
      expect_error(hop(1:2, 1:2, 1:3, ~.x), class = "vctrs_error_incompatible_size")

# `.starts` and `.stops` must be integerish

    Code
      (expect_error(hop(1, "x", 1, identity), class = "vctrs_error_subscript_type"))
    Output
      <error/vctrs_error_subscript_type>
      Error in `hop()`:
      ! Can't subset elements with `.starts`.
      x `.starts` must be numeric, not the string "x".
    Code
      (expect_error(hop(1, 1, "x", identity), class = "vctrs_error_subscript_type"))
    Output
      <error/vctrs_error_subscript_type>
      Error in `hop()`:
      ! Can't subset elements with `.stops`.
      x `.stops` must be numeric, not the string "x".

# `error_call` and `.error_call` args aren't swallowed

    Code
      hop(1, 1, 1, fn, error_call = call("foo"))
    Condition
      Error in `foo()`:
      ! hi

---

    Code
      hop(1, 1, 1, fn_dot, .error_call = call("foo"))
    Condition
      Error in `foo()`:
      ! hi

