% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmatrix.R
\name{wmatrix}
\alias{wmatrix}
\alias{logwmatrix}
\alias{linwmatrix}
\alias{is.wmatrix}
\alias{is.logwmatrix}
\alias{is.linwmatrix}
\alias{as.linwmatrix}
\alias{as.logwmatrix}
\alias{as.linwmatrix.linwmatrix}
\alias{as.linwmatrix.logwmatrix}
\alias{as.logwmatrix.logwmatrix}
\alias{as.logwmatrix.linwmatrix}
\alias{as.linwmatrix.matrix}
\alias{as.logwmatrix.matrix}
\alias{print.wmatrix}
\alias{print.logwmatrix}
\alias{print.linwmatrix}
\alias{compress_rows.logwmatrix}
\alias{compress_rows.linwmatrix}
\alias{decompress_rows.wmatrix}
\alias{[.wmatrix}
\alias{[<-.wmatrix}
\title{A data matrix with row weights}
\usage{
logwmatrix(
  data = NA,
  nrow = 1,
  ncol = 1,
  byrow = FALSE,
  dimnames = NULL,
  w = NULL
)

linwmatrix(
  data = NA,
  nrow = 1,
  ncol = 1,
  byrow = FALSE,
  dimnames = NULL,
  w = NULL
)

is.wmatrix(x)

is.logwmatrix(x)

is.linwmatrix(x)

as.linwmatrix(x, ...)

as.logwmatrix(x, ...)

\method{as.linwmatrix}{linwmatrix}(x, ...)

\method{as.linwmatrix}{logwmatrix}(x, ...)

\method{as.logwmatrix}{logwmatrix}(x, ...)

\method{as.logwmatrix}{linwmatrix}(x, ...)

\method{as.linwmatrix}{matrix}(x, w = NULL, ...)

\method{as.logwmatrix}{matrix}(x, w = NULL, ...)

\method{print}{wmatrix}(x, ...)

\method{print}{logwmatrix}(x, ...)

\method{print}{linwmatrix}(x, ...)

\method{compress_rows}{logwmatrix}(x, ...)

\method{compress_rows}{linwmatrix}(x, ...)

\method{decompress_rows}{wmatrix}(x, target.nrows = NULL, ...)

\method{[}{wmatrix}(x, i, j, ..., drop = FALSE)

\method{[}{wmatrix}(x, i, j, ...) <- value
}
\arguments{
\item{data, nrow, ncol, byrow, dimnames}{passed to \code{\link{matrix}}.}

\item{w}{row weights on the appropriate scale.}

\item{x}{an object to be coerced or tested.}

\item{...}{extra arguments, currently unused.}

\item{target.nrows}{the approximate number of rows the uncompressed matrix
should have; if not achievable exactly while respecting proportionality, a
matrix with a slightly different number of rows will be constructed.}

\item{i, j, value}{rows and columns and values for extraction or
replacement; as \code{\link{matrix}}.}

\item{drop}{Used for consistency with the generic. Ignored, and
always treated as \code{FALSE}.}
}
\value{
An object of class \code{linwmatrix}/\code{logwmatrix} and \code{wmatrix},
which is a \code{\link{matrix}} but also has an attribute \code{w} containing
row weights on the linear or the natural-log-transformed scale.
}
\description{
A representation of a numeric matrix with row weights, represented
on either linear (\code{linwmatrix}) or logarithmic (\code{logwmatrix})
scale.
}
\note{
Note that \code{wmatrix} itself is an "abstract" class: you cannot
instantiate it.

Note that at this time, \code{wmatrix} is designed as, first and
foremost, as class for storing compressed data matrices, so most
methods that operate on matrices may not handle the weights
correctly and may even cause them to be lost.
}
\examples{
(m <- matrix(1:3, 2, 3, byrow=TRUE))
(m <- rbind(m, 3*m, 2*m, m))
(mlog <- as.logwmatrix(m))
(mlin <- as.linwmatrix(m))
(cmlog <- compress_rows(mlog))
(cmlin <- compress_rows(mlin))

stopifnot(all.equal(as.linwmatrix(cmlog),cmlin))

cmlog[2,] <- 1:3
(cmlog <- compress_rows(cmlog))
stopifnot(sum(rowweights(cmlog))==nrow(m))

(m3 <- matrix(c(1:3,(1:3)*2,(1:3)*3), 3, 3, byrow=TRUE))
(rowweights(m3) <- c(4, 2, 2))

stopifnot(all.equal(compress_rows(as.logwmatrix(m)), as.logwmatrix(m3),check.attributes=FALSE))
stopifnot(all.equal(rowweights(compress_rows(as.logwmatrix(m))),
                    rowweights(as.logwmatrix(m3)),check.attributes=FALSE))
}
\seealso{
\code{\link{rowweights}}, \code{\link{lrowweights}}, \code{\link{compress_rows}}
}
