% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{use_travis}
\alias{use_coverage}
\alias{use_appveyor}
\title{Continuous integration setup and badges}
\usage{
use_travis(browse = interactive())

use_coverage(type = c("codecov", "coveralls"))

use_appveyor(browse = interactive())
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{type}{Which web service to use for test reporting. Currently supports
\href{https://codecov.io}{Codecov} and \href{https://coveralls.io}{Coveralls}.}
}
\description{
Sets up continuous integration (CI) services for an R package that is
developed on GitHub. CI services can run \code{R CMD check} automatically on
various platforms, triggered by each push or pull request. These functions
\itemize{
\item Add service-specific configuration files and add them to \code{.Rbuildignore}.
\item Activate a service or give the user a detailed prompt.
\item Provide the markdown to insert a badge into README.
}
}
\section{\code{use_travis()}}{

Adds a basic \code{.travis.yml} to the top-level directory of a package. This is a
configuration file for the \href{https://travis-ci.org/}{Travis CI} continuous
integration service.
}

\section{\code{use_coverage()}}{

Adds test coverage reports to a package that is already using Travis CI.
}

\section{\code{use_appveyor()}}{

Adds a basic \code{appveyor.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://www.appveyor.com}{AppVeyor} continuous
integration service for Windows.
}

