% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{proj_utils}
\alias{proj_utils}
\alias{proj_get}
\alias{proj_set}
\alias{proj_path}
\title{Utility functions for the active project}
\usage{
proj_get(quiet = FALSE)

proj_set(path = ".", force = FALSE, quiet = FALSE)

proj_path(..., ext = "")
}
\arguments{
\item{quiet}{Logical. Whether to announce project activation.}

\item{path}{Path to set.}

\item{force}{If \code{TRUE}, use this path without checking the usual criteria.
Use sparingly! The main application is to solve a temporary chicken-egg
problem: you need to set the active project in order to add
project-signalling infrastructure, such as initialising a Git repo or
adding a DESCRIPTION file.}

\item{...}{character vectors, if any values are NA, the result will also be
NA.}

\item{ext}{An optional extension to append to the generated path.}
}
\description{
Most \code{use_*()} functions act on the \strong{active project}. If it is
unset, usethis uses \href{https://rprojroot.r-lib.org}{rprojroot} to
find the project root of the current working directory. It establishes the
project root by looking for a \code{.here} file, an RStudio Project, a package
\code{DESCRIPTION}, Git infrastructure, a \code{remake.yml} file, or a \code{.projectile}
file. It then stores the active project for use for the remainder of the
session.
}
\details{
In general, end user code should not call \code{usethis::proj_get()},
\code{usethis::proj_set()}, or \code{usethis::proj_path()}. They are internal functions
that are exported for occasional interactive use or use in packages that
extend usethis. End user code should call functions in
\href{https://rprojroot.r-lib.org}{rprojroot} or its simpler companion,
\href{https://here.r-lib.org}{here}, to programmatically detect a project and
build paths within it.
}
\section{Functions}{
\itemize{
\item \code{proj_get}: Retrieves the active project and, if necessary, attempts to set it in the first place.

\item \code{proj_set}: Sets the active project.

\item \code{proj_path}: Builds a path within the active project. Thin wrapper
around \code{\link[fs:path]{fs::path()}}.
}}

\examples{
\dontrun{
## see the active project
proj_get()

## manually set the active project
proj_set("path/to/target/project")

## build a path within the active project (both produce same result)
proj_path("R/foo.R")
proj_path("R", "foo", ext = "R")
}
}
\seealso{
Other project functions: \code{\link{proj_sitrep}}
}
\concept{project functions}
