% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools.R
\name{extractDownstreamStatistics}
\alias{extractDownstreamStatistics}
\title{Extract downstream statistics}
\usage{
extractDownstreamStatistics(object, dge.name = NULL, reads.by.cell = NULL,
  min.umi = 250, read.stats = NULL)
}
\arguments{
\item{object}{The exact location of the folder containing the analyzed data.}

\item{dge.name}{The file containing the DGE. If none is provided, the function assumes
that DGE is stored under the name \code{dge.txt.gz}.}

\item{reads.by.cell}{The \code{data.frame} containing the reads per cell. If none is
provided, the function tries to read the file \code{out_readcounts.txt.gz}.}

\item{min.umi}{The minimum number of UMIs to keep a cell and not discard it.}

\item{read.stats}{A \code{data.frame} containing read statistics, as it is produced
by the function \code{extractReadStatistics}.}
}
\description{
Extract downstream basic statistics such as cell number, median numger of reads,
genes, UMIs per cell. The \code{data.table} package is used for fast reading
of the DGE matrices.
}
