######
# Creating a custom cursor
######

## This data is in X bitmap format, and can be created with the 'bitmap'
## utility in X11
cursor1_width <- 16
cursor1_height <- 16
cursor1_bits <- c(0x80, 0x01, 0x40, 0x02, 0x20, 0x04, 0x10, 0x08, 0x08, 0x10,
                  0x04, 0x20, 0x82, 0x41, 0x41, 0x82, 0x41, 0x82, 0x82, 0x41,
                  0x04, 0x20, 0x08, 0x10, 0x10, 0x08, 0x20, 0x04, 0x40, 0x02,
                  0x80, 0x01)
 
cursor1mask_bits <- c(0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c, 0x18,
                      0x18, 0x8c, 0x31, 0xc6, 0x63, 0x63, 0xc6, 0x63, 0xc6,
                      0xc6, 0x63, 0x8c, 0x31, 0x18, 0x18, 0x30, 0x0c, 0x60,
                      0x06, 0xc0, 0x03, 0x80, 0x01)
 
fg <- c(65535, 0, 0) # Red.
bg <- c(0, 0, 65535) # Blue.
 
 
source <- gdkBitmapCreateFromData(NULL, cursor1_bits,
                                  cursor1_width, cursor1_height)
mask <- gdkBitmapCreateFromData(NULL, cursor1mask_bits,
                                cursor1_width, cursor1_height)
cursor <- gdkCursorNewFromPixmap(source, mask, fg, bg, 8, 8)

widget[["window"]]$setCursor(cursor)
