///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef.h"
using namespace std;
using namespace rheolef;

// first test:
point normal (const point& x) { return x/norm(x); }; // normal in X on C(0,1) is vector OX:
// note: div_s(n) = d-1

// second test:
point u (const point& x) { 
       return point (x[0]*x[1], x[1]*x[2], (x[0] + x[1])*x[2]); 
}; 
// exact solution  
Float div_u (const point& x) { 
     return   x[0] + 2*x[1] + x[2]
            - 2*x[1]*sqr(x[0]) 
            - 2*x[2]*sqr(x[1]) 
            - 2*x[0]*sqr(x[2]) 
            - 2*x[1]*sqr(x[2]) ; 
}
int main (int argc, char**argv) {
  geo omega (argv[1]);
  bool test_normal = (argc > 2) ? (argv[2] == string("-normal")) : false;
  Float tol = (argc > 3) ? atof(argv[3]) : 1e-7;
  space Xh  (omega, "P1");
  space Xvh (omega, "P1", "vector");
  form ms (Xh, Xh,  "mass");
  form bs (Xvh, Xh, "div");

  // compute div_h = div_s(uh)
  field nh = interpolate (Xvh, normal);
  field uh = test_normal ? nh : interpolate (Xvh, u);
  field lh = bs*uh;
  ssk<Float> fact_ms = ldlt(ms.uu);
  field div_h(Xh);
  div_h.u = fact_ms.solve(lh.u);
  
  size_t d = omega.dimension();
  field pi_h_div_u = test_normal ? field(Xh, d-1) : interpolate (Xh, div_u); 
  field err_h  = div_h - pi_h_div_u; 
  Float err_l2   = sqrt(ms(err_h, err_h));
  Float err_linf = err_h.max_abs();
  cerr << "ndof     = " << Xh.size() << endl
       << "err_l2   = " << err_l2 << endl
       << "err_linf = " << err_linf << endl;
  return (err_linf <= tol) ? 0 : 1;
}
