/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;

public class REXPList
extends REXPVector {
    private RList payload;

    public REXPList(RList rList) {
        this.payload = rList == null ? new RList() : rList;
    }

    public REXPList(RList rList, REXPList rEXPList) {
        super(rEXPList);
        this.payload = rList == null ? new RList() : rList;
    }

    public REXPList(REXP rEXP, String string) {
        this.payload = new RList(new REXP[]{rEXP}, new String[]{string});
    }

    public Object asNativeJavaObject() throws REXPMismatchException {
        REXPGenericVector rEXPGenericVector = new REXPGenericVector(this.payload);
        return rEXPGenericVector.asNativeJavaObject();
    }

    public int length() {
        return this.payload.size();
    }

    public boolean isList() {
        return true;
    }

    public boolean isPairList() {
        return true;
    }

    public boolean isRecursive() {
        return true;
    }

    public RList asList() {
        return this.payload;
    }

    public String toString() {
        return super.toString() + (this.asList().isNamed() ? "named" : "");
    }

    public String toDebugString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toDebugString() + "{");
        for (n = 0; n < this.payload.size() && n < maxDebugItems; ++n) {
            String string;
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            if ((string = this.payload.keyAt(n)) != null) {
                stringBuffer.append(string + "=");
            }
            stringBuffer.append(this.payload.at(n).toDebugString());
        }
        if (n < this.payload.size()) {
            stringBuffer.append(",..");
        }
        return stringBuffer.toString() + "}";
    }
}

