		     СЛОВАРЬ РУССКИХ ПРОИЗНОШЕНИЙ

Словарь русских произношений RuLex предназначен в первую очередь для
совместного использования с синтезатором речи Ru_tts. После его
установки достаточно добавлять в строку вызова Ru_tts ключ
"-s /usr/local/share/freespeech/rulex.db" и содержимое словаря будет
приниматься во внимание при синтезе речи.


			   Базовые понятия

Основу пакета составляет лексическая база данных, содержащая
информацию о произношении слов русского языка. Она в свою очередь
состоит из шести наборов данных: двух словарей (прямого и косвенного) и
четырех наборов правил (общие правила, классификаторы приставок и
окончаний и корректоры). Для записи русских букв используется
кодировка koi8-r.

Прямой словарь содержит информацию о произношении непосредственно
входящих в него слов. Косвенный словарь включает в себя слова в так
называемой базовой форме. На основе этой информации строится
произношения для всевозможных производных форм. Понятие базовой формы
здесь условно и не связано с аналогичными понятиями, принятыми в
языкознании.

Общие правила позволяют определить позицию ударения в словах, где
это можно сделать, опираясь исключительно на формальные признаки.

Классификаторами мы здесь называем правила, сопоставляющие производной
форме слова базовую. Сюда относятся две группы правил: классификаторы
приставок, выделяющие базовую форму посредством обрезания приставки, и
классификаторы окончаний, формирующие базовую форму путем унификации
окончания.

Корректоры - это вспомогательная система правил. Они используются на
последнем этапе конструирования произношения для внесения необходимых
поправок в ряде специальных случаев.

Словарь представляет из себя набор строк (записей или словарных
статей), состоящих из двух полей: Собственно слово и его
произношение. Ударная гласная отмечается знаком "+" непосредственно
после нее. Можно использовать также знак "=" для обозначения так
называемых слабых ударений там, где это может быть целесообразным,
например, в некоторых составных словах. Поля отделены друг от друга
одним пробелом. В первом поле допускаются лишь малые буквы русского
алфавита. Второе может содержать кроме того знаки "+", "=" и "-". Знак
"-" используется для разделения некоторых сложных слов.

Везде далее в тексте термин "словарь" будет подразумевать именно этот
формат представления данных.

Правила также представлены текстовыми строками, состоящими из одного
или двух полей. Первое поле - всегда регулярное выражение,
определяющее область применения правила. Формат и смысл второго поля
различен для разных наборов: в общих правилах второе поле отсутствует,
в классификаторах приставок и окончаний это префикс или суффикс
базовой формы соответственно (если нужен), а в корректорах это
строка регулярной замены.


		   Алгоритм генерации произношений

Полный цикл поиска информации в лексической базе данных и генерации
произношения для заданного слова состоит из четырех стадий.

1) Слово ищется в прямом словаре. Если поиск оказывается
   результативным, из словаря извлекается строка произношения и
   осуществляется переход к четвертой стадии.

2) Слово трактуется как производная форма. Последовательно
   просматриваются оба набора классификаторов. Регулярное выражение,
   содержащееся в первом поле, сопоставляется с исходным словом и,
   если соответствие имеет место, строится базовая форма, которая и
   отыскивается в косвенном словаре. Этот процесс продолжается либо до
   первого успешного поиска, либо до исчерпания системы
   классификаторов. В случае успешного поиска, строка произношения для
   исходного слова строится подобно тому, как это сделано в словаре
   для базовой формы, после чего осуществляется переход к четвертой
   стадии. Базовая форма строится путем замены в исходном слове
   подстроки, соответствующей регулярному выражению, содержащемуся в
   первом поле, на содержание второго. При этом в случае
   классификаторов приставок имеется в виду все регулярное выражение
   целиком, в случае же классификаторов окончаний - лишь вторая его
   часть, лежащая правее области сопоставления первого подвыражения,
   заключенного в скобки.

3) К слову применяются общие правила. Система правил просматривается
   последовательно. Регулярное выражение сопоставляется с исходным
   словом и, если обнаружено соответствие, в слово вставляется символ
   "+", отмечающий позицию ударения, непосредственно вслед за областью
   сопоставления первого подвыражения, заключенного в скобки. Процесс
   продолжается до первого удачного сопоставления или до исчерпания
   набора правил. Если подходящего правила найти не удается, процесс
   считается безрезультатным и бесславно завершается.

4) Окончательная коррекция строки произношения. Система корректоров
   просматривается последовательно. Регулярное выражение, содержащееся
   в первом поле, сопоставляется с полученной на предыдущих этапах
   строкой произношения. В случае соответствия выполняется регулярная
   замена в соответствии с содержимым второго поля. Цифрами в строке
   замены обозначаются области сопоставления соответствующих
   подвыражений.


			Компиляция и установка

Исходные тексты всех описанных наборов данных составляют основное
содержание подкаталога data. Там же лежит и тестовый словарь,
включающий в себя более 400 тысяч слов.

Чтобы использовать лексическую базу данных, ее необходимо
скомпилировать. Так как данный проект использует средства GNU Autotools,
прежде всего его нужно сконфигурировать командами:

autoreconf -ifs
./configure

После чего создание лексической базы выполняется командой:

make db

В результате этих действий в подкаталоге data будет создан файл
lexicon, содержащий скомпилированную базу данных. Ее можно установить
командой:

make install-db

А команда

make install

устанавливает весь пакет, включающий в себя не только саму базу
данных, но и сопутствующие средства поддержки.

Разумеется, для выполнения установки необходимы права
суперпользователя.

Перекомпилировать утилиту поддержки можно командой:

make lexholder


Замечание 1. Чтобы файл базы данных, изготовленный утилитой
Lexholder-ru, воспринимался синтезатором Ru_tts, обе программы должны
использовать одни и те же библиотеки поддержки баз данных. Версии тоже
имеют значение. Вообще говоря, логично ожидать, что файл,
изготовленный при помощи библиотеки более старой версии будет читаться
процедурами той же библиотеки более новой версии, но это вполне может
оказаться и не так. Для динамически скомпилированных исполняемых
файлов точную информацию об используемых библиотеках можно получить
при помощи команды "ldd".

Замечание 2. В версиях RuLex начиная с 2.0 используется новый формат
лексической базы данных. Синтезатор Ru_tts версий ниже 2.0 с ним
работать не будет.

Замечание 3. При удалении записей из лексической базы данных
дисковое пространство не освобождается. Более того, при добавлении
новых записей размер базы может неоправданно возрастать. Более
компактного представления базы после множественных модификаций можно
добиться путем полного ее пересоздания.


			  Утилита поддержки

Утилита lexholder-ru позволяет модифицировать, удалять и добавлять
записи в лексической базе данных из командной строки или скрипта.
Она позволяет также извлекать из базы данные во внешнем
представлении.

Формат вызова:

lexholder-ru [options] <DB_path>

Параметр <DB_path> - обязательный. Он должен указывать путь к
лексической базе данных. При пополнении базы новые данные читаются из
потока стандартного ввода. При извлечении данных результаты выводятся
в поток стандартного вывода. Однако при помощи ключа "-f" можно
указать файл, который будет использоваться вместо стандартных потоков
ввода и вывода.

Для удобства рассмотрения все ключи, воспринимаемые утилитой
lexholder-ru в командной строке, логично разбить на несколько групп по
принципу их функционального назначения.

К первой группе относятся ключи, определяющие действие. В командной
строке может присутствовать не более одного из них: лишь одна операция
выполняется за один вызов. Если никаких действий в командной строке
явно не указано, программа читает новые записи из потока стандартного
ввода или файла, указанного ключом "-f", и вносит их в базу данных.

-h -- Краткая справка об использовании программы.

Все остальное содержимое командной строки полностью игнорируется. Это
единственный случай, когда указание пути к базе данных не требуется.

-l -- Вывод содержимого базы в исходном формате.

Эта операция требует явного указания набора данных при помощи одного
из ключей "-X", "-M", "-G", "-L", "-P" или "-C".

-s <word> -- Поиск информации о произношении слова <word>.

В случае успешного поиска строка произношения для заданного слова
выводится в поток стандартного вывода или в файл, указанный ключом
"-f", и программа возвращает код успешного завершения. Если для
данного слова никакой информации в базе данных не нашлось, то в
качестве строки произношения возвращается само слово, записанное
малыми буквами, и программа завершается с ненулевым кодом
возврата. Если в командной строке присутствует ключ "-q", строка
произношения не генерируется, но о результатах поиска можно судить по
коду завершения программы.

-b <word> -- Поиск возможных базовых форм для слова <word>.

Заданное слово трактуется как производная форма и, если ключ "-q" не
упомянут в командной строке, конструируются и выводятся все возможные
варианты для данного слова, которые могут быть использованы в
косвенном словаре, вместе с номерами соответствующих
классификаторов окончаний. Классификаторы приставок при этом не
используются. Программа завершается успешно, если заданное слово
удается трактовать как производную форму. Ключ "-q" подавляет вывод
информации. В этом случае о результатах выполнения операции можно
судить по коду завершения программы.

-t <file> -- Проверка лексической базы данных по тестовому словарю.

Текстовый файл, указываемый в качестве параметра, должен содержать
тестовый словарь в формате, описанном выше. Программа сравнивает
указанные в тестовом словаре произношения с получаемыми из лексической
базы данных и выводит в поток стандартного вывода или в файл, заданный
ключом "-f", записи, для которых было обнаружено несоответствие. Если
в качестве параметра этого ключа указать "-", тестовый словарь будет
читаться из потока стандартного ввода.

-d <key> -- Удаление из базы данных записи с заданным ключом.

Эта операция требует явного указания набора данных при помощи одного
из ключей "-X", "-M", "-G", "-L", "-P" или "-C". Для правил в качестве
ключа используется их порядковый номер в наборе.

-D -- Удаление набора данных.

Набор данных необходимо явно указать при помощи одного из ключей "-X",
"-M", "-G", "-L", "-P" или "-C". Удаляется полностью все содержимое
выбранного набора данных.

-c -- Очистка базы данных от лишней информации.

Из базы данных удаляются записи, не оказывающие никакого влияния на
результаты полного поиска. Этот процесс затрагивает только словари. Из
прямого словаря удаляются записи, дублирующие информацию, которая
может быть получена на основании косвенного словаря или системы
общих правил. Из косвенного словаря удаляются записи, не являющиеся
на самом деле базовыми формами в соответствии с системой
классификаторов окончаний. При помощи ключей "-X" и "-M" можно выбрать
лишь один из этих словарей, который будет задействован в
процессе. Если посредством ключа "-M" выбран словарь базовых форм, из
него удаляются также вхождения, которые предположительно могут быть
получены путем присоединения известных приставок. В общем случае столь
интенсивная очистка является избыточной и приводит к утрате ряда
полезных вхождений.


Следующая группа ключей посвящена выбору набора данных. Ключи этой
группы являются взаимоисключающими. Они влияют на выполнение операций
вставки, удаления и извлечения содержимого базы данных. При удалении и
извлечении содержимого набор данных должен быть указан
явно. Добавление словарных статей можно выполнять без явного указания
словаря. В этом случае новая запись помещается в косвенный словарь,
если ее удается трактовать как базовую форму, в противном случае - в
прямой словарь. Для правил же необходимо всегда явно указывать
набор.

-X -- Прямой словарь.

-M -- Косвенный словарь.

-G -- Общие правила.

-L -- Классификаторы окончаний.

-P -- Классификаторы приставок.

-C -- Корректоры.


следующая группа ключей управляет процессом поиска информации в
лексической базе данных, позволяя включать в него лишь те или иные
явно заданные стадии. По умолчанию, то есть при отсутствии ключей этой
группы в командной строке, выполняется полный цикл, как в Ru_tts. Эти
ключи влияют на действия, выполняемые программой при тестировании
лексической базы данных и поиске информации в ней.

-x -- Просматривается прямой словарь.

-m -- Слово трактуется как производная форма.

-g -- Используются общие правила.


Следующая группа содержит всего один ключ, определяющий действия,
выполняемые программой при вставке новых данных в базу.

-r -- Режим замены.

При вставке словарных данных новые словарные статьи заменяют уже
существующие с идентичным ключевым полем. По умолчанию такие словарные
статьи просто игнорируются. При вставке правил режим замены означает
полную замену указанной системы правил. По умолчанию новые правила
дописываются в конец набора.


Последняя группа включает в себя ключи, влияющие на поведение
программы в целом.

-f <file> -- Использовать <file> вместо стандартного ввода или вывода.

-q -- Подавление вывода.

Этот ключ подавляет вывод результатов поиска и замечаний о
записях-дубликатах при вставке.

-v -- Вывод дополнительной информации.

Печатается отчет о выполняемых действиях и некоторая статистическая
информация.



А теперь немного истории.

Этот словарь, собственно, возник изначально как реализация моей мечты
вставить расстановку ударений в Ru_tts. Поиски подходящего словаря
ударений в интернете к успеху, увы, не привели. Но тут я вдруг
вспомнил, что свободно распространяемый в электронном виде
англо-русский словарь Мюллера в одном из своих вариантов содержал
расстановку ударений во всех русских словах. Я извлек этот материал и
получил немногим более 60000 вхождений. Это было уже что-то, хотя, как
оказалось, не слишком густо. Тем не менее, жизнеспособность идеи уже
можно было как-то оценить.

А дальше начался длительный процесс доводки. Ряд слов пришлось
исключить, так как ударение в них зависит от контекста, например,
"окна", "слова" и тому подобное. Далее оказалось, что ударениями здесь
дело отнюдь не ограничивается. Например, такая штука, как "счастливый
мужчина". Вылез и еще целый ряд тонкостей.

Разумеется, я вполне отдаю себе отчет в том, что и сейчас все это
весьма далеко от желанного совершенства, но все же уже, пожалуй, можно
вынести на суд широкой общественности. По крайней мере, то, как Ru_tts
работает с использованием этого словаря, мне нравится заметно больше,
чем то, что было до того.


Теперь же я хочу выразить глубочайшую благодарность тем, кто не
поленился расставить ударения в словаре Мюллера, а также склонить
голову в благодарном поклоне Иванову Геннадию Григорьевичу и своей
сестренке Татьяне, которые на начальном этапе самоотверженно взяли на
себя львиную долю самой черновой технической работы по корректировке и
пополнению словаря.

Не могу так же не выразить глубокую признательность Сергею Флейтину за
новые слова и замечания и, разумеется, Дмитрию Падучих, который не
только прислал мне немало новых слов, но и разработал некий механизм,
позволяющий несколько автоматизировать процесс их генерации, который я
тоже включаю в состав данного дистрибутива. Вот пояснения Дмитрия к
этому механизму:

Я написал небольшую моду для Emacs, чтобы редактировать словари
произношений. Главной её особенностью является то, что можно
"перемножать" кусочки слов. То есть, находясь в этой моде, можно
вызвать буфер, ввести там выражение, например:

ба+лк | а и е у ой е и ам ами ах

а Emacs затем вставит в буфер словаря:

балка ба+лка
балкам ба+лкам
балками ба+лками
балках ба+лках
балке ба+лке
балки ба+лки
балкой ба+лкой
балку ба+лку

Ещё один пример:

вы* по | нё+с пё+р | . ся

вынес вы+нес
вынесся вы+несся
выпер вы+пер
выперся вы+перся
понес понё+с
понесся понё+сся
попер попё+р
поперся попё+рся

Чтобы установить, скопируйте rulex.el в директорию, которая есть в
load-path, и скомпилируйте его там.
Затем в ~/.emacs можно ещё добавить:

(autoload 'rlex-mode "rulex" nil 'interactive)
(add-to-list 'auto-mode-alist '("\\.rle?x\\'" . rlex-mode))

чтобы файлы с расширением .rlex и .rlx открывались в rlex-mode.
____________________________________________________________


Порецкий Игорь, Санкт-Петербург, <poretsky@mlbox.ru>
