// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use ffi;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct Seekable(Object<ffi::GSeekable, ffi::GSeekableIface>);

    match fn {
        get_type => || ffi::g_seekable_get_type(),
    }
}

pub trait SeekableExt {
    fn can_seek(&self) -> bool;

    fn can_truncate(&self) -> bool;

    fn seek<'a, P: Into<Option<&'a Cancellable>>>(&self, offset: i64, type_: glib::SeekType, cancellable: P) -> Result<(), Error>;

    fn tell(&self) -> i64;

    fn truncate<'a, P: Into<Option<&'a Cancellable>>>(&self, offset: i64, cancellable: P) -> Result<(), Error>;
}

impl<O: IsA<Seekable>> SeekableExt for O {
    fn can_seek(&self) -> bool {
        unsafe {
            from_glib(ffi::g_seekable_can_seek(self.to_glib_none().0))
        }
    }

    fn can_truncate(&self) -> bool {
        unsafe {
            from_glib(ffi::g_seekable_can_truncate(self.to_glib_none().0))
        }
    }

    fn seek<'a, P: Into<Option<&'a Cancellable>>>(&self, offset: i64, type_: glib::SeekType, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_seekable_seek(self.to_glib_none().0, offset, type_.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn tell(&self) -> i64 {
        unsafe {
            ffi::g_seekable_tell(self.to_glib_none().0)
        }
    }

    fn truncate<'a, P: Into<Option<&'a Cancellable>>>(&self, offset: i64, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_seekable_truncate(self.to_glib_none().0, offset, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }
}
