// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Adjustment;
use crate::Align;
use crate::Buildable;
use crate::CellRenderer;
use crate::Container;
use crate::Entry;
use crate::MovementStep;
use crate::ResizeMode;
use crate::Scrollable;
use crate::ScrollablePolicy;
use crate::Tooltip;
use crate::TreeIter;
use crate::TreeModel;
use crate::TreePath;
use crate::TreeSelection;
use crate::TreeViewColumn;
use crate::TreeViewDropPosition;
use crate::TreeViewGridLines;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GtkTreeView")]
    pub struct TreeView(Object<ffi::GtkTreeView, ffi::GtkTreeViewClass>) @extends Container, Widget, @implements Buildable, Scrollable;

    match fn {
        type_ => || ffi::gtk_tree_view_get_type(),
    }
}

impl TreeView {
    #[doc(alias = "gtk_tree_view_new")]
    pub fn new() -> TreeView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_tree_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_tree_view_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model<P: IsA<TreeModel>>(model: &P) -> TreeView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_tree_view_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TreeView`] objects.
    ///
    /// This method returns an instance of [`TreeViewBuilder`] which can be used to create [`TreeView`] objects.
    pub fn builder() -> TreeViewBuilder {
        TreeViewBuilder::default()
    }
}

impl Default for TreeView {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TreeView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct TreeViewBuilder {
    activate_on_single_click: Option<bool>,
    enable_grid_lines: Option<TreeViewGridLines>,
    enable_search: Option<bool>,
    enable_tree_lines: Option<bool>,
    expander_column: Option<TreeViewColumn>,
    fixed_height_mode: Option<bool>,
    headers_clickable: Option<bool>,
    headers_visible: Option<bool>,
    hover_expand: Option<bool>,
    hover_selection: Option<bool>,
    level_indentation: Option<i32>,
    model: Option<TreeModel>,
    reorderable: Option<bool>,
    rubber_banding: Option<bool>,
    search_column: Option<i32>,
    show_expanders: Option<bool>,
    tooltip_column: Option<i32>,
    ubuntu_almost_fixed_height_mode: Option<bool>,
    border_width: Option<u32>,
    child: Option<Widget>,
    resize_mode: Option<ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    hadjustment: Option<Adjustment>,
    hscroll_policy: Option<ScrollablePolicy>,
    vadjustment: Option<Adjustment>,
    vscroll_policy: Option<ScrollablePolicy>,
}

impl TreeViewBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TreeViewBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TreeView`].
    pub fn build(self) -> TreeView {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activate_on_single_click) = self.activate_on_single_click {
            properties.push(("activate-on-single-click", activate_on_single_click));
        }
        if let Some(ref enable_grid_lines) = self.enable_grid_lines {
            properties.push(("enable-grid-lines", enable_grid_lines));
        }
        if let Some(ref enable_search) = self.enable_search {
            properties.push(("enable-search", enable_search));
        }
        if let Some(ref enable_tree_lines) = self.enable_tree_lines {
            properties.push(("enable-tree-lines", enable_tree_lines));
        }
        if let Some(ref expander_column) = self.expander_column {
            properties.push(("expander-column", expander_column));
        }
        if let Some(ref fixed_height_mode) = self.fixed_height_mode {
            properties.push(("fixed-height-mode", fixed_height_mode));
        }
        if let Some(ref headers_clickable) = self.headers_clickable {
            properties.push(("headers-clickable", headers_clickable));
        }
        if let Some(ref headers_visible) = self.headers_visible {
            properties.push(("headers-visible", headers_visible));
        }
        if let Some(ref hover_expand) = self.hover_expand {
            properties.push(("hover-expand", hover_expand));
        }
        if let Some(ref hover_selection) = self.hover_selection {
            properties.push(("hover-selection", hover_selection));
        }
        if let Some(ref level_indentation) = self.level_indentation {
            properties.push(("level-indentation", level_indentation));
        }
        if let Some(ref model) = self.model {
            properties.push(("model", model));
        }
        if let Some(ref reorderable) = self.reorderable {
            properties.push(("reorderable", reorderable));
        }
        if let Some(ref rubber_banding) = self.rubber_banding {
            properties.push(("rubber-banding", rubber_banding));
        }
        if let Some(ref search_column) = self.search_column {
            properties.push(("search-column", search_column));
        }
        if let Some(ref show_expanders) = self.show_expanders {
            properties.push(("show-expanders", show_expanders));
        }
        if let Some(ref tooltip_column) = self.tooltip_column {
            properties.push(("tooltip-column", tooltip_column));
        }
        if let Some(ref ubuntu_almost_fixed_height_mode) = self.ubuntu_almost_fixed_height_mode {
            properties.push((
                "ubuntu-almost-fixed-height-mode",
                ubuntu_almost_fixed_height_mode,
            ));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref hscroll_policy) = self.hscroll_policy {
            properties.push(("hscroll-policy", hscroll_policy));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscroll_policy) = self.vscroll_policy {
            properties.push(("vscroll-policy", vscroll_policy));
        }
        glib::Object::new::<TreeView>(&properties)
            .expect("Failed to create an instance of TreeView")
    }

    pub fn activate_on_single_click(mut self, activate_on_single_click: bool) -> Self {
        self.activate_on_single_click = Some(activate_on_single_click);
        self
    }

    pub fn enable_grid_lines(mut self, enable_grid_lines: TreeViewGridLines) -> Self {
        self.enable_grid_lines = Some(enable_grid_lines);
        self
    }

    pub fn enable_search(mut self, enable_search: bool) -> Self {
        self.enable_search = Some(enable_search);
        self
    }

    pub fn enable_tree_lines(mut self, enable_tree_lines: bool) -> Self {
        self.enable_tree_lines = Some(enable_tree_lines);
        self
    }

    pub fn expander_column<P: IsA<TreeViewColumn>>(mut self, expander_column: &P) -> Self {
        self.expander_column = Some(expander_column.clone().upcast());
        self
    }

    pub fn fixed_height_mode(mut self, fixed_height_mode: bool) -> Self {
        self.fixed_height_mode = Some(fixed_height_mode);
        self
    }

    pub fn headers_clickable(mut self, headers_clickable: bool) -> Self {
        self.headers_clickable = Some(headers_clickable);
        self
    }

    pub fn headers_visible(mut self, headers_visible: bool) -> Self {
        self.headers_visible = Some(headers_visible);
        self
    }

    pub fn hover_expand(mut self, hover_expand: bool) -> Self {
        self.hover_expand = Some(hover_expand);
        self
    }

    pub fn hover_selection(mut self, hover_selection: bool) -> Self {
        self.hover_selection = Some(hover_selection);
        self
    }

    pub fn level_indentation(mut self, level_indentation: i32) -> Self {
        self.level_indentation = Some(level_indentation);
        self
    }

    pub fn model<P: IsA<TreeModel>>(mut self, model: &P) -> Self {
        self.model = Some(model.clone().upcast());
        self
    }

    pub fn reorderable(mut self, reorderable: bool) -> Self {
        self.reorderable = Some(reorderable);
        self
    }

    pub fn rubber_banding(mut self, rubber_banding: bool) -> Self {
        self.rubber_banding = Some(rubber_banding);
        self
    }

    pub fn search_column(mut self, search_column: i32) -> Self {
        self.search_column = Some(search_column);
        self
    }

    pub fn show_expanders(mut self, show_expanders: bool) -> Self {
        self.show_expanders = Some(show_expanders);
        self
    }

    pub fn tooltip_column(mut self, tooltip_column: i32) -> Self {
        self.tooltip_column = Some(tooltip_column);
        self
    }

    pub fn ubuntu_almost_fixed_height_mode(
        mut self,
        ubuntu_almost_fixed_height_mode: bool,
    ) -> Self {
        self.ubuntu_almost_fixed_height_mode = Some(ubuntu_almost_fixed_height_mode);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn hadjustment<P: IsA<Adjustment>>(mut self, hadjustment: &P) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn hscroll_policy(mut self, hscroll_policy: ScrollablePolicy) -> Self {
        self.hscroll_policy = Some(hscroll_policy);
        self
    }

    pub fn vadjustment<P: IsA<Adjustment>>(mut self, vadjustment: &P) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscroll_policy(mut self, vscroll_policy: ScrollablePolicy) -> Self {
        self.vscroll_policy = Some(vscroll_policy);
        self
    }
}

pub const NONE_TREE_VIEW: Option<&TreeView> = None;

pub trait TreeViewExt: 'static {
    #[doc(alias = "gtk_tree_view_append_column")]
    fn append_column<P: IsA<TreeViewColumn>>(&self, column: &P) -> i32;

    #[doc(alias = "gtk_tree_view_collapse_all")]
    fn collapse_all(&self);

    #[doc(alias = "gtk_tree_view_collapse_row")]
    fn collapse_row(&self, path: &TreePath) -> bool;

    #[doc(alias = "gtk_tree_view_columns_autosize")]
    fn columns_autosize(&self);

    #[doc(alias = "gtk_tree_view_convert_bin_window_to_tree_coords")]
    fn convert_bin_window_to_tree_coords(&self, bx: i32, by: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_convert_bin_window_to_widget_coords")]
    fn convert_bin_window_to_widget_coords(&self, bx: i32, by: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_convert_tree_to_bin_window_coords")]
    fn convert_tree_to_bin_window_coords(&self, tx: i32, ty: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_convert_tree_to_widget_coords")]
    fn convert_tree_to_widget_coords(&self, tx: i32, ty: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_convert_widget_to_bin_window_coords")]
    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_convert_widget_to_tree_coords")]
    fn convert_widget_to_tree_coords(&self, wx: i32, wy: i32) -> (i32, i32);

    #[doc(alias = "gtk_tree_view_create_row_drag_icon")]
    fn create_row_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface>;

    #[doc(alias = "gtk_tree_view_expand_all")]
    fn expand_all(&self);

    #[doc(alias = "gtk_tree_view_expand_row")]
    fn expand_row(&self, path: &TreePath, open_all: bool) -> bool;

    #[doc(alias = "gtk_tree_view_expand_to_path")]
    fn expand_to_path(&self, path: &TreePath);

    #[doc(alias = "gtk_tree_view_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    fn activates_on_single_click(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_background_area")]
    #[doc(alias = "get_background_area")]
    fn background_area<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
    ) -> gdk::Rectangle;

    #[doc(alias = "gtk_tree_view_get_bin_window")]
    #[doc(alias = "get_bin_window")]
    fn bin_window(&self) -> Option<gdk::Window>;

    #[doc(alias = "gtk_tree_view_get_cell_area")]
    #[doc(alias = "get_cell_area")]
    fn cell_area<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
    ) -> gdk::Rectangle;

    #[doc(alias = "gtk_tree_view_get_column")]
    #[doc(alias = "get_column")]
    fn column(&self, n: i32) -> Option<TreeViewColumn>;

    #[doc(alias = "gtk_tree_view_get_columns")]
    #[doc(alias = "get_columns")]
    fn columns(&self) -> Vec<TreeViewColumn>;

    #[doc(alias = "gtk_tree_view_get_cursor")]
    #[doc(alias = "get_cursor")]
    fn cursor(&self) -> (Option<TreePath>, Option<TreeViewColumn>);

    #[doc(alias = "gtk_tree_view_get_dest_row_at_pos")]
    #[doc(alias = "get_dest_row_at_pos")]
    fn dest_row_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(Option<TreePath>, TreeViewDropPosition)>;

    #[doc(alias = "gtk_tree_view_get_drag_dest_row")]
    #[doc(alias = "get_drag_dest_row")]
    fn drag_dest_row(&self) -> (Option<TreePath>, TreeViewDropPosition);

    #[doc(alias = "gtk_tree_view_get_enable_search")]
    #[doc(alias = "get_enable_search")]
    fn enables_search(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_enable_tree_lines")]
    #[doc(alias = "get_enable_tree_lines")]
    fn enables_tree_lines(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_expander_column")]
    #[doc(alias = "get_expander_column")]
    fn expander_column(&self) -> Option<TreeViewColumn>;

    #[doc(alias = "gtk_tree_view_get_fixed_height_mode")]
    #[doc(alias = "get_fixed_height_mode")]
    fn is_fixed_height_mode(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_grid_lines")]
    #[doc(alias = "get_grid_lines")]
    fn grid_lines(&self) -> TreeViewGridLines;

    #[doc(alias = "gtk_tree_view_get_headers_clickable")]
    #[doc(alias = "get_headers_clickable")]
    fn is_headers_clickable(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_headers_visible")]
    #[doc(alias = "get_headers_visible")]
    fn is_headers_visible(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_hover_expand")]
    #[doc(alias = "get_hover_expand")]
    fn hover_expands(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_hover_selection")]
    #[doc(alias = "get_hover_selection")]
    fn is_hover_selection(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_level_indentation")]
    #[doc(alias = "get_level_indentation")]
    fn level_indentation(&self) -> i32;

    #[doc(alias = "gtk_tree_view_get_model")]
    #[doc(alias = "get_model")]
    fn model(&self) -> Option<TreeModel>;

    #[doc(alias = "gtk_tree_view_get_n_columns")]
    #[doc(alias = "get_n_columns")]
    fn n_columns(&self) -> u32;

    #[doc(alias = "gtk_tree_view_get_path_at_pos")]
    #[doc(alias = "get_path_at_pos")]
    fn path_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)>;

    #[doc(alias = "gtk_tree_view_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    fn is_reorderable(&self) -> bool;

    //#[doc(alias = "gtk_tree_view_get_row_separator_func")]
    //#[doc(alias = "get_row_separator_func")]
    //fn row_separator_func(&self) -> Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>;

    #[doc(alias = "gtk_tree_view_get_rubber_banding")]
    #[doc(alias = "get_rubber_banding")]
    fn is_rubber_banding(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_search_column")]
    #[doc(alias = "get_search_column")]
    fn search_column(&self) -> i32;

    #[doc(alias = "gtk_tree_view_get_search_entry")]
    #[doc(alias = "get_search_entry")]
    fn search_entry(&self) -> Option<Entry>;

    //#[doc(alias = "gtk_tree_view_get_search_equal_func")]
    //#[doc(alias = "get_search_equal_func")]
    //fn search_equal_func(&self) -> Option<Box_<dyn Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>>;

    //#[doc(alias = "gtk_tree_view_get_search_position_func")]
    //#[doc(alias = "get_search_position_func")]
    //fn search_position_func(&self) -> Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>;

    #[doc(alias = "gtk_tree_view_get_selection")]
    #[doc(alias = "get_selection")]
    fn selection(&self) -> TreeSelection;

    #[doc(alias = "gtk_tree_view_get_show_expanders")]
    #[doc(alias = "get_show_expanders")]
    fn shows_expanders(&self) -> bool;

    #[doc(alias = "gtk_tree_view_get_tooltip_column")]
    #[doc(alias = "get_tooltip_column")]
    fn tooltip_column(&self) -> i32;

    #[doc(alias = "gtk_tree_view_get_tooltip_context")]
    #[doc(alias = "get_tooltip_context")]
    fn tooltip_context(
        &self,
        x: &mut i32,
        y: &mut i32,
        keyboard_tip: bool,
    ) -> Option<(Option<TreeModel>, TreePath, TreeIter)>;

    #[doc(alias = "gtk_tree_view_get_visible_range")]
    #[doc(alias = "get_visible_range")]
    fn visible_range(&self) -> Option<(TreePath, TreePath)>;

    #[doc(alias = "gtk_tree_view_get_visible_rect")]
    #[doc(alias = "get_visible_rect")]
    fn visible_rect(&self) -> gdk::Rectangle;

    #[doc(alias = "gtk_tree_view_insert_column")]
    fn insert_column<P: IsA<TreeViewColumn>>(&self, column: &P, position: i32) -> i32;

    //#[doc(alias = "gtk_tree_view_insert_column_with_attributes")]
    //fn insert_column_with_attributes<P: IsA<CellRenderer>>(&self, position: i32, title: &str, cell: &P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> i32;

    #[doc(alias = "gtk_tree_view_insert_column_with_data_func")]
    fn insert_column_with_data_func<
        P: IsA<CellRenderer>,
        Q: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
    >(
        &self,
        position: i32,
        title: &str,
        cell: &P,
        func: Q,
    ) -> i32;

    #[doc(alias = "gtk_tree_view_is_blank_at_pos")]
    fn is_blank_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)>;

    #[doc(alias = "gtk_tree_view_is_rubber_banding_active")]
    fn is_rubber_banding_active(&self) -> bool;

    #[doc(alias = "gtk_tree_view_map_expanded_rows")]
    fn map_expanded_rows<P: FnMut(&TreeView, &TreePath)>(&self, func: P);

    #[doc(alias = "gtk_tree_view_move_column_after")]
    fn move_column_after<P: IsA<TreeViewColumn>, Q: IsA<TreeViewColumn>>(
        &self,
        column: &P,
        base_column: Option<&Q>,
    );

    #[doc(alias = "gtk_tree_view_remove_column")]
    fn remove_column<P: IsA<TreeViewColumn>>(&self, column: &P) -> i32;

    #[doc(alias = "gtk_tree_view_row_activated")]
    fn row_activated<P: IsA<TreeViewColumn>>(&self, path: &TreePath, column: &P);

    #[doc(alias = "gtk_tree_view_row_expanded")]
    fn row_expanded(&self, path: &TreePath) -> bool;

    #[doc(alias = "gtk_tree_view_scroll_to_cell")]
    fn scroll_to_cell<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
        use_align: bool,
        row_align: f32,
        col_align: f32,
    );

    #[doc(alias = "gtk_tree_view_scroll_to_point")]
    fn scroll_to_point(&self, tree_x: i32, tree_y: i32);

    #[doc(alias = "gtk_tree_view_set_activate_on_single_click")]
    fn set_activate_on_single_click(&self, single: bool);

    #[doc(alias = "gtk_tree_view_set_column_drag_function")]
    fn set_column_drag_function(
        &self,
        func: Option<
            Box_<
                dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                    + 'static,
            >,
        >,
    );

    #[doc(alias = "gtk_tree_view_set_cursor")]
    fn set_cursor<P: IsA<TreeViewColumn>>(
        &self,
        path: &TreePath,
        focus_column: Option<&P>,
        start_editing: bool,
    );

    #[doc(alias = "gtk_tree_view_set_cursor_on_cell")]
    fn set_cursor_on_cell<P: IsA<TreeViewColumn>, Q: IsA<CellRenderer>>(
        &self,
        path: &TreePath,
        focus_column: Option<&P>,
        focus_cell: Option<&Q>,
        start_editing: bool,
    );

    #[doc(alias = "gtk_tree_view_set_drag_dest_row")]
    fn set_drag_dest_row(&self, path: Option<&TreePath>, pos: TreeViewDropPosition);

    #[doc(alias = "gtk_tree_view_set_enable_search")]
    fn set_enable_search(&self, enable_search: bool);

    #[doc(alias = "gtk_tree_view_set_enable_tree_lines")]
    fn set_enable_tree_lines(&self, enabled: bool);

    #[doc(alias = "gtk_tree_view_set_expander_column")]
    fn set_expander_column<P: IsA<TreeViewColumn>>(&self, column: Option<&P>);

    #[doc(alias = "gtk_tree_view_set_fixed_height_mode")]
    fn set_fixed_height_mode(&self, enable: bool);

    #[doc(alias = "gtk_tree_view_set_grid_lines")]
    fn set_grid_lines(&self, grid_lines: TreeViewGridLines);

    #[doc(alias = "gtk_tree_view_set_headers_clickable")]
    fn set_headers_clickable(&self, setting: bool);

    #[doc(alias = "gtk_tree_view_set_headers_visible")]
    fn set_headers_visible(&self, headers_visible: bool);

    #[doc(alias = "gtk_tree_view_set_hover_expand")]
    fn set_hover_expand(&self, expand: bool);

    #[doc(alias = "gtk_tree_view_set_hover_selection")]
    fn set_hover_selection(&self, hover: bool);

    #[doc(alias = "gtk_tree_view_set_level_indentation")]
    fn set_level_indentation(&self, indentation: i32);

    #[doc(alias = "gtk_tree_view_set_model")]
    fn set_model<P: IsA<TreeModel>>(&self, model: Option<&P>);

    #[doc(alias = "gtk_tree_view_set_reorderable")]
    fn set_reorderable(&self, reorderable: bool);

    #[doc(alias = "gtk_tree_view_set_row_separator_func")]
    fn set_row_separator_func(
        &self,
        func: Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>,
    );

    #[doc(alias = "gtk_tree_view_set_rubber_banding")]
    fn set_rubber_banding(&self, enable: bool);

    #[doc(alias = "gtk_tree_view_set_search_column")]
    fn set_search_column(&self, column: i32);

    #[doc(alias = "gtk_tree_view_set_search_entry")]
    fn set_search_entry<P: IsA<Entry>>(&self, entry: Option<&P>);

    #[doc(alias = "gtk_tree_view_set_search_equal_func")]
    fn set_search_equal_func<P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>(
        &self,
        search_equal_func: P,
    );

    #[doc(alias = "gtk_tree_view_set_search_position_func")]
    fn set_search_position_func(&self, func: Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>);

    #[doc(alias = "gtk_tree_view_set_show_expanders")]
    fn set_show_expanders(&self, enabled: bool);

    #[doc(alias = "gtk_tree_view_set_tooltip_cell")]
    fn set_tooltip_cell<P: IsA<TreeViewColumn>, Q: IsA<CellRenderer>>(
        &self,
        tooltip: &Tooltip,
        path: Option<&TreePath>,
        column: Option<&P>,
        cell: Option<&Q>,
    );

    #[doc(alias = "gtk_tree_view_set_tooltip_column")]
    fn set_tooltip_column(&self, column: i32);

    #[doc(alias = "gtk_tree_view_set_tooltip_row")]
    fn set_tooltip_row(&self, tooltip: &Tooltip, path: &TreePath);

    #[doc(alias = "gtk_tree_view_unset_rows_drag_dest")]
    fn unset_rows_drag_dest(&self);

    #[doc(alias = "gtk_tree_view_unset_rows_drag_source")]
    fn unset_rows_drag_source(&self);

    #[doc(alias = "enable-grid-lines")]
    fn enable_grid_lines(&self) -> TreeViewGridLines;

    #[doc(alias = "enable-grid-lines")]
    fn set_enable_grid_lines(&self, enable_grid_lines: TreeViewGridLines);

    #[doc(alias = "ubuntu-almost-fixed-height-mode")]
    fn set_ubuntu_almost_fixed_height_mode(&self, ubuntu_almost_fixed_height_mode: bool);

    #[doc(alias = "columns-changed")]
    fn connect_columns_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-changed")]
    fn connect_cursor_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "expand-collapse-cursor-row")]
    fn connect_expand_collapse_cursor_row<F: Fn(&Self, bool, bool, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_expand_collapse_cursor_row(&self, object: bool, p0: bool, p1: bool) -> bool;

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, direction: i32) -> bool;

    #[doc(alias = "row-activated")]
    fn connect_row_activated<F: Fn(&Self, &TreePath, &TreeViewColumn) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_row_activated(&self, path: &TreePath, column: &TreeViewColumn);

    #[doc(alias = "row-collapsed")]
    fn connect_row_collapsed<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "row-expanded")]
    fn connect_row_expanded<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_all(&self) -> bool;

    #[doc(alias = "select-cursor-parent")]
    fn connect_select_cursor_parent<F: Fn(&Self) -> bool + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn emit_select_cursor_parent(&self) -> bool;

    #[doc(alias = "select-cursor-row")]
    fn connect_select_cursor_row<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_select_cursor_row(&self, object: bool) -> bool;

    #[doc(alias = "start-interactive-search")]
    fn connect_start_interactive_search<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_start_interactive_search(&self) -> bool;

    #[doc(alias = "test-collapse-row")]
    fn connect_test_collapse_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "test-expand-row")]
    fn connect_test_expand_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "toggle-cursor-row")]
    fn connect_toggle_cursor_row<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_cursor_row(&self) -> bool;

    #[doc(alias = "unselect-all")]
    fn connect_unselect_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_unselect_all(&self) -> bool;

    #[doc(alias = "activate-on-single-click")]
    fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "enable-grid-lines")]
    fn connect_enable_grid_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-search")]
    fn connect_enable_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-tree-lines")]
    fn connect_enable_tree_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "expander-column")]
    fn connect_expander_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fixed-height-mode")]
    fn connect_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "headers-clickable")]
    fn connect_headers_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "headers-visible")]
    fn connect_headers_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hover-expand")]
    fn connect_hover_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hover-selection")]
    fn connect_hover_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "level-indentation")]
    fn connect_level_indentation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "model")]
    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "reorderable")]
    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rubber-banding")]
    fn connect_rubber_banding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "search-column")]
    fn connect_search_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-expanders")]
    fn connect_show_expanders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tooltip-column")]
    fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ubuntu-almost-fixed-height-mode")]
    fn connect_ubuntu_almost_fixed_height_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<TreeView>> TreeViewExt for O {
    fn append_column<P: IsA<TreeViewColumn>>(&self, column: &P) -> i32 {
        unsafe {
            ffi::gtk_tree_view_append_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
            )
        }
    }

    fn collapse_all(&self) {
        unsafe {
            ffi::gtk_tree_view_collapse_all(self.as_ref().to_glib_none().0);
        }
    }

    fn collapse_row(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_collapse_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    fn columns_autosize(&self) {
        unsafe {
            ffi::gtk_tree_view_columns_autosize(self.as_ref().to_glib_none().0);
        }
    }

    fn convert_bin_window_to_tree_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::MaybeUninit::uninit();
            let mut ty = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_bin_window_to_tree_coords(
                self.as_ref().to_glib_none().0,
                bx,
                by,
                tx.as_mut_ptr(),
                ty.as_mut_ptr(),
            );
            let tx = tx.assume_init();
            let ty = ty.assume_init();
            (tx, ty)
        }
    }

    fn convert_bin_window_to_widget_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::MaybeUninit::uninit();
            let mut wy = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_bin_window_to_widget_coords(
                self.as_ref().to_glib_none().0,
                bx,
                by,
                wx.as_mut_ptr(),
                wy.as_mut_ptr(),
            );
            let wx = wx.assume_init();
            let wy = wy.assume_init();
            (wx, wy)
        }
    }

    fn convert_tree_to_bin_window_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::MaybeUninit::uninit();
            let mut by = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_tree_to_bin_window_coords(
                self.as_ref().to_glib_none().0,
                tx,
                ty,
                bx.as_mut_ptr(),
                by.as_mut_ptr(),
            );
            let bx = bx.assume_init();
            let by = by.assume_init();
            (bx, by)
        }
    }

    fn convert_tree_to_widget_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::MaybeUninit::uninit();
            let mut wy = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_tree_to_widget_coords(
                self.as_ref().to_glib_none().0,
                tx,
                ty,
                wx.as_mut_ptr(),
                wy.as_mut_ptr(),
            );
            let wx = wx.assume_init();
            let wy = wy.assume_init();
            (wx, wy)
        }
    }

    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::MaybeUninit::uninit();
            let mut by = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_widget_to_bin_window_coords(
                self.as_ref().to_glib_none().0,
                wx,
                wy,
                bx.as_mut_ptr(),
                by.as_mut_ptr(),
            );
            let bx = bx.assume_init();
            let by = by.assume_init();
            (bx, by)
        }
    }

    fn convert_widget_to_tree_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::MaybeUninit::uninit();
            let mut ty = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_widget_to_tree_coords(
                self.as_ref().to_glib_none().0,
                wx,
                wy,
                tx.as_mut_ptr(),
                ty.as_mut_ptr(),
            );
            let tx = tx.assume_init();
            let ty = ty.assume_init();
            (tx, ty)
        }
    }

    fn create_row_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface> {
        unsafe {
            from_glib_full(ffi::gtk_tree_view_create_row_drag_icon(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    fn expand_all(&self) {
        unsafe {
            ffi::gtk_tree_view_expand_all(self.as_ref().to_glib_none().0);
        }
    }

    fn expand_row(&self, path: &TreePath, open_all: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_expand_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                open_all.into_glib(),
            ))
        }
    }

    fn expand_to_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_expand_to_path(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_activate_on_single_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn background_area<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_background_area(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    fn bin_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_bin_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cell_area<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_cell_area(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    fn column(&self, n: i32) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_column(
                self.as_ref().to_glib_none().0,
                n,
            ))
        }
    }

    fn columns(&self) -> Vec<TreeViewColumn> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_tree_view_get_columns(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cursor(&self) -> (Option<TreePath>, Option<TreeViewColumn>) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut focus_column = ptr::null_mut();
            ffi::gtk_tree_view_get_cursor(
                self.as_ref().to_glib_none().0,
                &mut path,
                &mut focus_column,
            );
            (from_glib_full(path), from_glib_none(focus_column))
        }
    }

    fn dest_row_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(Option<TreePath>, TreeViewDropPosition)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_get_dest_row_at_pos(
                self.as_ref().to_glib_none().0,
                drag_x,
                drag_y,
                &mut path,
                pos.as_mut_ptr(),
            ));
            let pos = pos.assume_init();
            if ret {
                Some((from_glib_full(path), from_glib(pos)))
            } else {
                None
            }
        }
    }

    fn drag_dest_row(&self) -> (Option<TreePath>, TreeViewDropPosition) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_get_drag_dest_row(
                self.as_ref().to_glib_none().0,
                &mut path,
                pos.as_mut_ptr(),
            );
            let pos = pos.assume_init();
            (from_glib_full(path), from_glib(pos))
        }
    }

    fn enables_search(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_search(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_tree_lines(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_tree_lines(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn expander_column(&self) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_expander_column(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_fixed_height_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_fixed_height_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn grid_lines(&self) -> TreeViewGridLines {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_grid_lines(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_headers_clickable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_clickable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_headers_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hover_expands(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_expand(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_hover_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn level_indentation(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_level_indentation(self.as_ref().to_glib_none().0) }
    }

    fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_tree_view_get_model(self.as_ref().to_glib_none().0)) }
    }

    fn n_columns(&self) -> u32 {
        unsafe { ffi::gtk_tree_view_get_n_columns(self.as_ref().to_glib_none().0) }
    }

    fn path_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::MaybeUninit::uninit();
            let mut cell_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_get_path_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
                &mut path,
                &mut column,
                cell_x.as_mut_ptr(),
                cell_y.as_mut_ptr(),
            ));
            let cell_x = cell_x.assume_init();
            let cell_y = cell_y.assume_init();
            if ret {
                Some((from_glib_full(path), from_glib_none(column), cell_x, cell_y))
            } else {
                None
            }
        }
    }

    fn is_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn row_separator_func(&self) -> Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_row_separator_func() }
    //}

    fn is_rubber_banding(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_rubber_banding(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_column(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_search_column(self.as_ref().to_glib_none().0) }
    }

    fn search_entry(&self) -> Option<Entry> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_search_entry(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn search_equal_func(&self) -> Option<Box_<dyn Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_search_equal_func() }
    //}

    //fn search_position_func(&self) -> Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_search_position_func() }
    //}

    fn selection(&self) -> TreeSelection {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_expanders(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_show_expanders(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tooltip_column(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_tooltip_column(self.as_ref().to_glib_none().0) }
    }

    fn tooltip_context(
        &self,
        x: &mut i32,
        y: &mut i32,
        keyboard_tip: bool,
    ) -> Option<(Option<TreeModel>, TreePath, TreeIter)> {
        unsafe {
            let mut model = ptr::null_mut();
            let mut path = ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_get_tooltip_context(
                self.as_ref().to_glib_none().0,
                x,
                y,
                keyboard_tip.into_glib(),
                &mut model,
                &mut path,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some((from_glib_none(model), from_glib_full(path), iter))
            } else {
                None
            }
        }
    }

    fn visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = ptr::null_mut();
            let mut end_path = ptr::null_mut();
            let ret = from_glib(ffi::gtk_tree_view_get_visible_range(
                self.as_ref().to_glib_none().0,
                &mut start_path,
                &mut end_path,
            ));
            if ret {
                Some((from_glib_full(start_path), from_glib_full(end_path)))
            } else {
                None
            }
        }
    }

    fn visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_visible_rect(
                self.as_ref().to_glib_none().0,
                visible_rect.to_glib_none_mut().0,
            );
            visible_rect
        }
    }

    fn insert_column<P: IsA<TreeViewColumn>>(&self, column: &P, position: i32) -> i32 {
        unsafe {
            ffi::gtk_tree_view_insert_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
                position,
            )
        }
    }

    //fn insert_column_with_attributes<P: IsA<CellRenderer>>(&self, position: i32, title: &str, cell: &P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> i32 {
    //    unsafe { TODO: call ffi:gtk_tree_view_insert_column_with_attributes() }
    //}

    fn insert_column_with_data_func<
        P: IsA<CellRenderer>,
        Q: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
    >(
        &self,
        position: i32,
        title: &str,
        cell: &P,
        func: Q,
    ) -> i32 {
        let func_data: Box_<Q> = Box_::new(func);
        unsafe extern "C" fn func_func<
            P: IsA<CellRenderer>,
            Q: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
        >(
            tree_column: *mut ffi::GtkTreeViewColumn,
            cell: *mut ffi::GtkCellRenderer,
            tree_model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) {
            let tree_column = from_glib_borrow(tree_column);
            let cell = from_glib_borrow(cell);
            let tree_model = from_glib_borrow(tree_model);
            let iter = from_glib_borrow(iter);
            let callback: &Q = &*(data as *mut _);
            (*callback)(&tree_column, &cell, &tree_model, &iter);
        }
        let func = Some(func_func::<P, Q> as _);
        unsafe extern "C" fn dnotify_func<
            P: IsA<CellRenderer>,
            Q: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<Q> = Box_::from_raw(data as *mut _);
        }
        let destroy_call6 = Some(dnotify_func::<P, Q> as _);
        let super_callback0: Box_<Q> = func_data;
        unsafe {
            ffi::gtk_tree_view_insert_column_with_data_func(
                self.as_ref().to_glib_none().0,
                position,
                title.to_glib_none().0,
                cell.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call6,
            )
        }
    }

    fn is_blank_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::MaybeUninit::uninit();
            let mut cell_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_is_blank_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
                &mut path,
                &mut column,
                cell_x.as_mut_ptr(),
                cell_y.as_mut_ptr(),
            ));
            let cell_x = cell_x.assume_init();
            let cell_y = cell_y.assume_init();
            if ret {
                Some((from_glib_full(path), from_glib_none(column), cell_x, cell_y))
            } else {
                None
            }
        }
    }

    fn is_rubber_banding_active(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_is_rubber_banding_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn map_expanded_rows<P: FnMut(&TreeView, &TreePath)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&TreeView, &TreePath)>(
            tree_view: *mut ffi::GtkTreeView,
            path: *mut ffi::GtkTreePath,
            user_data: glib::ffi::gpointer,
        ) {
            let tree_view = from_glib_borrow(tree_view);
            let path = from_glib_borrow(path);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(&tree_view, &path);
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::gtk_tree_view_map_expanded_rows(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    fn move_column_after<P: IsA<TreeViewColumn>, Q: IsA<TreeViewColumn>>(
        &self,
        column: &P,
        base_column: Option<&Q>,
    ) {
        unsafe {
            ffi::gtk_tree_view_move_column_after(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
                base_column.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn remove_column<P: IsA<TreeViewColumn>>(&self, column: &P) -> i32 {
        unsafe {
            ffi::gtk_tree_view_remove_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
            )
        }
    }

    fn row_activated<P: IsA<TreeViewColumn>>(&self, path: &TreePath, column: &P) {
        unsafe {
            ffi::gtk_tree_view_row_activated(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.as_ref().to_glib_none().0,
            );
        }
    }

    fn row_expanded(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_row_expanded(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    fn scroll_to_cell<P: IsA<TreeViewColumn>>(
        &self,
        path: Option<&TreePath>,
        column: Option<&P>,
        use_align: bool,
        row_align: f32,
        col_align: f32,
    ) {
        unsafe {
            ffi::gtk_tree_view_scroll_to_cell(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                use_align.into_glib(),
                row_align,
                col_align,
            );
        }
    }

    fn scroll_to_point(&self, tree_x: i32, tree_y: i32) {
        unsafe {
            ffi::gtk_tree_view_scroll_to_point(self.as_ref().to_glib_none().0, tree_x, tree_y);
        }
    }

    fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_tree_view_set_activate_on_single_click(
                self.as_ref().to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    fn set_column_drag_function(
        &self,
        func: Option<
            Box_<
                dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                    + 'static,
            >,
        >,
    ) {
        let func_data: Box_<
            Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            >,
        > = Box_::new(func);
        unsafe extern "C" fn func_func(
            tree_view: *mut ffi::GtkTreeView,
            column: *mut ffi::GtkTreeViewColumn,
            prev_column: *mut ffi::GtkTreeViewColumn,
            next_column: *mut ffi::GtkTreeViewColumn,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let tree_view = from_glib_borrow(tree_view);
            let column = from_glib_borrow(column);
            let prev_column = from_glib_borrow(prev_column);
            let next_column = from_glib_borrow(next_column);
            let callback: &Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            > = &*(data as *mut _);
            let res = if let Some(ref callback) = *callback {
                callback(&tree_view, &column, &prev_column, &next_column)
            } else {
                panic!("cannot get closure...")
            };
            res.into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<
                Option<
                    Box_<
                        dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                            + 'static,
                    >,
                >,
            > = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<
            Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            >,
        > = func_data;
        unsafe {
            ffi::gtk_tree_view_set_column_drag_function(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_cursor<P: IsA<TreeViewColumn>>(
        &self,
        path: &TreePath,
        focus_column: Option<&P>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_cursor(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                focus_column.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    fn set_cursor_on_cell<P: IsA<TreeViewColumn>, Q: IsA<CellRenderer>>(
        &self,
        path: &TreePath,
        focus_column: Option<&P>,
        focus_cell: Option<&Q>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_cursor_on_cell(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                focus_column.map(|p| p.as_ref()).to_glib_none().0,
                focus_cell.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    fn set_drag_dest_row(&self, path: Option<&TreePath>, pos: TreeViewDropPosition) {
        unsafe {
            ffi::gtk_tree_view_set_drag_dest_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                pos.into_glib(),
            );
        }
    }

    fn set_enable_search(&self, enable_search: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_search(
                self.as_ref().to_glib_none().0,
                enable_search.into_glib(),
            );
        }
    }

    fn set_enable_tree_lines(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_tree_lines(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    fn set_expander_column<P: IsA<TreeViewColumn>>(&self, column: Option<&P>) {
        unsafe {
            ffi::gtk_tree_view_set_expander_column(
                self.as_ref().to_glib_none().0,
                column.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_fixed_height_mode(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_fixed_height_mode(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_grid_lines(&self, grid_lines: TreeViewGridLines) {
        unsafe {
            ffi::gtk_tree_view_set_grid_lines(
                self.as_ref().to_glib_none().0,
                grid_lines.into_glib(),
            );
        }
    }

    fn set_headers_clickable(&self, setting: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_clickable(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_headers_visible(&self, headers_visible: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_visible(
                self.as_ref().to_glib_none().0,
                headers_visible.into_glib(),
            );
        }
    }

    fn set_hover_expand(&self, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_expand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    fn set_hover_selection(&self, hover: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_selection(
                self.as_ref().to_glib_none().0,
                hover.into_glib(),
            );
        }
    }

    fn set_level_indentation(&self, indentation: i32) {
        unsafe {
            ffi::gtk_tree_view_set_level_indentation(self.as_ref().to_glib_none().0, indentation);
        }
    }

    fn set_model<P: IsA<TreeModel>>(&self, model: Option<&P>) {
        unsafe {
            ffi::gtk_tree_view_set_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    fn set_row_separator_func(
        &self,
        func: Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>,
    ) {
        let func_data: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
            Box_::new(func);
        unsafe extern "C" fn func_func(
            model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let model = from_glib_borrow(model);
            let iter = from_glib_borrow(iter);
            let callback: &Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>> =
                &*(data as *mut _);
            let res = if let Some(ref callback) = *callback {
                callback(&model, &iter)
            } else {
                panic!("cannot get closure...")
            };
            res.into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
            func_data;
        unsafe {
            ffi::gtk_tree_view_set_row_separator_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_rubber_banding(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_rubber_banding(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_search_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_search_column(self.as_ref().to_glib_none().0, column);
        }
    }

    fn set_search_entry<P: IsA<Entry>>(&self, entry: Option<&P>) {
        unsafe {
            ffi::gtk_tree_view_set_search_entry(
                self.as_ref().to_glib_none().0,
                entry.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_search_equal_func<P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>(
        &self,
        search_equal_func: P,
    ) {
        let search_equal_func_data: Box_<P> = Box_::new(search_equal_func);
        unsafe extern "C" fn search_equal_func_func<
            P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static,
        >(
            model: *mut ffi::GtkTreeModel,
            column: libc::c_int,
            key: *const libc::c_char,
            iter: *mut ffi::GtkTreeIter,
            search_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let model = from_glib_borrow(model);
            let key: Borrowed<glib::GString> = from_glib_borrow(key);
            let iter = from_glib_borrow(iter);
            let callback: &P = &*(search_data as *mut _);
            let res = (*callback)(&model, column, key.as_str(), &iter);
            res.into_glib()
        }
        let search_equal_func = Some(search_equal_func_func::<P> as _);
        unsafe extern "C" fn search_destroy_func<
            P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(search_destroy_func::<P> as _);
        let super_callback0: Box_<P> = search_equal_func_data;
        unsafe {
            ffi::gtk_tree_view_set_search_equal_func(
                self.as_ref().to_glib_none().0,
                search_equal_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_search_position_func(&self, func: Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>) {
        let func_data: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> = Box_::new(func);
        unsafe extern "C" fn func_func(
            tree_view: *mut ffi::GtkTreeView,
            search_dialog: *mut ffi::GtkWidget,
            user_data: glib::ffi::gpointer,
        ) {
            let tree_view = from_glib_borrow(tree_view);
            let search_dialog = from_glib_borrow(search_dialog);
            let callback: &Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&tree_view, &search_dialog)
            } else {
                panic!("cannot get closure...")
            };
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> = func_data;
        unsafe {
            ffi::gtk_tree_view_set_search_position_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_show_expanders(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_show_expanders(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    fn set_tooltip_cell<P: IsA<TreeViewColumn>, Q: IsA<CellRenderer>>(
        &self,
        tooltip: &Tooltip,
        path: Option<&TreePath>,
        column: Option<&P>,
        cell: Option<&Q>,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_cell(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                cell.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_column(self.as_ref().to_glib_none().0, column);
        }
    }

    fn set_tooltip_row(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_row(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    fn unset_rows_drag_dest(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_dest(self.as_ref().to_glib_none().0);
        }
    }

    fn unset_rows_drag_source(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_source(self.as_ref().to_glib_none().0);
        }
    }

    fn enable_grid_lines(&self) -> TreeViewGridLines {
        unsafe {
            let mut value =
                glib::Value::from_type(<TreeViewGridLines as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-grid-lines\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `enable-grid-lines` getter")
        }
    }

    fn set_enable_grid_lines(&self, enable_grid_lines: TreeViewGridLines) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-grid-lines\0".as_ptr() as *const _,
                enable_grid_lines.to_value().to_glib_none().0,
            );
        }
    }

    fn set_ubuntu_almost_fixed_height_mode(&self, ubuntu_almost_fixed_height_mode: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"ubuntu-almost-fixed-height-mode\0".as_ptr() as *const _,
                ubuntu_almost_fixed_height_mode.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_columns_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn columns_changed_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"columns-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    columns_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cursor_changed_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cursor-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cursor_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_expand_collapse_cursor_row<F: Fn(&Self, bool, bool, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn expand_collapse_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, bool, bool, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            object: glib::ffi::gboolean,
            p0: glib::ffi::gboolean,
            p1: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
                from_glib(p0),
                from_glib(p1),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"expand-collapse-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    expand_collapse_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_expand_collapse_cursor_row(&self, object: bool, p0: bool, p1: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("expand-collapse-cursor-row", &[&object, &p0, &p1])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_expand_collapse_cursor_row`")
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, MovementStep, i32) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            step: ffi::GtkMovementStep,
            direction: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                direction,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, direction: i32) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-cursor", &[&step, &direction])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_move_cursor`")
    }

    fn connect_row_activated<F: Fn(&Self, &TreePath, &TreeViewColumn) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_activated_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreePath, &TreeViewColumn) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            path: *mut ffi::GtkTreePath,
            column: *mut ffi::GtkTreeViewColumn,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(path),
                &from_glib_borrow(column),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_row_activated(&self, path: &TreePath, column: &TreeViewColumn) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("row-activated", &[&path, &column])
                .unwrap()
        };
    }

    fn connect_row_collapsed<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_collapsed_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-collapsed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_collapsed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_row_expanded<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_expanded_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-expanded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_expanded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_select_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-all", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_select_all`")
    }

    fn connect_select_cursor_parent<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_parent_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_cursor_parent(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-cursor-parent", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_select_cursor_parent`")
    }

    fn connect_select_cursor_row<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            object: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_cursor_row(&self, object: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-cursor-row", &[&object])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_select_cursor_row`")
    }

    fn connect_start_interactive_search<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn start_interactive_search_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"start-interactive-search\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    start_interactive_search_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_start_interactive_search(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("start-interactive-search", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_start_interactive_search`")
    }

    fn connect_test_collapse_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn test_collapse_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"test-collapse-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    test_collapse_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_test_expand_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn test_expand_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"test-expand-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    test_expand_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_toggle_cursor_row<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_row(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("toggle-cursor-row", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_toggle_cursor_row`")
    }

    fn connect_unselect_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unselect-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unselect_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_unselect_all(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("unselect-all", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_unselect_all`")
    }

    fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activate-on-single-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_grid_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_grid_lines_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-grid-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_grid_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_search_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-search\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_search_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_tree_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_tree_lines_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-tree-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_tree_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_expander_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expander_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expander-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expander_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fixed_height_mode_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fixed-height-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fixed_height_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_headers_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_headers_clickable_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::headers-clickable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_headers_clickable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_headers_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_headers_visible_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::headers-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_headers_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hover_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hover_expand_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hover-expand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hover_expand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hover_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hover_selection_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hover-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hover_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_level_indentation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_level_indentation_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::level-indentation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_level_indentation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rubber_banding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rubber_banding_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rubber-banding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rubber_banding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_search_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::search-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_search_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_expanders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_expanders_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-expanders\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_expanders_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_ubuntu_almost_fixed_height_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_ubuntu_almost_fixed_height_mode_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ubuntu-almost-fixed-height-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ubuntu_almost_fixed_height_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TreeView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TreeView")
    }
}
