#!/usr/bin/perl
use strict;
use warnings;

use WWW::Curl::Easy;
use WWW::Curl::Share;

my $count = 5;
while ($count--) {
    if (my $pid = fork) {
	&doloop;
    }
    else {
	&doloop;
   }
}
exit;

INIT {
    my $curlsh = new WWW::Curl::Share;
    $curlsh->setopt(CURLSHOPT_SHARE, CURL_LOCK_DATA_DNS);
    print "Share is $curlsh\n";

    sub doloop
      {
    my $curl;
    
	  unless ($curl) {
	      $curl = new WWW::Curl::Easy;
	      $curl->setopt(CURLOPT_SHARE, $curlsh);

	      $curl->setopt(CURLOPT_VERBOSE, 1);
	      $curl->setopt(CURLOPT_DNS_CACHE_TIMEOUT, -1);
	      $curl->setopt(CURLOPT_CONNECT_ONLY, 1);
	      $curl->setopt(CURLOPT_FORBID_REUSE, 1);
	      $curl->setopt(CURLOPT_URL, 'http://ftp.us.debian.org');
	  }
	  $curl->perform;
      }
}


