subroutine u2mesg(typ, idmess, nk, valk, ni,&
                  vali, nr, valr)
! ======================================================================
! COPYRIGHT (C) 1991 - 2013  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: mathieu.courtois at edf.fr
!
    implicit none
#include "asterc/getres.h"
#include "asterc/isjvup.h"
#include "asterc/uexcep.h"
#include "asterc/utprin.h"
#include "asterfort/assert.h"
#include "asterfort/ib1mai.h"
#include "asterfort/jedema.h"
#include "asterfort/jedetc.h"
#include "asterfort/jedetv.h"
#include "asterfort/jefini.h"
#include "asterfort/jemarq.h"
#include "asterfort/jevema.h"
#include "asterfort/lxlgut.h"
#include "asterfort/mpicmw.h"
#include "asterfort/onerrf.h"
#include "asterfort/trabck.h"
    character(len=*) :: typ, idmess, valk(*)
    integer :: nk, ni, vali(*), nr
    real(kind=8) :: valr(*)
!
    integer :: nexcep
    common /utexc /  nexcep
!
    integer :: recurs
    character(len=16) :: compex
    character(len=8) :: nomres, k8b
    character(len=2) :: typm
    logical :: lerror, lvalid, labort, suite, lstop, lerrm, ltrb
    integer :: lout, idf, i, lc, imaap
    integer :: numex
!
    save             recurs
!
!     TYPES DE MESSAGES :
!     ERREURS :
!       F : ERREUR AVEC DESTRUCTION DU CONCEPT PRODUIT PAR LA COMMANDE
!       S : ERREUR AVEC VALIDATION DU CONCEPT, EXCEPTION
!       Z : LEVEE D'EXCEPTION PARTICULIERE, COMME 'S'
!       M : ERREUR SUIVIE DE MPI_ABORT, NE PAS LEVER D'EXCEPTION --> 'F'
!     MESSAGES :
!       E : SIMPLE MESSAGE D'ERREUR QUI SERA SUIVI D'UNE ERREUR 'F'
!       D : COMME 'E' MAIS AFFICHE AVEC 'F' POUR ASSURER UN 'D'IAGNOSTIC
!       I : INFORMATION
!       A : ALARME
!
!     LE TRACEBACK INTEL, SI DISPO, EST AFFICHE EN CAS D'ERREUR OU
!     EXCEPTION DVP_NNN, OU ERREUR 'D' CAR SUIVIE DE MPI_ABORT
    typm = typ
    idf = index('EFIMASZD', typm(1:1))
    call assert(idf .ne. 0)
    lstop = .false.
!
!     --- COMPORTEMENT EN CAS D'ERREUR
    call onerrf(' ', compex, lout)
!
    lerrm = idf.eq.4
    if (lerrm) then
        idf = 2
        typm(1:1) = 'F'
!       L'EXCEPTION A-T-ELLE DEJA ETE LEVEE ?
        if (recurs .ne. 0) then
!         L'EXCEPTION A DEJA ETE LEVEE
            recurs = 0
        else
            lerrm = .false.
        endif
    endif
!
    lerror = idf.eq.2 .or. idf.eq.6 .or. idf.eq.7
!     DOIT-ON VALIDER LE CONCEPT ?
    lvalid = (idf.eq.6 .or. idf.eq.7) .or. (idf.eq.2 .and. compex(1:lout).eq.'EXCEPTION+VALID')
!     DOIT-ON S'ARRETER BRUTALEMENT (POUR DEBUG) ?
    labort = idf.eq.2 .and. compex(1:lout).eq.'ABORT'
!     AFFICHIER LE TRACEBACK SI DISPONIBLE
    ltrb = labort .or. (lerror .and. idmess(1:4).eq.'DVP_') .or. idf.eq.8
!
    suite = .false.
    if (len(typm) .gt. 1) then
        if (typm(2:2) .eq. '+') suite=.true.
    endif
!
! --- SE PROTEGER DES APPELS RECURSIFS POUR LES MESSAGES D'ERREUR
    if (lerror) then
        if (recurs .eq. 1234567891) then
            call jefini('ERREUR')
        endif
!
        if (recurs .eq. 1234567890) then
            recurs = 1234567891
!          ON EST DEJA PASSE PAR U2MESG... SANS EN ETRE SORTI
            call utprin('F', 0, 'CATAMESS_55', 0, valk,&
                        0, vali, 0, valr)
!          ON NE FAIT PLUS RIEN ET ON SORT DE LA ROUTINE
            goto 999
        endif
        recurs = 1234567890
    endif
!
    call jevema(imaap)
    if (imaap .ge. 200) call jefini('ERREUR')
    if (isjvup() .eq. 1) then
        call jemarq()
    endif
!
    numex = nexcep
    if (lerror .and. idf .ne. 7) then
!     SI EXCEPTION, NEXCEP EST FIXE PAR COMMON VIA UTEXCP
!     SINON ON LEVE L'EXCEPTION DE BASE ASTER.ERROR
        numex = 21
    endif
!
    call utprin(typm, numex, idmess, nk, valk,&
                ni, vali, nr, valr)
!
!     --- REMONTEE D'ERREUR SI DISPO
    if (ltrb) then
        call trabck('Traceback printed by Intel compiler', int(-1,4))
    endif
! --- EN CAS DE MESSAGE AVEC SUITE, PAS D'ARRET, PAS D'EXCEPTION
    if (.not. suite) then
!
!     -- ABORT SUR ERREUR <F> "ORDINAIRE"
        if (labort) then
!           AVERTIR LE PROC #0 QU'ON A RENCONTRE UN PROBLEME !
            call mpicmw(0)
!
            call jefini('ERREUR')
!
!     -- LEVEE D'UNE EXCEPTION
        else if (lerror) then
!
!        -- QUELLE EXCEPTION ?
!           SI EXCEPTION, NEXCEP EST FIXE PAR COMMON VIA UTEXCP
!           IL A ETE COPIE DANS NUMEX POUR NE PAS ETRE MODIFIE SI
!           DES APPELS SONT IMBRIQUES
            if (idf .ne. 7) then
!           SINON ON LEVE L'EXCEPTION DE BASE ASTER.ERROR
                numex = 21
            endif
!
!           NOM DU CONCEPT COURANT
            call getres(nomres, k8b, k8b)
!
            if (nomres .ne. ' ') then
!             LE CONCEPT EST REPUTE VALIDE :
!               - SI ERREUR <S> OU EXCEPTION
!               - SI ERREUR <F> MAIS LA COMMANDE A DIT "EXCEPTION+VALID"
                if (lvalid) then
                    call utprin('I', 0, 'CATAMESS_70', 1, nomres,&
                                0, vali, 0, valr)
!
!             SINON LE CONCEPT COURANT EST DETRUIT
                else
                    call utprin('I', 0, 'CATAMESS_69', 1, nomres,&
                                0, vali, 0, valr)
                    lc = lxlgut(nomres)
                    if (lc .gt. 0) then
                        call jedetc(' ', nomres(1:lc), 1)
                    endif
                endif
            endif
!
            if (isjvup() .eq. 1) then
!
!             -- MENAGE SUR LA BASE VOLATILE
                call jedetv()
!
!             REMONTER LES N JEDEMA COURT-CIRCUITES
                call jevema(imaap)
                do 10 i = imaap, 1, -1
                    call jedema()
10              continue
!
            endif
!
!           AVERTIR LE PROC #0 QU'ON A RENCONTRE UN PROBLEME !
            call mpicmw(1)
!
!           ON REMONTE UNE EXCEPTION AU LIEU DE FERMER LES BASES
            if (lerror) recurs = 0
            lstop = .true.
            if (.not. lerrm) then
                call ib1mai()
                call uexcep(numex, idmess, nk, valk, ni,&
                            vali, nr, valr)
            endif
        endif
!
    endif
!
    if (lerror) recurs = 0
999  continue
    if (isjvup() .eq. 1 .and. .not. lstop) then
        call jedema()
    endif
end subroutine
