/* -*- mode: c -*- */

/* Licensed under a 3-clause BSD style license - see LICENSE.rst */

/* "core.c" is auto-generated by erfa_generator.py from the template
   "core.c.templ". Do *not* edit "core.c" directly, instead edit
   "core.c.templ" and run erfa_generator.py from the source directory to
   update it. */


#include <Python.h>
#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION
#include <numpy/arrayobject.h>
#include "erfa.h"


typedef struct {
    PyObject_HEAD
    NpyIter *iter;
} _NpyIterObject;


#define MODULE_DOCSTRING \
    "This module contains the C part of the ERFA python wrappers.\n" \
    "This implements only the inner iterator loops, while the heavy lifting\n" \
    "happens in Python in core.py\n\n" \
    "For more about the module and how to use it, see the ``core.py``\n" \
    "docstrings."

static PyObject *Py_cal2jd(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_djm0);
    double (*_djm);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _iy = ((int (*))(dataptrarray[0]));
        _im = ((int (*))(dataptrarray[1]));
        _id = ((int (*))(dataptrarray[2]));
        _djm0 = ((double (*))(dataptrarray[3]));
        _djm = ((double (*))(dataptrarray[4]));

        _c_retval = eraCal2jd(*_iy, *_im, *_id, _djm0, _djm);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_epb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dj1 = ((double (*))(dataptrarray[0]));
        _dj2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEpb(*_dj1, *_dj2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_epb2jd(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epb);
    double (*_djm0);
    double (*_djm);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epb = ((double (*))(dataptrarray[0]));
        _djm0 = ((double (*))(dataptrarray[1]));
        _djm = ((double (*))(dataptrarray[2]));

        eraEpb2jd(*_epb, _djm0, _djm);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_epj(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dj1 = ((double (*))(dataptrarray[0]));
        _dj2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEpj(*_dj1, *_dj2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_epj2jd(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_djm0);
    double (*_djm);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _djm0 = ((double (*))(dataptrarray[1]));
        _djm = ((double (*))(dataptrarray[2]));

        eraEpj2jd(*_epj, _djm0, _djm);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_jd2cal(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dj1);
    double (*_dj2);
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_fd);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dj1 = ((double (*))(dataptrarray[0]));
        _dj2 = ((double (*))(dataptrarray[1]));
        _iy = ((int (*))(dataptrarray[2]));
        _im = ((int (*))(dataptrarray[3]));
        _id = ((int (*))(dataptrarray[4]));
        _fd = ((double (*))(dataptrarray[5]));

        _c_retval = eraJd2cal(*_dj1, *_dj2, _iy, _im, _id, _fd);
        *((int *)(dataptrarray[6])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_jdcalf(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_ndp);
    double (*_dj1);
    double (*_dj2);
    int (*_iymdf)[4];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ndp = ((int (*))(dataptrarray[0]));
        _dj1 = ((double (*))(dataptrarray[1]));
        _dj2 = ((double (*))(dataptrarray[2]));
        _iymdf = ((int (*)[4])(dataptrarray[3]));

        _c_retval = eraJdcalf(*_ndp, *_dj1, *_dj2, *_iymdf);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_ab(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_pnat)[3];
    double (*_v)[3];
    double (*_s);
    double (*_bm1);
    double (*_ppr)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _pnat = ((double (*)[3])(dataptrarray[0]));
        _v = ((double (*)[3])(dataptrarray[1]));
        _s = ((double (*))(dataptrarray[2]));
        _bm1 = ((double (*))(dataptrarray[3]));
        _ppr = ((double (*)[3])(dataptrarray[4]));

        eraAb(*_pnat, *_v, *_s, *_bm1, *_ppr);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apcg(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double (*_ehp)[3];
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _ebpv = ((double (*)[2][3])(dataptrarray[2]));
        _ehp = ((double (*)[3])(dataptrarray[3]));
        _astrom = ((eraASTROM (*))(dataptrarray[4]));

        eraApcg(*_date1, *_date2, *_ebpv, *_ehp, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apcg13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));

        eraApcg13(*_date1, *_date2, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apci(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double (*_ehp)[3];
    double (*_x);
    double (*_y);
    double (*_s);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _ebpv = ((double (*)[2][3])(dataptrarray[2]));
        _ehp = ((double (*)[3])(dataptrarray[3]));
        _x = ((double (*))(dataptrarray[4]));
        _y = ((double (*))(dataptrarray[5]));
        _s = ((double (*))(dataptrarray[6]));
        _astrom = ((eraASTROM (*))(dataptrarray[7]));

        eraApci(*_date1, *_date2, *_ebpv, *_ehp, *_x, *_y, *_s, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apci13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    eraASTROM (*_astrom);
    double (*_eo);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));
        _eo = ((double (*))(dataptrarray[3]));

        eraApci13(*_date1, *_date2, _astrom, _eo);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apco(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double (*_ehp)[3];
    double (*_x);
    double (*_y);
    double (*_s);
    double (*_theta);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double (*_refa);
    double (*_refb);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _ebpv = ((double (*)[2][3])(dataptrarray[2]));
        _ehp = ((double (*)[3])(dataptrarray[3]));
        _x = ((double (*))(dataptrarray[4]));
        _y = ((double (*))(dataptrarray[5]));
        _s = ((double (*))(dataptrarray[6]));
        _theta = ((double (*))(dataptrarray[7]));
        _elong = ((double (*))(dataptrarray[8]));
        _phi = ((double (*))(dataptrarray[9]));
        _hm = ((double (*))(dataptrarray[10]));
        _xp = ((double (*))(dataptrarray[11]));
        _yp = ((double (*))(dataptrarray[12]));
        _sp = ((double (*))(dataptrarray[13]));
        _refa = ((double (*))(dataptrarray[14]));
        _refb = ((double (*))(dataptrarray[15]));
        _astrom = ((eraASTROM (*))(dataptrarray[16]));

        eraApco(*_date1, *_date2, *_ebpv, *_ehp, *_x, *_y, *_s, *_theta, *_elong, *_phi, *_hm, *_xp, *_yp, *_sp, *_refa, *_refb, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apco13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    eraASTROM (*_astrom);
    double (*_eo);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _utc1 = ((double (*))(dataptrarray[0]));
        _utc2 = ((double (*))(dataptrarray[1]));
        _dut1 = ((double (*))(dataptrarray[2]));
        _elong = ((double (*))(dataptrarray[3]));
        _phi = ((double (*))(dataptrarray[4]));
        _hm = ((double (*))(dataptrarray[5]));
        _xp = ((double (*))(dataptrarray[6]));
        _yp = ((double (*))(dataptrarray[7]));
        _phpa = ((double (*))(dataptrarray[8]));
        _tc = ((double (*))(dataptrarray[9]));
        _rh = ((double (*))(dataptrarray[10]));
        _wl = ((double (*))(dataptrarray[11]));
        _astrom = ((eraASTROM (*))(dataptrarray[12]));
        _eo = ((double (*))(dataptrarray[13]));

        _c_retval = eraApco13(*_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _astrom, _eo);
        *((int *)(dataptrarray[14])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_apcs(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_pv)[2][3];
    double (*_ebpv)[2][3];
    double (*_ehp)[3];
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _pv = ((double (*)[2][3])(dataptrarray[2]));
        _ebpv = ((double (*)[2][3])(dataptrarray[3]));
        _ehp = ((double (*)[3])(dataptrarray[4]));
        _astrom = ((eraASTROM (*))(dataptrarray[5]));

        eraApcs(*_date1, *_date2, *_pv, *_ebpv, *_ehp, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apcs13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_pv)[2][3];
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _pv = ((double (*)[2][3])(dataptrarray[2]));
        _astrom = ((eraASTROM (*))(dataptrarray[3]));

        eraApcs13(*_date1, *_date2, *_pv, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_aper(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_theta);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _theta = ((double (*))(dataptrarray[0]));
        _astrom = ((eraASTROM (*))(dataptrarray[1]));

        eraAper(*_theta, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_aper13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ut11);
    double (*_ut12);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ut11 = ((double (*))(dataptrarray[0]));
        _ut12 = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));

        eraAper13(*_ut11, *_ut12, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apio(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_sp);
    double (*_theta);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_refa);
    double (*_refb);
    eraASTROM (*_astrom);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _sp = ((double (*))(dataptrarray[0]));
        _theta = ((double (*))(dataptrarray[1]));
        _elong = ((double (*))(dataptrarray[2]));
        _phi = ((double (*))(dataptrarray[3]));
        _hm = ((double (*))(dataptrarray[4]));
        _xp = ((double (*))(dataptrarray[5]));
        _yp = ((double (*))(dataptrarray[6]));
        _refa = ((double (*))(dataptrarray[7]));
        _refb = ((double (*))(dataptrarray[8]));
        _astrom = ((eraASTROM (*))(dataptrarray[9]));

        eraApio(*_sp, *_theta, *_elong, *_phi, *_hm, *_xp, *_yp, *_refa, *_refb, _astrom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_apio13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    eraASTROM (*_astrom);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _utc1 = ((double (*))(dataptrarray[0]));
        _utc2 = ((double (*))(dataptrarray[1]));
        _dut1 = ((double (*))(dataptrarray[2]));
        _elong = ((double (*))(dataptrarray[3]));
        _phi = ((double (*))(dataptrarray[4]));
        _hm = ((double (*))(dataptrarray[5]));
        _xp = ((double (*))(dataptrarray[6]));
        _yp = ((double (*))(dataptrarray[7]));
        _phpa = ((double (*))(dataptrarray[8]));
        _tc = ((double (*))(dataptrarray[9]));
        _rh = ((double (*))(dataptrarray[10]));
        _wl = ((double (*))(dataptrarray[11]));
        _astrom = ((eraASTROM (*))(dataptrarray[12]));

        _c_retval = eraApio13(*_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _astrom);
        *((int *)(dataptrarray[13])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_atci13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_date1);
    double (*_date2);
    double (*_ri);
    double (*_di);
    double (*_eo);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _pr = ((double (*))(dataptrarray[2]));
        _pd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _date1 = ((double (*))(dataptrarray[6]));
        _date2 = ((double (*))(dataptrarray[7]));
        _ri = ((double (*))(dataptrarray[8]));
        _di = ((double (*))(dataptrarray[9]));
        _eo = ((double (*))(dataptrarray[10]));

        eraAtci13(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_date1, *_date2, _ri, _di, _eo);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atciq(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _pr = ((double (*))(dataptrarray[2]));
        _pd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _astrom = ((eraASTROM (*))(dataptrarray[6]));
        _ri = ((double (*))(dataptrarray[7]));
        _di = ((double (*))(dataptrarray[8]));

        eraAtciq(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, _astrom, _ri, _di);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atciqn(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    eraASTROM (*_astrom);
    int (*_n);
    eraLDBODY (*_b);
    double (*_ri);
    double (*_di);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _pr = ((double (*))(dataptrarray[2]));
        _pd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _astrom = ((eraASTROM (*))(dataptrarray[6]));
        _n = ((int (*))(dataptrarray[7]));
        _b = ((eraLDBODY (*))(dataptrarray[8]));
        _ri = ((double (*))(dataptrarray[9]));
        _di = ((double (*))(dataptrarray[10]));

        eraAtciqn(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, _astrom, *_n, _b, _ri, _di);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atciqz(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));
        _ri = ((double (*))(dataptrarray[3]));
        _di = ((double (*))(dataptrarray[4]));

        eraAtciqz(*_rc, *_dc, _astrom, _ri, _di);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atco13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    double (*_eo);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _pr = ((double (*))(dataptrarray[2]));
        _pd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _utc1 = ((double (*))(dataptrarray[6]));
        _utc2 = ((double (*))(dataptrarray[7]));
        _dut1 = ((double (*))(dataptrarray[8]));
        _elong = ((double (*))(dataptrarray[9]));
        _phi = ((double (*))(dataptrarray[10]));
        _hm = ((double (*))(dataptrarray[11]));
        _xp = ((double (*))(dataptrarray[12]));
        _yp = ((double (*))(dataptrarray[13]));
        _phpa = ((double (*))(dataptrarray[14]));
        _tc = ((double (*))(dataptrarray[15]));
        _rh = ((double (*))(dataptrarray[16]));
        _wl = ((double (*))(dataptrarray[17]));
        _aob = ((double (*))(dataptrarray[18]));
        _zob = ((double (*))(dataptrarray[19]));
        _hob = ((double (*))(dataptrarray[20]));
        _dob = ((double (*))(dataptrarray[21]));
        _rob = ((double (*))(dataptrarray[22]));
        _eo = ((double (*))(dataptrarray[23]));

        _c_retval = eraAtco13(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _aob, _zob, _hob, _dob, _rob, _eo);
        *((int *)(dataptrarray[24])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_atic13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ri);
    double (*_di);
    double (*_date1);
    double (*_date2);
    double (*_rc);
    double (*_dc);
    double (*_eo);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ri = ((double (*))(dataptrarray[0]));
        _di = ((double (*))(dataptrarray[1]));
        _date1 = ((double (*))(dataptrarray[2]));
        _date2 = ((double (*))(dataptrarray[3]));
        _rc = ((double (*))(dataptrarray[4]));
        _dc = ((double (*))(dataptrarray[5]));
        _eo = ((double (*))(dataptrarray[6]));

        eraAtic13(*_ri, *_di, *_date1, *_date2, _rc, _dc, _eo);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_aticq(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    double (*_rc);
    double (*_dc);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ri = ((double (*))(dataptrarray[0]));
        _di = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));
        _rc = ((double (*))(dataptrarray[3]));
        _dc = ((double (*))(dataptrarray[4]));

        eraAticq(*_ri, *_di, _astrom, _rc, _dc);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_aticqn(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    int (*_n);
    eraLDBODY (*_b);
    double (*_rc);
    double (*_dc);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ri = ((double (*))(dataptrarray[0]));
        _di = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));
        _n = ((int (*))(dataptrarray[3]));
        _b = ((eraLDBODY (*))(dataptrarray[4]));
        _rc = ((double (*))(dataptrarray[5]));
        _dc = ((double (*))(dataptrarray[6]));

        eraAticqn(*_ri, *_di, _astrom, *_n, _b, _rc, _dc);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atio13(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ri);
    double (*_di);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ri = ((double (*))(dataptrarray[0]));
        _di = ((double (*))(dataptrarray[1]));
        _utc1 = ((double (*))(dataptrarray[2]));
        _utc2 = ((double (*))(dataptrarray[3]));
        _dut1 = ((double (*))(dataptrarray[4]));
        _elong = ((double (*))(dataptrarray[5]));
        _phi = ((double (*))(dataptrarray[6]));
        _hm = ((double (*))(dataptrarray[7]));
        _xp = ((double (*))(dataptrarray[8]));
        _yp = ((double (*))(dataptrarray[9]));
        _phpa = ((double (*))(dataptrarray[10]));
        _tc = ((double (*))(dataptrarray[11]));
        _rh = ((double (*))(dataptrarray[12]));
        _wl = ((double (*))(dataptrarray[13]));
        _aob = ((double (*))(dataptrarray[14]));
        _zob = ((double (*))(dataptrarray[15]));
        _hob = ((double (*))(dataptrarray[16]));
        _dob = ((double (*))(dataptrarray[17]));
        _rob = ((double (*))(dataptrarray[18]));

        _c_retval = eraAtio13(*_ri, *_di, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _aob, _zob, _hob, _dob, _rob);
        *((int *)(dataptrarray[19])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_atioq(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ri = ((double (*))(dataptrarray[0]));
        _di = ((double (*))(dataptrarray[1]));
        _astrom = ((eraASTROM (*))(dataptrarray[2]));
        _aob = ((double (*))(dataptrarray[3]));
        _zob = ((double (*))(dataptrarray[4]));
        _hob = ((double (*))(dataptrarray[5]));
        _dob = ((double (*))(dataptrarray[6]));
        _rob = ((double (*))(dataptrarray[7]));

        eraAtioq(*_ri, *_di, _astrom, _aob, _zob, _hob, _dob, _rob);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_atoc13(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_rc);
    double (*_dc);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _type = ((const char (*))(dataptrarray[0]));
        _ob1 = ((double (*))(dataptrarray[1]));
        _ob2 = ((double (*))(dataptrarray[2]));
        _utc1 = ((double (*))(dataptrarray[3]));
        _utc2 = ((double (*))(dataptrarray[4]));
        _dut1 = ((double (*))(dataptrarray[5]));
        _elong = ((double (*))(dataptrarray[6]));
        _phi = ((double (*))(dataptrarray[7]));
        _hm = ((double (*))(dataptrarray[8]));
        _xp = ((double (*))(dataptrarray[9]));
        _yp = ((double (*))(dataptrarray[10]));
        _phpa = ((double (*))(dataptrarray[11]));
        _tc = ((double (*))(dataptrarray[12]));
        _rh = ((double (*))(dataptrarray[13]));
        _wl = ((double (*))(dataptrarray[14]));
        _rc = ((double (*))(dataptrarray[15]));
        _dc = ((double (*))(dataptrarray[16]));

        _c_retval = eraAtoc13(_type, *_ob1, *_ob2, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _rc, _dc);
        *((int *)(dataptrarray[17])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_atoi13(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_ri);
    double (*_di);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _type = ((const char (*))(dataptrarray[0]));
        _ob1 = ((double (*))(dataptrarray[1]));
        _ob2 = ((double (*))(dataptrarray[2]));
        _utc1 = ((double (*))(dataptrarray[3]));
        _utc2 = ((double (*))(dataptrarray[4]));
        _dut1 = ((double (*))(dataptrarray[5]));
        _elong = ((double (*))(dataptrarray[6]));
        _phi = ((double (*))(dataptrarray[7]));
        _hm = ((double (*))(dataptrarray[8]));
        _xp = ((double (*))(dataptrarray[9]));
        _yp = ((double (*))(dataptrarray[10]));
        _phpa = ((double (*))(dataptrarray[11]));
        _tc = ((double (*))(dataptrarray[12]));
        _rh = ((double (*))(dataptrarray[13]));
        _wl = ((double (*))(dataptrarray[14]));
        _ri = ((double (*))(dataptrarray[15]));
        _di = ((double (*))(dataptrarray[16]));

        _c_retval = eraAtoi13(_type, *_ob1, *_ob2, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _ri, _di);
        *((int *)(dataptrarray[17])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_atoiq(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _type = ((const char (*))(dataptrarray[0]));
        _ob1 = ((double (*))(dataptrarray[1]));
        _ob2 = ((double (*))(dataptrarray[2]));
        _astrom = ((eraASTROM (*))(dataptrarray[3]));
        _ri = ((double (*))(dataptrarray[4]));
        _di = ((double (*))(dataptrarray[5]));

        eraAtoiq(_type, *_ob1, *_ob2, _astrom, _ri, _di);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ld(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_bm);
    double (*_p)[3];
    double (*_q)[3];
    double (*_e)[3];
    double (*_em);
    double (*_dlim);
    double (*_p1)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _bm = ((double (*))(dataptrarray[0]));
        _p = ((double (*)[3])(dataptrarray[1]));
        _q = ((double (*)[3])(dataptrarray[2]));
        _e = ((double (*)[3])(dataptrarray[3]));
        _em = ((double (*))(dataptrarray[4]));
        _dlim = ((double (*))(dataptrarray[5]));
        _p1 = ((double (*)[3])(dataptrarray[6]));

        eraLd(*_bm, *_p, *_q, *_e, *_em, *_dlim, *_p1);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ldn(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_n);
    eraLDBODY (*_b);
    double (*_ob)[3];
    double (*_sc)[3];
    double (*_sn)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _n = ((int (*))(dataptrarray[0]));
        _b = ((eraLDBODY (*))(dataptrarray[1]));
        _ob = ((double (*)[3])(dataptrarray[2]));
        _sc = ((double (*)[3])(dataptrarray[3]));
        _sn = ((double (*)[3])(dataptrarray[4]));

        eraLdn(*_n, _b, *_ob, *_sc, *_sn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ldsun(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_p)[3];
    double (*_e)[3];
    double (*_em);
    double (*_p1)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _p = ((double (*)[3])(dataptrarray[0]));
        _e = ((double (*)[3])(dataptrarray[1]));
        _em = ((double (*))(dataptrarray[2]));
        _p1 = ((double (*)[3])(dataptrarray[3]));

        eraLdsun(*_p, *_e, *_em, *_p1);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pmpx(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_pmt);
    double (*_pob)[3];
    double (*_pco)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc = ((double (*))(dataptrarray[0]));
        _dc = ((double (*))(dataptrarray[1]));
        _pr = ((double (*))(dataptrarray[2]));
        _pd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _pmt = ((double (*))(dataptrarray[6]));
        _pob = ((double (*)[3])(dataptrarray[7]));
        _pco = ((double (*)[3])(dataptrarray[8]));

        eraPmpx(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_pmt, *_pob, *_pco);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pmsafe(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ra1);
    double (*_dec1);
    double (*_pmr1);
    double (*_pmd1);
    double (*_px1);
    double (*_rv1);
    double (*_ep1a);
    double (*_ep1b);
    double (*_ep2a);
    double (*_ep2b);
    double (*_ra2);
    double (*_dec2);
    double (*_pmr2);
    double (*_pmd2);
    double (*_px2);
    double (*_rv2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ra1 = ((double (*))(dataptrarray[0]));
        _dec1 = ((double (*))(dataptrarray[1]));
        _pmr1 = ((double (*))(dataptrarray[2]));
        _pmd1 = ((double (*))(dataptrarray[3]));
        _px1 = ((double (*))(dataptrarray[4]));
        _rv1 = ((double (*))(dataptrarray[5]));
        _ep1a = ((double (*))(dataptrarray[6]));
        _ep1b = ((double (*))(dataptrarray[7]));
        _ep2a = ((double (*))(dataptrarray[8]));
        _ep2b = ((double (*))(dataptrarray[9]));
        _ra2 = ((double (*))(dataptrarray[10]));
        _dec2 = ((double (*))(dataptrarray[11]));
        _pmr2 = ((double (*))(dataptrarray[12]));
        _pmd2 = ((double (*))(dataptrarray[13]));
        _px2 = ((double (*))(dataptrarray[14]));
        _rv2 = ((double (*))(dataptrarray[15]));

        _c_retval = eraPmsafe(*_ra1, *_dec1, *_pmr1, *_pmd1, *_px1, *_rv1, *_ep1a, *_ep1b, *_ep2a, *_ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2);
        *((int *)(dataptrarray[16])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_pvtob(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double (*_theta);
    double (*_pv)[2][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _elong = ((double (*))(dataptrarray[0]));
        _phi = ((double (*))(dataptrarray[1]));
        _hm = ((double (*))(dataptrarray[2]));
        _xp = ((double (*))(dataptrarray[3]));
        _yp = ((double (*))(dataptrarray[4]));
        _sp = ((double (*))(dataptrarray[5]));
        _theta = ((double (*))(dataptrarray[6]));
        _pv = ((double (*)[2][3])(dataptrarray[7]));

        eraPvtob(*_elong, *_phi, *_hm, *_xp, *_yp, *_sp, *_theta, *_pv);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_refco(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_refa);
    double (*_refb);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _phpa = ((double (*))(dataptrarray[0]));
        _tc = ((double (*))(dataptrarray[1]));
        _rh = ((double (*))(dataptrarray[2]));
        _wl = ((double (*))(dataptrarray[3]));
        _refa = ((double (*))(dataptrarray[4]));
        _refb = ((double (*))(dataptrarray[5]));

        eraRefco(*_phpa, *_tc, *_rh, *_wl, _refa, _refb);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_epv00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_pvh)[2][3];
    double (*_pvb)[2][3];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _pvh = ((double (*)[2][3])(dataptrarray[2]));
        _pvb = ((double (*)[2][3])(dataptrarray[3]));

        _c_retval = eraEpv00(*_date1, *_date2, *_pvh, *_pvb);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_plan94(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    int (*_np);
    double (*_pv)[2][3];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _np = ((int (*))(dataptrarray[2]));
        _pv = ((double (*)[2][3])(dataptrarray[3]));

        _c_retval = eraPlan94(*_date1, *_date2, *_np, *_pv);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_fad03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFad03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fae03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFae03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_faf03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFaf03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_faju03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFaju03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fal03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFal03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_falp03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFalp03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fama03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFama03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fame03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFame03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fane03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFane03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_faom03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFaom03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fapa03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFapa03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fasa03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFasa03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_faur03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFaur03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fave03(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_t);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _t = ((double (*))(dataptrarray[0]));

        _c_retval = eraFave03(*_t);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_bi00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dpsibi);
    double (*_depsbi);
    double (*_dra);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dpsibi = ((double (*))(dataptrarray[0]));
        _depsbi = ((double (*))(dataptrarray[1]));
        _dra = ((double (*))(dataptrarray[2]));

        eraBi00(_dpsibi, _depsbi, _dra);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_bp00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rb = ((double (*)[3][3])(dataptrarray[2]));
        _rp = ((double (*)[3][3])(dataptrarray[3]));
        _rbp = ((double (*)[3][3])(dataptrarray[4]));

        eraBp00(*_date1, *_date2, *_rb, *_rp, *_rbp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_bp06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rb = ((double (*)[3][3])(dataptrarray[2]));
        _rp = ((double (*)[3][3])(dataptrarray[3]));
        _rbp = ((double (*)[3][3])(dataptrarray[4]));

        eraBp06(*_date1, *_date2, *_rb, *_rp, *_rbp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_bpn2xy(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rbpn)[3][3];
    double (*_x);
    double (*_y);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rbpn = ((double (*)[3][3])(dataptrarray[0]));
        _x = ((double (*))(dataptrarray[1]));
        _y = ((double (*))(dataptrarray[2]));

        eraBpn2xy(*_rbpn, _x, _y);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2i00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rc2i = ((double (*)[3][3])(dataptrarray[2]));

        eraC2i00a(*_date1, *_date2, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2i00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rc2i = ((double (*)[3][3])(dataptrarray[2]));

        eraC2i00b(*_date1, *_date2, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2i06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rc2i = ((double (*)[3][3])(dataptrarray[2]));

        eraC2i06a(*_date1, *_date2, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2ibpn(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rbpn)[3][3];
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rbpn = ((double (*)[3][3])(dataptrarray[2]));
        _rc2i = ((double (*)[3][3])(dataptrarray[3]));

        eraC2ibpn(*_date1, *_date2, *_rbpn, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2ixy(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));
        _rc2i = ((double (*)[3][3])(dataptrarray[4]));

        eraC2ixy(*_date1, *_date2, *_x, *_y, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2ixys(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_x);
    double (*_y);
    double (*_s);
    double (*_rc2i)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _x = ((double (*))(dataptrarray[0]));
        _y = ((double (*))(dataptrarray[1]));
        _s = ((double (*))(dataptrarray[2]));
        _rc2i = ((double (*)[3][3])(dataptrarray[3]));

        eraC2ixys(*_x, *_y, *_s, *_rc2i);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2t00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tta = ((double (*))(dataptrarray[0]));
        _ttb = ((double (*))(dataptrarray[1]));
        _uta = ((double (*))(dataptrarray[2]));
        _utb = ((double (*))(dataptrarray[3]));
        _xp = ((double (*))(dataptrarray[4]));
        _yp = ((double (*))(dataptrarray[5]));
        _rc2t = ((double (*)[3][3])(dataptrarray[6]));

        eraC2t00a(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2t00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tta = ((double (*))(dataptrarray[0]));
        _ttb = ((double (*))(dataptrarray[1]));
        _uta = ((double (*))(dataptrarray[2]));
        _utb = ((double (*))(dataptrarray[3]));
        _xp = ((double (*))(dataptrarray[4]));
        _yp = ((double (*))(dataptrarray[5]));
        _rc2t = ((double (*)[3][3])(dataptrarray[6]));

        eraC2t00b(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2t06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tta = ((double (*))(dataptrarray[0]));
        _ttb = ((double (*))(dataptrarray[1]));
        _uta = ((double (*))(dataptrarray[2]));
        _utb = ((double (*))(dataptrarray[3]));
        _xp = ((double (*))(dataptrarray[4]));
        _yp = ((double (*))(dataptrarray[5]));
        _rc2t = ((double (*)[3][3])(dataptrarray[6]));

        eraC2t06a(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2tcio(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rc2i)[3][3];
    double (*_era);
    double (*_rpom)[3][3];
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rc2i = ((double (*)[3][3])(dataptrarray[0]));
        _era = ((double (*))(dataptrarray[1]));
        _rpom = ((double (*)[3][3])(dataptrarray[2]));
        _rc2t = ((double (*)[3][3])(dataptrarray[3]));

        eraC2tcio(*_rc2i, *_era, *_rpom, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2teqx(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rbpn)[3][3];
    double (*_gst);
    double (*_rpom)[3][3];
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rbpn = ((double (*)[3][3])(dataptrarray[0]));
        _gst = ((double (*))(dataptrarray[1]));
        _rpom = ((double (*)[3][3])(dataptrarray[2]));
        _rc2t = ((double (*)[3][3])(dataptrarray[3]));

        eraC2teqx(*_rbpn, *_gst, *_rpom, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2tpe(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_dpsi);
    double (*_deps);
    double (*_xp);
    double (*_yp);
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tta = ((double (*))(dataptrarray[0]));
        _ttb = ((double (*))(dataptrarray[1]));
        _uta = ((double (*))(dataptrarray[2]));
        _utb = ((double (*))(dataptrarray[3]));
        _dpsi = ((double (*))(dataptrarray[4]));
        _deps = ((double (*))(dataptrarray[5]));
        _xp = ((double (*))(dataptrarray[6]));
        _yp = ((double (*))(dataptrarray[7]));
        _rc2t = ((double (*)[3][3])(dataptrarray[8]));

        eraC2tpe(*_tta, *_ttb, *_uta, *_utb, *_dpsi, *_deps, *_xp, *_yp, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2txy(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_x);
    double (*_y);
    double (*_xp);
    double (*_yp);
    double (*_rc2t)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tta = ((double (*))(dataptrarray[0]));
        _ttb = ((double (*))(dataptrarray[1]));
        _uta = ((double (*))(dataptrarray[2]));
        _utb = ((double (*))(dataptrarray[3]));
        _x = ((double (*))(dataptrarray[4]));
        _y = ((double (*))(dataptrarray[5]));
        _xp = ((double (*))(dataptrarray[6]));
        _yp = ((double (*))(dataptrarray[7]));
        _rc2t = ((double (*)[3][3])(dataptrarray[8]));

        eraC2txy(*_tta, *_ttb, *_uta, *_utb, *_x, *_y, *_xp, *_yp, *_rc2t);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eo06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEo06a(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eors(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rnpb)[3][3];
    double (*_s);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rnpb = ((double (*)[3][3])(dataptrarray[0]));
        _s = ((double (*))(dataptrarray[1]));

        _c_retval = eraEors(*_rnpb, *_s);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fw2m(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_gamb);
    double (*_phib);
    double (*_psi);
    double (*_eps);
    double (*_r)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _gamb = ((double (*))(dataptrarray[0]));
        _phib = ((double (*))(dataptrarray[1]));
        _psi = ((double (*))(dataptrarray[2]));
        _eps = ((double (*))(dataptrarray[3]));
        _r = ((double (*)[3][3])(dataptrarray[4]));

        eraFw2m(*_gamb, *_phib, *_psi, *_eps, *_r);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fw2xy(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_gamb);
    double (*_phib);
    double (*_psi);
    double (*_eps);
    double (*_x);
    double (*_y);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _gamb = ((double (*))(dataptrarray[0]));
        _phib = ((double (*))(dataptrarray[1]));
        _psi = ((double (*))(dataptrarray[2]));
        _eps = ((double (*))(dataptrarray[3]));
        _x = ((double (*))(dataptrarray[4]));
        _y = ((double (*))(dataptrarray[5]));

        eraFw2xy(*_gamb, *_phib, *_psi, *_eps, _x, _y);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ltp(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_rp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _rp = ((double (*)[3][3])(dataptrarray[1]));

        eraLtp(*_epj, *_rp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ltpb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_rpb)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _rpb = ((double (*)[3][3])(dataptrarray[1]));

        eraLtpb(*_epj, *_rpb);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ltpecl(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_vec)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _vec = ((double (*)[3])(dataptrarray[1]));

        eraLtpecl(*_epj, *_vec);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ltpequ(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_veq)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _veq = ((double (*)[3])(dataptrarray[1]));

        eraLtpequ(*_epj, *_veq);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_num00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatn = ((double (*)[3][3])(dataptrarray[2]));

        eraNum00a(*_date1, *_date2, *_rmatn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_num00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatn = ((double (*)[3][3])(dataptrarray[2]));

        eraNum00b(*_date1, *_date2, *_rmatn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_num06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatn = ((double (*)[3][3])(dataptrarray[2]));

        eraNum06a(*_date1, *_date2, *_rmatn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_numat(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epsa);
    double (*_dpsi);
    double (*_deps);
    double (*_rmatn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epsa = ((double (*))(dataptrarray[0]));
        _dpsi = ((double (*))(dataptrarray[1]));
        _deps = ((double (*))(dataptrarray[2]));
        _rmatn = ((double (*)[3][3])(dataptrarray[3]));

        eraNumat(*_epsa, *_dpsi, *_deps, *_rmatn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_nut00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));

        eraNut00a(*_date1, *_date2, _dpsi, _deps);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_nut00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));

        eraNut00b(*_date1, *_date2, _dpsi, _deps);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_nut06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));

        eraNut06a(*_date1, *_date2, _dpsi, _deps);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_nut80(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));

        eraNut80(*_date1, *_date2, _dpsi, _deps);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_nutm80(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatn = ((double (*)[3][3])(dataptrarray[2]));

        eraNutm80(*_date1, *_date2, *_rmatn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_obl06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraObl06(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_obl80(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraObl80(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_p06e(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_eps0);
    double (*_psia);
    double (*_oma);
    double (*_bpa);
    double (*_bqa);
    double (*_pia);
    double (*_bpia);
    double (*_epsa);
    double (*_chia);
    double (*_za);
    double (*_zetaa);
    double (*_thetaa);
    double (*_pa);
    double (*_gam);
    double (*_phi);
    double (*_psi);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _eps0 = ((double (*))(dataptrarray[2]));
        _psia = ((double (*))(dataptrarray[3]));
        _oma = ((double (*))(dataptrarray[4]));
        _bpa = ((double (*))(dataptrarray[5]));
        _bqa = ((double (*))(dataptrarray[6]));
        _pia = ((double (*))(dataptrarray[7]));
        _bpia = ((double (*))(dataptrarray[8]));
        _epsa = ((double (*))(dataptrarray[9]));
        _chia = ((double (*))(dataptrarray[10]));
        _za = ((double (*))(dataptrarray[11]));
        _zetaa = ((double (*))(dataptrarray[12]));
        _thetaa = ((double (*))(dataptrarray[13]));
        _pa = ((double (*))(dataptrarray[14]));
        _gam = ((double (*))(dataptrarray[15]));
        _phi = ((double (*))(dataptrarray[16]));
        _psi = ((double (*))(dataptrarray[17]));

        eraP06e(*_date1, *_date2, _eps0, _psia, _oma, _bpa, _bqa, _pia, _bpia, _epsa, _chia, _za, _zetaa, _thetaa, _pa, _gam, _phi, _psi);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pb06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_bzeta);
    double (*_bz);
    double (*_btheta);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _bzeta = ((double (*))(dataptrarray[2]));
        _bz = ((double (*))(dataptrarray[3]));
        _btheta = ((double (*))(dataptrarray[4]));

        eraPb06(*_date1, *_date2, _bzeta, _bz, _btheta);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pfw06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_gamb);
    double (*_phib);
    double (*_psib);
    double (*_epsa);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _gamb = ((double (*))(dataptrarray[2]));
        _phib = ((double (*))(dataptrarray[3]));
        _psib = ((double (*))(dataptrarray[4]));
        _epsa = ((double (*))(dataptrarray[5]));

        eraPfw06(*_date1, *_date2, _gamb, _phib, _psib, _epsa);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pmat00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rbp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rbp = ((double (*)[3][3])(dataptrarray[2]));

        eraPmat00(*_date1, *_date2, *_rbp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pmat06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rbp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rbp = ((double (*)[3][3])(dataptrarray[2]));

        eraPmat06(*_date1, *_date2, *_rbp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pmat76(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatp)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatp = ((double (*)[3][3])(dataptrarray[2]));

        eraPmat76(*_date1, *_date2, *_rmatp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pn00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    double (*_rn)[3][3];
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));
        _epsa = ((double (*))(dataptrarray[4]));
        _rb = ((double (*)[3][3])(dataptrarray[5]));
        _rp = ((double (*)[3][3])(dataptrarray[6]));
        _rbp = ((double (*)[3][3])(dataptrarray[7]));
        _rn = ((double (*)[3][3])(dataptrarray[8]));
        _rbpn = ((double (*)[3][3])(dataptrarray[9]));

        eraPn00(*_date1, *_date2, *_dpsi, *_deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pn00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    double (*_rn)[3][3];
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));
        _epsa = ((double (*))(dataptrarray[4]));
        _rb = ((double (*)[3][3])(dataptrarray[5]));
        _rp = ((double (*)[3][3])(dataptrarray[6]));
        _rbp = ((double (*)[3][3])(dataptrarray[7]));
        _rn = ((double (*)[3][3])(dataptrarray[8]));
        _rbpn = ((double (*)[3][3])(dataptrarray[9]));

        eraPn00a(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pn00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    double (*_rn)[3][3];
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));
        _epsa = ((double (*))(dataptrarray[4]));
        _rb = ((double (*)[3][3])(dataptrarray[5]));
        _rp = ((double (*)[3][3])(dataptrarray[6]));
        _rbp = ((double (*)[3][3])(dataptrarray[7]));
        _rn = ((double (*)[3][3])(dataptrarray[8]));
        _rbpn = ((double (*)[3][3])(dataptrarray[9]));

        eraPn00b(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pn06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    double (*_rn)[3][3];
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));
        _epsa = ((double (*))(dataptrarray[4]));
        _rb = ((double (*)[3][3])(dataptrarray[5]));
        _rp = ((double (*)[3][3])(dataptrarray[6]));
        _rbp = ((double (*)[3][3])(dataptrarray[7]));
        _rn = ((double (*)[3][3])(dataptrarray[8]));
        _rbpn = ((double (*)[3][3])(dataptrarray[9]));

        eraPn06(*_date1, *_date2, *_dpsi, *_deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pn06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double (*_rb)[3][3];
    double (*_rp)[3][3];
    double (*_rbp)[3][3];
    double (*_rn)[3][3];
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsi = ((double (*))(dataptrarray[2]));
        _deps = ((double (*))(dataptrarray[3]));
        _epsa = ((double (*))(dataptrarray[4]));
        _rb = ((double (*)[3][3])(dataptrarray[5]));
        _rp = ((double (*)[3][3])(dataptrarray[6]));
        _rbp = ((double (*)[3][3])(dataptrarray[7]));
        _rn = ((double (*)[3][3])(dataptrarray[8]));
        _rbpn = ((double (*)[3][3])(dataptrarray[9]));

        eraPn06a(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pnm00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rbpn = ((double (*)[3][3])(dataptrarray[2]));

        eraPnm00a(*_date1, *_date2, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pnm00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rbpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rbpn = ((double (*)[3][3])(dataptrarray[2]));

        eraPnm00b(*_date1, *_date2, *_rbpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pnm06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rnpb)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rnpb = ((double (*)[3][3])(dataptrarray[2]));

        eraPnm06a(*_date1, *_date2, *_rnpb);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pnm80(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rmatpn)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rmatpn = ((double (*)[3][3])(dataptrarray[2]));

        eraPnm80(*_date1, *_date2, *_rmatpn);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pom00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double (*_rpom)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _xp = ((double (*))(dataptrarray[0]));
        _yp = ((double (*))(dataptrarray[1]));
        _sp = ((double (*))(dataptrarray[2]));
        _rpom = ((double (*)[3][3])(dataptrarray[3]));

        eraPom00(*_xp, *_yp, *_sp, *_rpom);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pr00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dpsipr);
    double (*_depspr);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dpsipr = ((double (*))(dataptrarray[2]));
        _depspr = ((double (*))(dataptrarray[3]));

        eraPr00(*_date1, *_date2, _dpsipr, _depspr);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_prec76(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date01);
    double (*_date02);
    double (*_date11);
    double (*_date12);
    double (*_zeta);
    double (*_z);
    double (*_theta);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date01 = ((double (*))(dataptrarray[0]));
        _date02 = ((double (*))(dataptrarray[1]));
        _date11 = ((double (*))(dataptrarray[2]));
        _date12 = ((double (*))(dataptrarray[3]));
        _zeta = ((double (*))(dataptrarray[4]));
        _z = ((double (*))(dataptrarray[5]));
        _theta = ((double (*))(dataptrarray[6]));

        eraPrec76(*_date01, *_date02, *_date11, *_date12, _zeta, _z, _theta);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));

        _c_retval = eraS00(*_date1, *_date2, *_x, *_y);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraS00a(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraS00b(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));

        _c_retval = eraS06(*_date1, *_date2, *_x, *_y);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraS06a(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_sp00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraSp00(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_xy06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));

        eraXy06(*_date1, *_date2, _x, _y);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_xys00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));
        _s = ((double (*))(dataptrarray[4]));

        eraXys00a(*_date1, *_date2, _x, _y, _s);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_xys00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));
        _s = ((double (*))(dataptrarray[4]));

        eraXys00b(*_date1, *_date2, _x, _y, _s);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_xys06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _x = ((double (*))(dataptrarray[2]));
        _y = ((double (*))(dataptrarray[3]));
        _s = ((double (*))(dataptrarray[4]));

        eraXys06a(*_date1, *_date2, _x, _y, _s);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ee00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_epsa);
    double (*_dpsi);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _epsa = ((double (*))(dataptrarray[2]));
        _dpsi = ((double (*))(dataptrarray[3]));

        _c_retval = eraEe00(*_date1, *_date2, *_epsa, *_dpsi);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ee00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEe00a(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ee00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEe00b(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ee06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEe06a(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eect00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEect00(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eqeq94(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEqeq94(*_date1, *_date2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_era00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dj1 = ((double (*))(dataptrarray[0]));
        _dj2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraEra00(*_dj1, *_dj2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gmst00(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));
        _tta = ((double (*))(dataptrarray[2]));
        _ttb = ((double (*))(dataptrarray[3]));

        _c_retval = eraGmst00(*_uta, *_utb, *_tta, *_ttb);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gmst06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));
        _tta = ((double (*))(dataptrarray[2]));
        _ttb = ((double (*))(dataptrarray[3]));

        _c_retval = eraGmst06(*_uta, *_utb, *_tta, *_ttb);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gmst82(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dj1 = ((double (*))(dataptrarray[0]));
        _dj2 = ((double (*))(dataptrarray[1]));

        _c_retval = eraGmst82(*_dj1, *_dj2);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gst00a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));
        _tta = ((double (*))(dataptrarray[2]));
        _ttb = ((double (*))(dataptrarray[3]));

        _c_retval = eraGst00a(*_uta, *_utb, *_tta, *_ttb);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gst00b(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));

        _c_retval = eraGst00b(*_uta, *_utb);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gst06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double (*_rnpb)[3][3];
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));
        _tta = ((double (*))(dataptrarray[2]));
        _ttb = ((double (*))(dataptrarray[3]));
        _rnpb = ((double (*)[3][3])(dataptrarray[4]));

        _c_retval = eraGst06(*_uta, *_utb, *_tta, *_ttb, *_rnpb);
        *((double *)(dataptrarray[5])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gst06a(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));
        _tta = ((double (*))(dataptrarray[2]));
        _ttb = ((double (*))(dataptrarray[3]));

        _c_retval = eraGst06a(*_uta, *_utb, *_tta, *_ttb);
        *((double *)(dataptrarray[4])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_gst94(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_uta);
    double (*_utb);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _uta = ((double (*))(dataptrarray[0]));
        _utb = ((double (*))(dataptrarray[1]));

        _c_retval = eraGst94(*_uta, *_utb);
        *((double *)(dataptrarray[2])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pvstar(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_pv)[2][3];
    double (*_ra);
    double (*_dec);
    double (*_pmr);
    double (*_pmd);
    double (*_px);
    double (*_rv);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _pv = ((double (*)[2][3])(dataptrarray[0]));
        _ra = ((double (*))(dataptrarray[1]));
        _dec = ((double (*))(dataptrarray[2]));
        _pmr = ((double (*))(dataptrarray[3]));
        _pmd = ((double (*))(dataptrarray[4]));
        _px = ((double (*))(dataptrarray[5]));
        _rv = ((double (*))(dataptrarray[6]));

        _c_retval = eraPvstar(*_pv, _ra, _dec, _pmr, _pmd, _px, _rv);
        *((int *)(dataptrarray[7])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_starpv(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ra);
    double (*_dec);
    double (*_pmr);
    double (*_pmd);
    double (*_px);
    double (*_rv);
    double (*_pv)[2][3];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ra = ((double (*))(dataptrarray[0]));
        _dec = ((double (*))(dataptrarray[1]));
        _pmr = ((double (*))(dataptrarray[2]));
        _pmd = ((double (*))(dataptrarray[3]));
        _px = ((double (*))(dataptrarray[4]));
        _rv = ((double (*))(dataptrarray[5]));
        _pv = ((double (*)[2][3])(dataptrarray[6]));

        _c_retval = eraStarpv(*_ra, *_dec, *_pmr, *_pmd, *_px, *_rv, *_pv);
        *((int *)(dataptrarray[7])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_fk52h(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    double (*_px5);
    double (*_rv5);
    double (*_rh);
    double (*_dh);
    double (*_drh);
    double (*_ddh);
    double (*_pxh);
    double (*_rvh);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r5 = ((double (*))(dataptrarray[0]));
        _d5 = ((double (*))(dataptrarray[1]));
        _dr5 = ((double (*))(dataptrarray[2]));
        _dd5 = ((double (*))(dataptrarray[3]));
        _px5 = ((double (*))(dataptrarray[4]));
        _rv5 = ((double (*))(dataptrarray[5]));
        _rh = ((double (*))(dataptrarray[6]));
        _dh = ((double (*))(dataptrarray[7]));
        _drh = ((double (*))(dataptrarray[8]));
        _ddh = ((double (*))(dataptrarray[9]));
        _pxh = ((double (*))(dataptrarray[10]));
        _rvh = ((double (*))(dataptrarray[11]));

        eraFk52h(*_r5, *_d5, *_dr5, *_dd5, *_px5, *_rv5, _rh, _dh, _drh, _ddh, _pxh, _rvh);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fk5hip(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r5h)[3][3];
    double (*_s5h)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r5h = ((double (*)[3][3])(dataptrarray[0]));
        _s5h = ((double (*)[3])(dataptrarray[1]));

        eraFk5hip(*_r5h, *_s5h);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_fk5hz(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r5);
    double (*_d5);
    double (*_date1);
    double (*_date2);
    double (*_rh);
    double (*_dh);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r5 = ((double (*))(dataptrarray[0]));
        _d5 = ((double (*))(dataptrarray[1]));
        _date1 = ((double (*))(dataptrarray[2]));
        _date2 = ((double (*))(dataptrarray[3]));
        _rh = ((double (*))(dataptrarray[4]));
        _dh = ((double (*))(dataptrarray[5]));

        eraFk5hz(*_r5, *_d5, *_date1, *_date2, _rh, _dh);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_h2fk5(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rh);
    double (*_dh);
    double (*_drh);
    double (*_ddh);
    double (*_pxh);
    double (*_rvh);
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    double (*_px5);
    double (*_rv5);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rh = ((double (*))(dataptrarray[0]));
        _dh = ((double (*))(dataptrarray[1]));
        _drh = ((double (*))(dataptrarray[2]));
        _ddh = ((double (*))(dataptrarray[3]));
        _pxh = ((double (*))(dataptrarray[4]));
        _rvh = ((double (*))(dataptrarray[5]));
        _r5 = ((double (*))(dataptrarray[6]));
        _d5 = ((double (*))(dataptrarray[7]));
        _dr5 = ((double (*))(dataptrarray[8]));
        _dd5 = ((double (*))(dataptrarray[9]));
        _px5 = ((double (*))(dataptrarray[10]));
        _rv5 = ((double (*))(dataptrarray[11]));

        eraH2fk5(*_rh, *_dh, *_drh, *_ddh, *_pxh, *_rvh, _r5, _d5, _dr5, _dd5, _px5, _rv5);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_hfk5z(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_rh);
    double (*_dh);
    double (*_date1);
    double (*_date2);
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _rh = ((double (*))(dataptrarray[0]));
        _dh = ((double (*))(dataptrarray[1]));
        _date1 = ((double (*))(dataptrarray[2]));
        _date2 = ((double (*))(dataptrarray[3]));
        _r5 = ((double (*))(dataptrarray[4]));
        _d5 = ((double (*))(dataptrarray[5]));
        _dr5 = ((double (*))(dataptrarray[6]));
        _dd5 = ((double (*))(dataptrarray[7]));

        eraHfk5z(*_rh, *_dh, *_date1, *_date2, _r5, _d5, _dr5, _dd5);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_starpm(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ra1);
    double (*_dec1);
    double (*_pmr1);
    double (*_pmd1);
    double (*_px1);
    double (*_rv1);
    double (*_ep1a);
    double (*_ep1b);
    double (*_ep2a);
    double (*_ep2b);
    double (*_ra2);
    double (*_dec2);
    double (*_pmr2);
    double (*_pmd2);
    double (*_px2);
    double (*_rv2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ra1 = ((double (*))(dataptrarray[0]));
        _dec1 = ((double (*))(dataptrarray[1]));
        _pmr1 = ((double (*))(dataptrarray[2]));
        _pmd1 = ((double (*))(dataptrarray[3]));
        _px1 = ((double (*))(dataptrarray[4]));
        _rv1 = ((double (*))(dataptrarray[5]));
        _ep1a = ((double (*))(dataptrarray[6]));
        _ep1b = ((double (*))(dataptrarray[7]));
        _ep2a = ((double (*))(dataptrarray[8]));
        _ep2b = ((double (*))(dataptrarray[9]));
        _ra2 = ((double (*))(dataptrarray[10]));
        _dec2 = ((double (*))(dataptrarray[11]));
        _pmr2 = ((double (*))(dataptrarray[12]));
        _pmd2 = ((double (*))(dataptrarray[13]));
        _px2 = ((double (*))(dataptrarray[14]));
        _rv2 = ((double (*))(dataptrarray[15]));

        _c_retval = eraStarpm(*_ra1, *_dec1, *_pmr1, *_pmd1, *_px1, *_rv1, *_ep1a, *_ep1b, *_ep2a, *_ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2);
        *((int *)(dataptrarray[16])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_eceq06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dl = ((double (*))(dataptrarray[2]));
        _db = ((double (*))(dataptrarray[3]));
        _dr = ((double (*))(dataptrarray[4]));
        _dd = ((double (*))(dataptrarray[5]));

        eraEceq06(*_date1, *_date2, *_dl, *_db, _dr, _dd);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ecm06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_rm)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _rm = ((double (*)[3][3])(dataptrarray[2]));

        eraEcm06(*_date1, *_date2, *_rm);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eqec06(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _dr = ((double (*))(dataptrarray[2]));
        _dd = ((double (*))(dataptrarray[3]));
        _dl = ((double (*))(dataptrarray[4]));
        _db = ((double (*))(dataptrarray[5]));

        eraEqec06(*_date1, *_date2, *_dr, *_dd, _dl, _db);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_lteceq(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _dl = ((double (*))(dataptrarray[1]));
        _db = ((double (*))(dataptrarray[2]));
        _dr = ((double (*))(dataptrarray[3]));
        _dd = ((double (*))(dataptrarray[4]));

        eraLteceq(*_epj, *_dl, *_db, _dr, _dd);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_ltecm(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_rm)[3][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _rm = ((double (*)[3][3])(dataptrarray[1]));

        eraLtecm(*_epj, *_rm);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_lteqec(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_epj);
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _epj = ((double (*))(dataptrarray[0]));
        _dr = ((double (*))(dataptrarray[1]));
        _dd = ((double (*))(dataptrarray[2]));
        _dl = ((double (*))(dataptrarray[3]));
        _db = ((double (*))(dataptrarray[4]));

        eraLteqec(*_epj, *_dr, *_dd, _dl, _db);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_g2icrs(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dl = ((double (*))(dataptrarray[0]));
        _db = ((double (*))(dataptrarray[1]));
        _dr = ((double (*))(dataptrarray[2]));
        _dd = ((double (*))(dataptrarray[3]));

        eraG2icrs(*_dl, *_db, _dr, _dd);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_icrs2g(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _dr = ((double (*))(dataptrarray[0]));
        _dd = ((double (*))(dataptrarray[1]));
        _dl = ((double (*))(dataptrarray[2]));
        _db = ((double (*))(dataptrarray[3]));

        eraIcrs2g(*_dr, *_dd, _dl, _db);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_eform(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_n);
    double (*_a);
    double (*_f);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _n = ((int (*))(dataptrarray[0]));
        _a = ((double (*))(dataptrarray[1]));
        _f = ((double (*))(dataptrarray[2]));

        _c_retval = eraEform(*_n, _a, _f);
        *((int *)(dataptrarray[3])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_gc2gd(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_n);
    double (*_xyz)[3];
    double (*_elong);
    double (*_phi);
    double (*_height);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _n = ((int (*))(dataptrarray[0]));
        _xyz = ((double (*)[3])(dataptrarray[1]));
        _elong = ((double (*))(dataptrarray[2]));
        _phi = ((double (*))(dataptrarray[3]));
        _height = ((double (*))(dataptrarray[4]));

        _c_retval = eraGc2gd(*_n, *_xyz, _elong, _phi, _height);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_gc2gde(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_a);
    double (*_f);
    double (*_xyz)[3];
    double (*_elong);
    double (*_phi);
    double (*_height);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _a = ((double (*))(dataptrarray[0]));
        _f = ((double (*))(dataptrarray[1]));
        _xyz = ((double (*)[3])(dataptrarray[2]));
        _elong = ((double (*))(dataptrarray[3]));
        _phi = ((double (*))(dataptrarray[4]));
        _height = ((double (*))(dataptrarray[5]));

        _c_retval = eraGc2gde(*_a, *_f, *_xyz, _elong, _phi, _height);
        *((int *)(dataptrarray[6])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_gd2gc(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_n);
    double (*_elong);
    double (*_phi);
    double (*_height);
    double (*_xyz)[3];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _n = ((int (*))(dataptrarray[0]));
        _elong = ((double (*))(dataptrarray[1]));
        _phi = ((double (*))(dataptrarray[2]));
        _height = ((double (*))(dataptrarray[3]));
        _xyz = ((double (*)[3])(dataptrarray[4]));

        _c_retval = eraGd2gc(*_n, *_elong, *_phi, *_height, *_xyz);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_gd2gce(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_a);
    double (*_f);
    double (*_elong);
    double (*_phi);
    double (*_height);
    double (*_xyz)[3];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _a = ((double (*))(dataptrarray[0]));
        _f = ((double (*))(dataptrarray[1]));
        _elong = ((double (*))(dataptrarray[2]));
        _phi = ((double (*))(dataptrarray[3]));
        _height = ((double (*))(dataptrarray[4]));
        _xyz = ((double (*)[3])(dataptrarray[5]));

        _c_retval = eraGd2gce(*_a, *_f, *_elong, *_phi, *_height, *_xyz);
        *((int *)(dataptrarray[6])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_d2dtf(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char (*_scale);
    int (*_ndp);
    double (*_d1);
    double (*_d2);
    int (*_iy);
    int (*_im);
    int (*_id);
    int (*_ihmsf)[4];
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _scale = ((const char (*))(dataptrarray[0]));
        _ndp = ((int (*))(dataptrarray[1]));
        _d1 = ((double (*))(dataptrarray[2]));
        _d2 = ((double (*))(dataptrarray[3]));
        _iy = ((int (*))(dataptrarray[4]));
        _im = ((int (*))(dataptrarray[5]));
        _id = ((int (*))(dataptrarray[6]));
        _ihmsf = ((int (*)[4])(dataptrarray[7]));

        _c_retval = eraD2dtf(_scale, *_ndp, *_d1, *_d2, _iy, _im, _id, *_ihmsf);
        *((int *)(dataptrarray[8])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_dat(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_fd);
    double (*_deltat);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _iy = ((int (*))(dataptrarray[0]));
        _im = ((int (*))(dataptrarray[1]));
        _id = ((int (*))(dataptrarray[2]));
        _fd = ((double (*))(dataptrarray[3]));
        _deltat = ((double (*))(dataptrarray[4]));

        _c_retval = eraDat(*_iy, *_im, *_id, *_fd, _deltat);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_dtdb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_date1);
    double (*_date2);
    double (*_ut);
    double (*_elong);
    double (*_u);
    double (*_v);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _date1 = ((double (*))(dataptrarray[0]));
        _date2 = ((double (*))(dataptrarray[1]));
        _ut = ((double (*))(dataptrarray[2]));
        _elong = ((double (*))(dataptrarray[3]));
        _u = ((double (*))(dataptrarray[4]));
        _v = ((double (*))(dataptrarray[5]));

        _c_retval = eraDtdb(*_date1, *_date2, *_ut, *_elong, *_u, *_v);
        *((double *)(dataptrarray[6])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_dtf2d(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char (*_scale);
    int (*_iy);
    int (*_im);
    int (*_id);
    int (*_ihr);
    int (*_imn);
    double (*_sec);
    double (*_d1);
    double (*_d2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _scale = ((const char (*))(dataptrarray[0]));
        _iy = ((int (*))(dataptrarray[1]));
        _im = ((int (*))(dataptrarray[2]));
        _id = ((int (*))(dataptrarray[3]));
        _ihr = ((int (*))(dataptrarray[4]));
        _imn = ((int (*))(dataptrarray[5]));
        _sec = ((double (*))(dataptrarray[6]));
        _d1 = ((double (*))(dataptrarray[7]));
        _d2 = ((double (*))(dataptrarray[8]));

        _c_retval = eraDtf2d(_scale, *_iy, *_im, *_id, *_ihr, *_imn, *_sec, _d1, _d2);
        *((int *)(dataptrarray[9])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_taitt(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tai1);
    double (*_tai2);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tai1 = ((double (*))(dataptrarray[0]));
        _tai2 = ((double (*))(dataptrarray[1]));
        _tt1 = ((double (*))(dataptrarray[2]));
        _tt2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTaitt(*_tai1, *_tai2, _tt1, _tt2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_taiut1(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tai1);
    double (*_tai2);
    double (*_dta);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tai1 = ((double (*))(dataptrarray[0]));
        _tai2 = ((double (*))(dataptrarray[1]));
        _dta = ((double (*))(dataptrarray[2]));
        _ut11 = ((double (*))(dataptrarray[3]));
        _ut12 = ((double (*))(dataptrarray[4]));

        _c_retval = eraTaiut1(*_tai1, *_tai2, *_dta, _ut11, _ut12);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_taiutc(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tai1);
    double (*_tai2);
    double (*_utc1);
    double (*_utc2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tai1 = ((double (*))(dataptrarray[0]));
        _tai2 = ((double (*))(dataptrarray[1]));
        _utc1 = ((double (*))(dataptrarray[2]));
        _utc2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTaiutc(*_tai1, *_tai2, _utc1, _utc2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tcbtdb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tcb1);
    double (*_tcb2);
    double (*_tdb1);
    double (*_tdb2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tcb1 = ((double (*))(dataptrarray[0]));
        _tcb2 = ((double (*))(dataptrarray[1]));
        _tdb1 = ((double (*))(dataptrarray[2]));
        _tdb2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTcbtdb(*_tcb1, *_tcb2, _tdb1, _tdb2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tcgtt(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tcg1);
    double (*_tcg2);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tcg1 = ((double (*))(dataptrarray[0]));
        _tcg2 = ((double (*))(dataptrarray[1]));
        _tt1 = ((double (*))(dataptrarray[2]));
        _tt2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTcgtt(*_tcg1, *_tcg2, _tt1, _tt2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tdbtcb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tdb1);
    double (*_tdb2);
    double (*_tcb1);
    double (*_tcb2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tdb1 = ((double (*))(dataptrarray[0]));
        _tdb2 = ((double (*))(dataptrarray[1]));
        _tcb1 = ((double (*))(dataptrarray[2]));
        _tcb2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTdbtcb(*_tdb1, *_tdb2, _tcb1, _tcb2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tdbtt(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tdb1);
    double (*_tdb2);
    double (*_dtr);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tdb1 = ((double (*))(dataptrarray[0]));
        _tdb2 = ((double (*))(dataptrarray[1]));
        _dtr = ((double (*))(dataptrarray[2]));
        _tt1 = ((double (*))(dataptrarray[3]));
        _tt2 = ((double (*))(dataptrarray[4]));

        _c_retval = eraTdbtt(*_tdb1, *_tdb2, *_dtr, _tt1, _tt2);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tttai(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tt1);
    double (*_tt2);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tt1 = ((double (*))(dataptrarray[0]));
        _tt2 = ((double (*))(dataptrarray[1]));
        _tai1 = ((double (*))(dataptrarray[2]));
        _tai2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTttai(*_tt1, *_tt2, _tai1, _tai2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tttcg(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tt1);
    double (*_tt2);
    double (*_tcg1);
    double (*_tcg2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tt1 = ((double (*))(dataptrarray[0]));
        _tt2 = ((double (*))(dataptrarray[1]));
        _tcg1 = ((double (*))(dataptrarray[2]));
        _tcg2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraTttcg(*_tt1, *_tt2, _tcg1, _tcg2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tttdb(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tt1);
    double (*_tt2);
    double (*_dtr);
    double (*_tdb1);
    double (*_tdb2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tt1 = ((double (*))(dataptrarray[0]));
        _tt2 = ((double (*))(dataptrarray[1]));
        _dtr = ((double (*))(dataptrarray[2]));
        _tdb1 = ((double (*))(dataptrarray[3]));
        _tdb2 = ((double (*))(dataptrarray[4]));

        _c_retval = eraTttdb(*_tt1, *_tt2, *_dtr, _tdb1, _tdb2);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_ttut1(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_tt1);
    double (*_tt2);
    double (*_dt);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _tt1 = ((double (*))(dataptrarray[0]));
        _tt2 = ((double (*))(dataptrarray[1]));
        _dt = ((double (*))(dataptrarray[2]));
        _ut11 = ((double (*))(dataptrarray[3]));
        _ut12 = ((double (*))(dataptrarray[4]));

        _c_retval = eraTtut1(*_tt1, *_tt2, *_dt, _ut11, _ut12);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_ut1tai(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ut11);
    double (*_ut12);
    double (*_dta);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ut11 = ((double (*))(dataptrarray[0]));
        _ut12 = ((double (*))(dataptrarray[1]));
        _dta = ((double (*))(dataptrarray[2]));
        _tai1 = ((double (*))(dataptrarray[3]));
        _tai2 = ((double (*))(dataptrarray[4]));

        _c_retval = eraUt1tai(*_ut11, *_ut12, *_dta, _tai1, _tai2);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_ut1tt(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ut11);
    double (*_ut12);
    double (*_dt);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ut11 = ((double (*))(dataptrarray[0]));
        _ut12 = ((double (*))(dataptrarray[1]));
        _dt = ((double (*))(dataptrarray[2]));
        _tt1 = ((double (*))(dataptrarray[3]));
        _tt2 = ((double (*))(dataptrarray[4]));

        _c_retval = eraUt1tt(*_ut11, *_ut12, *_dt, _tt1, _tt2);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_ut1utc(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_ut11);
    double (*_ut12);
    double (*_dut1);
    double (*_utc1);
    double (*_utc2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ut11 = ((double (*))(dataptrarray[0]));
        _ut12 = ((double (*))(dataptrarray[1]));
        _dut1 = ((double (*))(dataptrarray[2]));
        _utc1 = ((double (*))(dataptrarray[3]));
        _utc2 = ((double (*))(dataptrarray[4]));

        _c_retval = eraUt1utc(*_ut11, *_ut12, *_dut1, _utc1, _utc2);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_utctai(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_utc1);
    double (*_utc2);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _utc1 = ((double (*))(dataptrarray[0]));
        _utc2 = ((double (*))(dataptrarray[1]));
        _tai1 = ((double (*))(dataptrarray[2]));
        _tai2 = ((double (*))(dataptrarray[3]));

        _c_retval = eraUtctai(*_utc1, *_utc2, _tai1, _tai2);
        *((int *)(dataptrarray[4])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_utcut1(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _utc1 = ((double (*))(dataptrarray[0]));
        _utc2 = ((double (*))(dataptrarray[1]));
        _dut1 = ((double (*))(dataptrarray[2]));
        _ut11 = ((double (*))(dataptrarray[3]));
        _ut12 = ((double (*))(dataptrarray[4]));

        _c_retval = eraUtcut1(*_utc1, *_utc2, *_dut1, _ut11, _ut12);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_a2af(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_ndp);
    double (*_angle);
    char (*_sign);
    int (*_idmsf)[4];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ndp = ((int (*))(dataptrarray[0]));
        _angle = ((double (*))(dataptrarray[1]));
        _sign = ((char (*))(dataptrarray[2]));
        _idmsf = ((int (*)[4])(dataptrarray[3]));

        eraA2af(*_ndp, *_angle, _sign, *_idmsf);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_a2tf(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_ndp);
    double (*_angle);
    char (*_sign);
    int (*_ihmsf)[4];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ndp = ((int (*))(dataptrarray[0]));
        _angle = ((double (*))(dataptrarray[1]));
        _sign = ((char (*))(dataptrarray[2]));
        _ihmsf = ((int (*)[4])(dataptrarray[3]));

        eraA2tf(*_ndp, *_angle, _sign, *_ihmsf);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_af2a(PyObject *self, PyObject *args, PyObject *kwds)
{
    char (*_s);
    int (*_ideg);
    int (*_iamin);
    double (*_asec);
    double (*_rad);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _s = ((char (*))(dataptrarray[0]));
        _ideg = ((int (*))(dataptrarray[1]));
        _iamin = ((int (*))(dataptrarray[2]));
        _asec = ((double (*))(dataptrarray[3]));
        _rad = ((double (*))(dataptrarray[4]));

        _c_retval = eraAf2a(*_s, *_ideg, *_iamin, *_asec, _rad);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_anp(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_a);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _a = ((double (*))(dataptrarray[0]));

        _c_retval = eraAnp(*_a);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_anpm(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_a);
    double _c_retval;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _a = ((double (*))(dataptrarray[0]));

        _c_retval = eraAnpm(*_a);
        *((double *)(dataptrarray[1])) = _c_retval;
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_d2tf(PyObject *self, PyObject *args, PyObject *kwds)
{
    int (*_ndp);
    double (*_days);
    char (*_sign);
    int (*_ihmsf)[4];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _ndp = ((int (*))(dataptrarray[0]));
        _days = ((double (*))(dataptrarray[1]));
        _sign = ((char (*))(dataptrarray[2]));
        _ihmsf = ((int (*)[4])(dataptrarray[3]));

        eraD2tf(*_ndp, *_days, _sign, *_ihmsf);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_tf2a(PyObject *self, PyObject *args, PyObject *kwds)
{
    char (*_s);
    int (*_ihour);
    int (*_imin);
    double (*_sec);
    double (*_rad);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _s = ((char (*))(dataptrarray[0]));
        _ihour = ((int (*))(dataptrarray[1]));
        _imin = ((int (*))(dataptrarray[2]));
        _sec = ((double (*))(dataptrarray[3]));
        _rad = ((double (*))(dataptrarray[4]));

        _c_retval = eraTf2a(*_s, *_ihour, *_imin, *_sec, _rad);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_tf2d(PyObject *self, PyObject *args, PyObject *kwds)
{
    char (*_s);
    int (*_ihour);
    int (*_imin);
    double (*_sec);
    double (*_days);
    int _c_retval;
    int stat_ok = 1;
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _s = ((char (*))(dataptrarray[0]));
        _ihour = ((int (*))(dataptrarray[1]));
        _imin = ((int (*))(dataptrarray[2]));
        _sec = ((double (*))(dataptrarray[3]));
        _days = ((double (*))(dataptrarray[4]));

        _c_retval = eraTf2d(*_s, *_ihour, *_imin, *_sec, _days);
        *((int *)(dataptrarray[5])) = _c_retval;
        if (_c_retval) {
            stat_ok = 0;
        }
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    if (stat_ok) {
        Py_RETURN_TRUE;
    } else {
        Py_RETURN_FALSE;
    }
}

static PyObject *Py_rxp(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r)[3][3];
    double (*_p)[3];
    double (*_rp)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r = ((double (*)[3][3])(dataptrarray[0]));
        _p = ((double (*)[3])(dataptrarray[1]));
        _rp = ((double (*)[3])(dataptrarray[2]));

        eraRxp(*_r, *_p, *_rp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_rxpv(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r)[3][3];
    double (*_pv)[2][3];
    double (*_rpv)[2][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r = ((double (*)[3][3])(dataptrarray[0]));
        _pv = ((double (*)[2][3])(dataptrarray[1]));
        _rpv = ((double (*)[2][3])(dataptrarray[2]));

        eraRxpv(*_r, *_pv, *_rpv);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_trxp(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r)[3][3];
    double (*_p)[3];
    double (*_trp)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r = ((double (*)[3][3])(dataptrarray[0]));
        _p = ((double (*)[3])(dataptrarray[1]));
        _trp = ((double (*)[3])(dataptrarray[2]));

        eraTrxp(*_r, *_p, *_trp);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_trxpv(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_r)[3][3];
    double (*_pv)[2][3];
    double (*_trpv)[2][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _r = ((double (*)[3][3])(dataptrarray[0]));
        _pv = ((double (*)[2][3])(dataptrarray[1]));
        _trpv = ((double (*)[2][3])(dataptrarray[2]));

        eraTrxpv(*_r, *_pv, *_trpv);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_c2s(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_p)[3];
    double (*_theta);
    double (*_phi);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _p = ((double (*)[3])(dataptrarray[0]));
        _theta = ((double (*))(dataptrarray[1]));
        _phi = ((double (*))(dataptrarray[2]));

        eraC2s(*_p, _theta, _phi);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_p2s(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_p)[3];
    double (*_theta);
    double (*_phi);
    double (*_r);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _p = ((double (*)[3])(dataptrarray[0]));
        _theta = ((double (*))(dataptrarray[1]));
        _phi = ((double (*))(dataptrarray[2]));
        _r = ((double (*))(dataptrarray[3]));

        eraP2s(*_p, _theta, _phi, _r);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_pv2s(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_pv)[2][3];
    double (*_theta);
    double (*_phi);
    double (*_r);
    double (*_td);
    double (*_pd);
    double (*_rd);
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _pv = ((double (*)[2][3])(dataptrarray[0]));
        _theta = ((double (*))(dataptrarray[1]));
        _phi = ((double (*))(dataptrarray[2]));
        _r = ((double (*))(dataptrarray[3]));
        _td = ((double (*))(dataptrarray[4]));
        _pd = ((double (*))(dataptrarray[5]));
        _rd = ((double (*))(dataptrarray[6]));

        eraPv2s(*_pv, _theta, _phi, _r, _td, _pd, _rd);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s2c(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_theta);
    double (*_phi);
    double (*_c)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _theta = ((double (*))(dataptrarray[0]));
        _phi = ((double (*))(dataptrarray[1]));
        _c = ((double (*)[3])(dataptrarray[2]));

        eraS2c(*_theta, *_phi, *_c);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s2p(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_theta);
    double (*_phi);
    double (*_r);
    double (*_p)[3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _theta = ((double (*))(dataptrarray[0]));
        _phi = ((double (*))(dataptrarray[1]));
        _r = ((double (*))(dataptrarray[2]));
        _p = ((double (*)[3])(dataptrarray[3]));

        eraS2p(*_theta, *_phi, *_r, *_p);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyObject *Py_s2pv(PyObject *self, PyObject *args, PyObject *kwds)
{
    double (*_theta);
    double (*_phi);
    double (*_r);
    double (*_td);
    double (*_pd);
    double (*_rd);
    double (*_pv)[2][3];
    NpyIter *it = ((_NpyIterObject *)args)->iter;
    char **dataptrarray = NpyIter_GetDataPtrArray(it);
    NpyIter_IterNextFunc *iternext = NpyIter_GetIterNext(it, NULL);

    Py_BEGIN_ALLOW_THREADS

    do {
        _theta = ((double (*))(dataptrarray[0]));
        _phi = ((double (*))(dataptrarray[1]));
        _r = ((double (*))(dataptrarray[2]));
        _td = ((double (*))(dataptrarray[3]));
        _pd = ((double (*))(dataptrarray[4]));
        _rd = ((double (*))(dataptrarray[5]));
        _pv = ((double (*)[2][3])(dataptrarray[6]));

        eraS2pv(*_theta, *_phi, *_r, *_td, *_pd, *_rd, *_pv);
    } while (iternext(it));

    Py_END_ALLOW_THREADS
    Py_RETURN_NONE;
}

static PyMethodDef module_functions[] = {
    { "_" "cal2jd", (PyCFunction)Py_cal2jd, METH_O, NULL },
    { "_" "epb", (PyCFunction)Py_epb, METH_O, NULL },
    { "_" "epb2jd", (PyCFunction)Py_epb2jd, METH_O, NULL },
    { "_" "epj", (PyCFunction)Py_epj, METH_O, NULL },
    { "_" "epj2jd", (PyCFunction)Py_epj2jd, METH_O, NULL },
    { "_" "jd2cal", (PyCFunction)Py_jd2cal, METH_O, NULL },
    { "_" "jdcalf", (PyCFunction)Py_jdcalf, METH_O, NULL },
    { "_" "ab", (PyCFunction)Py_ab, METH_O, NULL },
    { "_" "apcg", (PyCFunction)Py_apcg, METH_O, NULL },
    { "_" "apcg13", (PyCFunction)Py_apcg13, METH_O, NULL },
    { "_" "apci", (PyCFunction)Py_apci, METH_O, NULL },
    { "_" "apci13", (PyCFunction)Py_apci13, METH_O, NULL },
    { "_" "apco", (PyCFunction)Py_apco, METH_O, NULL },
    { "_" "apco13", (PyCFunction)Py_apco13, METH_O, NULL },
    { "_" "apcs", (PyCFunction)Py_apcs, METH_O, NULL },
    { "_" "apcs13", (PyCFunction)Py_apcs13, METH_O, NULL },
    { "_" "aper", (PyCFunction)Py_aper, METH_O, NULL },
    { "_" "aper13", (PyCFunction)Py_aper13, METH_O, NULL },
    { "_" "apio", (PyCFunction)Py_apio, METH_O, NULL },
    { "_" "apio13", (PyCFunction)Py_apio13, METH_O, NULL },
    { "_" "atci13", (PyCFunction)Py_atci13, METH_O, NULL },
    { "_" "atciq", (PyCFunction)Py_atciq, METH_O, NULL },
    { "_" "atciqn", (PyCFunction)Py_atciqn, METH_O, NULL },
    { "_" "atciqz", (PyCFunction)Py_atciqz, METH_O, NULL },
    { "_" "atco13", (PyCFunction)Py_atco13, METH_O, NULL },
    { "_" "atic13", (PyCFunction)Py_atic13, METH_O, NULL },
    { "_" "aticq", (PyCFunction)Py_aticq, METH_O, NULL },
    { "_" "aticqn", (PyCFunction)Py_aticqn, METH_O, NULL },
    { "_" "atio13", (PyCFunction)Py_atio13, METH_O, NULL },
    { "_" "atioq", (PyCFunction)Py_atioq, METH_O, NULL },
    { "_" "atoc13", (PyCFunction)Py_atoc13, METH_O, NULL },
    { "_" "atoi13", (PyCFunction)Py_atoi13, METH_O, NULL },
    { "_" "atoiq", (PyCFunction)Py_atoiq, METH_O, NULL },
    { "_" "ld", (PyCFunction)Py_ld, METH_O, NULL },
    { "_" "ldn", (PyCFunction)Py_ldn, METH_O, NULL },
    { "_" "ldsun", (PyCFunction)Py_ldsun, METH_O, NULL },
    { "_" "pmpx", (PyCFunction)Py_pmpx, METH_O, NULL },
    { "_" "pmsafe", (PyCFunction)Py_pmsafe, METH_O, NULL },
    { "_" "pvtob", (PyCFunction)Py_pvtob, METH_O, NULL },
    { "_" "refco", (PyCFunction)Py_refco, METH_O, NULL },
    { "_" "epv00", (PyCFunction)Py_epv00, METH_O, NULL },
    { "_" "plan94", (PyCFunction)Py_plan94, METH_O, NULL },
    { "_" "fad03", (PyCFunction)Py_fad03, METH_O, NULL },
    { "_" "fae03", (PyCFunction)Py_fae03, METH_O, NULL },
    { "_" "faf03", (PyCFunction)Py_faf03, METH_O, NULL },
    { "_" "faju03", (PyCFunction)Py_faju03, METH_O, NULL },
    { "_" "fal03", (PyCFunction)Py_fal03, METH_O, NULL },
    { "_" "falp03", (PyCFunction)Py_falp03, METH_O, NULL },
    { "_" "fama03", (PyCFunction)Py_fama03, METH_O, NULL },
    { "_" "fame03", (PyCFunction)Py_fame03, METH_O, NULL },
    { "_" "fane03", (PyCFunction)Py_fane03, METH_O, NULL },
    { "_" "faom03", (PyCFunction)Py_faom03, METH_O, NULL },
    { "_" "fapa03", (PyCFunction)Py_fapa03, METH_O, NULL },
    { "_" "fasa03", (PyCFunction)Py_fasa03, METH_O, NULL },
    { "_" "faur03", (PyCFunction)Py_faur03, METH_O, NULL },
    { "_" "fave03", (PyCFunction)Py_fave03, METH_O, NULL },
    { "_" "bi00", (PyCFunction)Py_bi00, METH_O, NULL },
    { "_" "bp00", (PyCFunction)Py_bp00, METH_O, NULL },
    { "_" "bp06", (PyCFunction)Py_bp06, METH_O, NULL },
    { "_" "bpn2xy", (PyCFunction)Py_bpn2xy, METH_O, NULL },
    { "_" "c2i00a", (PyCFunction)Py_c2i00a, METH_O, NULL },
    { "_" "c2i00b", (PyCFunction)Py_c2i00b, METH_O, NULL },
    { "_" "c2i06a", (PyCFunction)Py_c2i06a, METH_O, NULL },
    { "_" "c2ibpn", (PyCFunction)Py_c2ibpn, METH_O, NULL },
    { "_" "c2ixy", (PyCFunction)Py_c2ixy, METH_O, NULL },
    { "_" "c2ixys", (PyCFunction)Py_c2ixys, METH_O, NULL },
    { "_" "c2t00a", (PyCFunction)Py_c2t00a, METH_O, NULL },
    { "_" "c2t00b", (PyCFunction)Py_c2t00b, METH_O, NULL },
    { "_" "c2t06a", (PyCFunction)Py_c2t06a, METH_O, NULL },
    { "_" "c2tcio", (PyCFunction)Py_c2tcio, METH_O, NULL },
    { "_" "c2teqx", (PyCFunction)Py_c2teqx, METH_O, NULL },
    { "_" "c2tpe", (PyCFunction)Py_c2tpe, METH_O, NULL },
    { "_" "c2txy", (PyCFunction)Py_c2txy, METH_O, NULL },
    { "_" "eo06a", (PyCFunction)Py_eo06a, METH_O, NULL },
    { "_" "eors", (PyCFunction)Py_eors, METH_O, NULL },
    { "_" "fw2m", (PyCFunction)Py_fw2m, METH_O, NULL },
    { "_" "fw2xy", (PyCFunction)Py_fw2xy, METH_O, NULL },
    { "_" "ltp", (PyCFunction)Py_ltp, METH_O, NULL },
    { "_" "ltpb", (PyCFunction)Py_ltpb, METH_O, NULL },
    { "_" "ltpecl", (PyCFunction)Py_ltpecl, METH_O, NULL },
    { "_" "ltpequ", (PyCFunction)Py_ltpequ, METH_O, NULL },
    { "_" "num00a", (PyCFunction)Py_num00a, METH_O, NULL },
    { "_" "num00b", (PyCFunction)Py_num00b, METH_O, NULL },
    { "_" "num06a", (PyCFunction)Py_num06a, METH_O, NULL },
    { "_" "numat", (PyCFunction)Py_numat, METH_O, NULL },
    { "_" "nut00a", (PyCFunction)Py_nut00a, METH_O, NULL },
    { "_" "nut00b", (PyCFunction)Py_nut00b, METH_O, NULL },
    { "_" "nut06a", (PyCFunction)Py_nut06a, METH_O, NULL },
    { "_" "nut80", (PyCFunction)Py_nut80, METH_O, NULL },
    { "_" "nutm80", (PyCFunction)Py_nutm80, METH_O, NULL },
    { "_" "obl06", (PyCFunction)Py_obl06, METH_O, NULL },
    { "_" "obl80", (PyCFunction)Py_obl80, METH_O, NULL },
    { "_" "p06e", (PyCFunction)Py_p06e, METH_O, NULL },
    { "_" "pb06", (PyCFunction)Py_pb06, METH_O, NULL },
    { "_" "pfw06", (PyCFunction)Py_pfw06, METH_O, NULL },
    { "_" "pmat00", (PyCFunction)Py_pmat00, METH_O, NULL },
    { "_" "pmat06", (PyCFunction)Py_pmat06, METH_O, NULL },
    { "_" "pmat76", (PyCFunction)Py_pmat76, METH_O, NULL },
    { "_" "pn00", (PyCFunction)Py_pn00, METH_O, NULL },
    { "_" "pn00a", (PyCFunction)Py_pn00a, METH_O, NULL },
    { "_" "pn00b", (PyCFunction)Py_pn00b, METH_O, NULL },
    { "_" "pn06", (PyCFunction)Py_pn06, METH_O, NULL },
    { "_" "pn06a", (PyCFunction)Py_pn06a, METH_O, NULL },
    { "_" "pnm00a", (PyCFunction)Py_pnm00a, METH_O, NULL },
    { "_" "pnm00b", (PyCFunction)Py_pnm00b, METH_O, NULL },
    { "_" "pnm06a", (PyCFunction)Py_pnm06a, METH_O, NULL },
    { "_" "pnm80", (PyCFunction)Py_pnm80, METH_O, NULL },
    { "_" "pom00", (PyCFunction)Py_pom00, METH_O, NULL },
    { "_" "pr00", (PyCFunction)Py_pr00, METH_O, NULL },
    { "_" "prec76", (PyCFunction)Py_prec76, METH_O, NULL },
    { "_" "s00", (PyCFunction)Py_s00, METH_O, NULL },
    { "_" "s00a", (PyCFunction)Py_s00a, METH_O, NULL },
    { "_" "s00b", (PyCFunction)Py_s00b, METH_O, NULL },
    { "_" "s06", (PyCFunction)Py_s06, METH_O, NULL },
    { "_" "s06a", (PyCFunction)Py_s06a, METH_O, NULL },
    { "_" "sp00", (PyCFunction)Py_sp00, METH_O, NULL },
    { "_" "xy06", (PyCFunction)Py_xy06, METH_O, NULL },
    { "_" "xys00a", (PyCFunction)Py_xys00a, METH_O, NULL },
    { "_" "xys00b", (PyCFunction)Py_xys00b, METH_O, NULL },
    { "_" "xys06a", (PyCFunction)Py_xys06a, METH_O, NULL },
    { "_" "ee00", (PyCFunction)Py_ee00, METH_O, NULL },
    { "_" "ee00a", (PyCFunction)Py_ee00a, METH_O, NULL },
    { "_" "ee00b", (PyCFunction)Py_ee00b, METH_O, NULL },
    { "_" "ee06a", (PyCFunction)Py_ee06a, METH_O, NULL },
    { "_" "eect00", (PyCFunction)Py_eect00, METH_O, NULL },
    { "_" "eqeq94", (PyCFunction)Py_eqeq94, METH_O, NULL },
    { "_" "era00", (PyCFunction)Py_era00, METH_O, NULL },
    { "_" "gmst00", (PyCFunction)Py_gmst00, METH_O, NULL },
    { "_" "gmst06", (PyCFunction)Py_gmst06, METH_O, NULL },
    { "_" "gmst82", (PyCFunction)Py_gmst82, METH_O, NULL },
    { "_" "gst00a", (PyCFunction)Py_gst00a, METH_O, NULL },
    { "_" "gst00b", (PyCFunction)Py_gst00b, METH_O, NULL },
    { "_" "gst06", (PyCFunction)Py_gst06, METH_O, NULL },
    { "_" "gst06a", (PyCFunction)Py_gst06a, METH_O, NULL },
    { "_" "gst94", (PyCFunction)Py_gst94, METH_O, NULL },
    { "_" "pvstar", (PyCFunction)Py_pvstar, METH_O, NULL },
    { "_" "starpv", (PyCFunction)Py_starpv, METH_O, NULL },
    { "_" "fk52h", (PyCFunction)Py_fk52h, METH_O, NULL },
    { "_" "fk5hip", (PyCFunction)Py_fk5hip, METH_O, NULL },
    { "_" "fk5hz", (PyCFunction)Py_fk5hz, METH_O, NULL },
    { "_" "h2fk5", (PyCFunction)Py_h2fk5, METH_O, NULL },
    { "_" "hfk5z", (PyCFunction)Py_hfk5z, METH_O, NULL },
    { "_" "starpm", (PyCFunction)Py_starpm, METH_O, NULL },
    { "_" "eceq06", (PyCFunction)Py_eceq06, METH_O, NULL },
    { "_" "ecm06", (PyCFunction)Py_ecm06, METH_O, NULL },
    { "_" "eqec06", (PyCFunction)Py_eqec06, METH_O, NULL },
    { "_" "lteceq", (PyCFunction)Py_lteceq, METH_O, NULL },
    { "_" "ltecm", (PyCFunction)Py_ltecm, METH_O, NULL },
    { "_" "lteqec", (PyCFunction)Py_lteqec, METH_O, NULL },
    { "_" "g2icrs", (PyCFunction)Py_g2icrs, METH_O, NULL },
    { "_" "icrs2g", (PyCFunction)Py_icrs2g, METH_O, NULL },
    { "_" "eform", (PyCFunction)Py_eform, METH_O, NULL },
    { "_" "gc2gd", (PyCFunction)Py_gc2gd, METH_O, NULL },
    { "_" "gc2gde", (PyCFunction)Py_gc2gde, METH_O, NULL },
    { "_" "gd2gc", (PyCFunction)Py_gd2gc, METH_O, NULL },
    { "_" "gd2gce", (PyCFunction)Py_gd2gce, METH_O, NULL },
    { "_" "d2dtf", (PyCFunction)Py_d2dtf, METH_O, NULL },
    { "_" "dat", (PyCFunction)Py_dat, METH_O, NULL },
    { "_" "dtdb", (PyCFunction)Py_dtdb, METH_O, NULL },
    { "_" "dtf2d", (PyCFunction)Py_dtf2d, METH_O, NULL },
    { "_" "taitt", (PyCFunction)Py_taitt, METH_O, NULL },
    { "_" "taiut1", (PyCFunction)Py_taiut1, METH_O, NULL },
    { "_" "taiutc", (PyCFunction)Py_taiutc, METH_O, NULL },
    { "_" "tcbtdb", (PyCFunction)Py_tcbtdb, METH_O, NULL },
    { "_" "tcgtt", (PyCFunction)Py_tcgtt, METH_O, NULL },
    { "_" "tdbtcb", (PyCFunction)Py_tdbtcb, METH_O, NULL },
    { "_" "tdbtt", (PyCFunction)Py_tdbtt, METH_O, NULL },
    { "_" "tttai", (PyCFunction)Py_tttai, METH_O, NULL },
    { "_" "tttcg", (PyCFunction)Py_tttcg, METH_O, NULL },
    { "_" "tttdb", (PyCFunction)Py_tttdb, METH_O, NULL },
    { "_" "ttut1", (PyCFunction)Py_ttut1, METH_O, NULL },
    { "_" "ut1tai", (PyCFunction)Py_ut1tai, METH_O, NULL },
    { "_" "ut1tt", (PyCFunction)Py_ut1tt, METH_O, NULL },
    { "_" "ut1utc", (PyCFunction)Py_ut1utc, METH_O, NULL },
    { "_" "utctai", (PyCFunction)Py_utctai, METH_O, NULL },
    { "_" "utcut1", (PyCFunction)Py_utcut1, METH_O, NULL },
    { "_" "a2af", (PyCFunction)Py_a2af, METH_O, NULL },
    { "_" "a2tf", (PyCFunction)Py_a2tf, METH_O, NULL },
    { "_" "af2a", (PyCFunction)Py_af2a, METH_O, NULL },
    { "_" "anp", (PyCFunction)Py_anp, METH_O, NULL },
    { "_" "anpm", (PyCFunction)Py_anpm, METH_O, NULL },
    { "_" "d2tf", (PyCFunction)Py_d2tf, METH_O, NULL },
    { "_" "tf2a", (PyCFunction)Py_tf2a, METH_O, NULL },
    { "_" "tf2d", (PyCFunction)Py_tf2d, METH_O, NULL },
    { "_" "rxp", (PyCFunction)Py_rxp, METH_O, NULL },
    { "_" "rxpv", (PyCFunction)Py_rxpv, METH_O, NULL },
    { "_" "trxp", (PyCFunction)Py_trxp, METH_O, NULL },
    { "_" "trxpv", (PyCFunction)Py_trxpv, METH_O, NULL },
    { "_" "c2s", (PyCFunction)Py_c2s, METH_O, NULL },
    { "_" "p2s", (PyCFunction)Py_p2s, METH_O, NULL },
    { "_" "pv2s", (PyCFunction)Py_pv2s, METH_O, NULL },
    { "_" "s2c", (PyCFunction)Py_s2c, METH_O, NULL },
    { "_" "s2p", (PyCFunction)Py_s2p, METH_O, NULL },
    { "_" "s2pv", (PyCFunction)Py_s2pv, METH_O, NULL },
    { NULL }
};

struct module_state
{
    int _dummy;
};


static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "_core",
    MODULE_DOCSTRING,
    sizeof(struct module_state),
    module_functions,
    NULL,
    NULL,
    NULL,
    NULL
};

PyMODINIT_FUNC PyInit__core(void)

{
    PyObject *m;

    m = PyModule_Create(&moduledef);

    if (m == NULL) {
        return NULL;
    }

    import_array();

    return m;
}