#ifndef HAVE_ADNS_DOMAIN_NAME_H
#define HAVE_ADNS_DOMAIN_NAME_H

using namespace System;
using namespace System::Collections::Generic;

namespace ADNS
{

	String^ parse_escape(String^ s);

	public ref class DOMAIN_NAME {
	private:	
		array<Byte>^ name;
	public:
		//Functions 
		DOMAIN_NAME();
		DOMAIN_NAME(array<Byte>^ domain);
		DOMAIN_NAME(String^ domain);
		array<Byte>^ GetName();
		int LabelCount();
		DOMAIN_NAME^ GetLabel(int n);
		DOMAIN_NAME^ Clone();
		DOMAIN_NAME^ CloneFrom(unsigned short int n);
		Void Concatenate(DOMAIN_NAME^ catname);
		DOMAIN_NAME^ Reverse();
		DOMAIN_NAME^ LeftChop();
		bool IsEqual(DOMAIN_NAME^ a2);
		bool IsSubDomain(DOMAIN_NAME^ sub);
		int Compare(DOMAIN_NAME^ dname);
		bool MatchWildcard(DOMAIN_NAME^ wildcard);
		int	InInterval(DOMAIN_NAME^ start, DOMAIN_NAME^ end);
		Void MakeCanonical();
		String^ Print();
		UInt32 Size();

	private:
		List<array<Byte>^>^ Split();

	};
}



#endif
