/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandLength: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 1, NULL);
	
	return new LWValue(args[0]->count());
}	

const gchar *getName (void) 
{
	return "length";
}	

gchar *getHint ()
{
	return _("Length of the string or size of an array");
}

guint getPriority ()
{
	return 15;
}

LWLink getLinkType ()
{
	return LW_LINK_RIGHT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandLength()
{
	return new LWCommandLength();
}
