; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -reassociate -dce < %s | FileCheck %s

; The two va_arg instructions depend on the memory/context, are therfore not
; identical and the sub should not be optimized to 0 by reassociate.
;
; ...
; ...
define i32 @func(i32 %dummy, ...) {
;
; CHECK-LABEL: @func(
; CHECK-NEXT:    [[VARARGS:%.*]] = alloca i8*, align 8
; CHECK-NEXT:    [[VARARGS1:%.*]] = bitcast i8** [[VARARGS]] to i8*
; CHECK-NEXT:    call void @llvm.va_start(i8* [[VARARGS1]])
; CHECK-NEXT:    [[V0:%.*]] = va_arg i8** [[VARARGS]], i32
; CHECK-NEXT:    [[V1:%.*]] = va_arg i8** [[VARARGS]], i32
; CHECK-NEXT:    [[V0_NEG:%.*]] = sub i32 0, [[V0]]
; CHECK-NEXT:    [[SUB:%.*]] = add i32 [[V0_NEG]], 1
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[SUB]], [[V1]]
; CHECK-NEXT:    call void @llvm.va_end(i8* [[VARARGS1]])
; CHECK-NEXT:    ret i32 [[ADD]]
;
  %varargs = alloca i8*, align 8
  %varargs1 = bitcast i8** %varargs to i8*
  call void @llvm.va_start(i8* %varargs1)
  %v0 = va_arg i8** %varargs, i32
  %v1 = va_arg i8** %varargs, i32
  %sub = sub nsw i32 %v1, %v0
  %add = add nsw i32 %sub, 1
  call void @llvm.va_end(i8* %varargs1)
  ret i32 %add
}

declare void @llvm.va_start(i8*)
declare void @llvm.va_end(i8*)
