// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py
// RUN: mlir-opt %s -sparsification | FileCheck %s

#DenseMatrix = #sparse_tensor.encoding<{
  dimLevelType = ["dense", "dense"]
}>

#SparseMatrix = #sparse_tensor.encoding<{
  dimLevelType = ["compressed", "compressed"]
}>

#trait = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) * i * j"
}

// CHECK-LABEL:   func @dense_index(
// CHECK-SAME:      %[[VAL_0:.*]]: tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_1:.*]] = arith.constant 0 : index
// CHECK-DAG:       %[[VAL_2:.*]] = arith.constant 1 : index
// CHECK-DAG:       %[[VAL_3:.*]] = tensor.dim %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_4:.*]] = tensor.dim %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_5:.*]] = bufferization.alloc_tensor(%[[VAL_3]], %[[VAL_4]]) : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_6:.*]] = sparse_tensor.values %[[VAL_0]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_7:.*]] = tensor.dim %[[VAL_5]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_8:.*]] = tensor.dim %[[VAL_5]], %[[VAL_2]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_9:.*]] = sparse_tensor.values %[[VAL_5]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:           scf.for %[[VAL_10:.*]] = %[[VAL_1]] to %[[VAL_7]] step %[[VAL_2]] {
// CHECK:             scf.for %[[VAL_11:.*]] = %[[VAL_1]] to %[[VAL_8]] step %[[VAL_2]] {
// CHECK:               %[[VAL_12:.*]] = arith.muli %[[VAL_8]], %[[VAL_10]] : index
// CHECK:               %[[VAL_13:.*]] = arith.addi %[[VAL_12]], %[[VAL_11]] : index
// CHECK:               %[[VAL_14:.*]] = arith.muli %[[VAL_8]], %[[VAL_10]] : index
// CHECK:               %[[VAL_15:.*]] = arith.addi %[[VAL_14]], %[[VAL_11]] : index
// CHECK:               %[[VAL_16:.*]] = arith.index_cast %[[VAL_11]] : index to i64
// CHECK:               %[[VAL_17:.*]] = arith.index_cast %[[VAL_10]] : index to i64
// CHECK:               %[[VAL_18:.*]] = memref.load %[[VAL_6]]{{\[}}%[[VAL_13]]] : memref<?xi64>
// CHECK:               %[[VAL_19:.*]] = arith.muli %[[VAL_17]], %[[VAL_18]] : i64
// CHECK:               %[[VAL_20:.*]] = arith.muli %[[VAL_16]], %[[VAL_19]] : i64
// CHECK:               memref.store %[[VAL_20]], %[[VAL_9]]{{\[}}%[[VAL_15]]] : memref<?xi64>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_21:.*]] = sparse_tensor.load %[[VAL_5]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:           return %[[VAL_21]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:         }
func.func @dense_index(%arga: tensor<?x?xi64, #DenseMatrix>)
                      -> tensor<?x?xi64, #DenseMatrix> {
  %c0 = arith.constant 0 : index
  %c1 = arith.constant 0 : index
  %0 = tensor.dim %arga, %c0 : tensor<?x?xi64, #DenseMatrix>
  %1 = tensor.dim %arga, %c1 : tensor<?x?xi64, #DenseMatrix>
  %init = bufferization.alloc_tensor(%0, %1) : tensor<?x?xi64, #DenseMatrix>
  %r = linalg.generic #trait
      ins(%arga: tensor<?x?xi64, #DenseMatrix>)
     outs(%init: tensor<?x?xi64, #DenseMatrix>) {
      ^bb(%a: i64, %x: i64):
        %i = linalg.index 0 : index
        %j = linalg.index 1 : index
        %ii = arith.index_cast %i : index to i64
        %jj = arith.index_cast %j : index to i64
        %m1 = arith.muli %ii, %a : i64
        %m2 = arith.muli %jj, %m1 : i64
        linalg.yield %m2 : i64
  } -> tensor<?x?xi64, #DenseMatrix>
  return %r : tensor<?x?xi64, #DenseMatrix>
}

// CHECK-LABEL:   func @sparse_index(
// CHECK-SAME:      %[[VAL_0:.*]]: tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_1:.*]] = arith.constant 0 : index
// CHECK-DAG:       %[[VAL_2:.*]] = arith.constant 1 : index
// CHECK-DAG:       %[[VAL_3:.*]] = arith.constant 2 : index
// CHECK-DAG:       %[[VAL_4:.*]] = tensor.dim %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_5:.*]] = tensor.dim %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_6:.*]] = bufferization.alloc_tensor(%[[VAL_4]], %[[VAL_5]]) : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_7:.*]] = sparse_tensor.pointers %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_8:.*]] = sparse_tensor.indices %[[VAL_0]], %[[VAL_1]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_9:.*]] = sparse_tensor.pointers %[[VAL_0]], %[[VAL_2]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_10:.*]] = sparse_tensor.indices %[[VAL_0]], %[[VAL_2]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK-DAG:       %[[VAL_11:.*]] = sparse_tensor.values %[[VAL_0]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:           %[[VAL_12:.*]] = memref.alloca(%[[VAL_3]]) : memref<?xindex>
// CHECK:           %[[BUF:.*]] = memref.alloca() : memref<i64>
// CHECK:           %[[VAL_13:.*]] = memref.load %[[VAL_7]]{{\[}}%[[VAL_1]]] : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = memref.load %[[VAL_7]]{{\[}}%[[VAL_2]]] : memref<?xindex>
// CHECK:           scf.for %[[VAL_15:.*]] = %[[VAL_13]] to %[[VAL_14]] step %[[VAL_2]] {
// CHECK:             %[[VAL_16:.*]] = memref.load %[[VAL_8]]{{\[}}%[[VAL_15]]] : memref<?xindex>
// CHECK:             memref.store %[[VAL_16]], %[[VAL_12]]{{\[}}%[[VAL_1]]] : memref<?xindex>
// CHECK:             %[[VAL_17:.*]] = memref.load %[[VAL_9]]{{\[}}%[[VAL_15]]] : memref<?xindex>
// CHECK:             %[[VAL_18:.*]] = arith.addi %[[VAL_15]], %[[VAL_2]] : index
// CHECK:             %[[VAL_19:.*]] = memref.load %[[VAL_9]]{{\[}}%[[VAL_18]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_20:.*]] = %[[VAL_17]] to %[[VAL_19]] step %[[VAL_2]] {
// CHECK:               %[[VAL_21:.*]] = memref.load %[[VAL_10]]{{\[}}%[[VAL_20]]] : memref<?xindex>
// CHECK:               memref.store %[[VAL_21]], %[[VAL_12]]{{\[}}%[[VAL_2]]] : memref<?xindex>
// CHECK:               %[[VAL_22:.*]] = arith.index_cast %[[VAL_21]] : index to i64
// CHECK:               %[[VAL_23:.*]] = arith.index_cast %[[VAL_16]] : index to i64
// CHECK:               %[[VAL_24:.*]] = memref.load %[[VAL_11]]{{\[}}%[[VAL_20]]] : memref<?xi64>
// CHECK:               %[[VAL_25:.*]] = arith.muli %[[VAL_23]], %[[VAL_24]] : i64
// CHECK:               %[[VAL_26:.*]] = arith.muli %[[VAL_22]], %[[VAL_25]] : i64
// CHECK:               memref.store %[[VAL_26]], %[[BUF]][] : memref<i64>
// CHECK:               sparse_tensor.lex_insert %[[VAL_6]], %[[VAL_12]], %[[BUF]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_27:.*]] = sparse_tensor.load %[[VAL_6]] hasInserts : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:           return %[[VAL_27]] : tensor<?x?xi64, #sparse_tensor.encoding
// CHECK:         }
func.func @sparse_index(%arga: tensor<?x?xi64, #SparseMatrix>)
                       -> tensor<?x?xi64, #SparseMatrix> {
  %c0 = arith.constant 0 : index
  %c1 = arith.constant 0 : index
  %0 = tensor.dim %arga, %c0 : tensor<?x?xi64, #SparseMatrix>
  %1 = tensor.dim %arga, %c1 : tensor<?x?xi64, #SparseMatrix>
  %init = bufferization.alloc_tensor(%0, %1) : tensor<?x?xi64, #SparseMatrix>
  %r = linalg.generic #trait
      ins(%arga: tensor<?x?xi64, #SparseMatrix>)
     outs(%init: tensor<?x?xi64, #SparseMatrix>) {
      ^bb(%a: i64, %x: i64):
        %i = linalg.index 0 : index
        %j = linalg.index 1 : index
        %ii = arith.index_cast %i : index to i64
        %jj = arith.index_cast %j : index to i64
        %m1 = arith.muli %ii, %a : i64
        %m2 = arith.muli %jj, %m1 : i64
        linalg.yield %m2 : i64
  } -> tensor<?x?xi64, #SparseMatrix>
  return %r : tensor<?x?xi64, #SparseMatrix>
}

