// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{LineCap, LineJoin};
use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialOrd, Ord, Hash)]
    pub struct Stroke(Boxed<ffi::GskStroke>);

    match fn {
        copy => |ptr| ffi::gsk_stroke_copy(ptr),
        free => |ptr| ffi::gsk_stroke_free(ptr),
        type_ => || ffi::gsk_stroke_get_type(),
    }
}

impl Stroke {
    #[doc(alias = "gsk_stroke_new")]
    pub fn new(line_width: f32) -> Stroke {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gsk_stroke_new(line_width)) }
    }

    #[doc(alias = "gsk_stroke_get_dash")]
    #[doc(alias = "get_dash")]
    pub fn dash(&self) -> Vec<f32> {
        unsafe {
            let mut n_dash = std::mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_none_num(
                ffi::gsk_stroke_get_dash(self.to_glib_none().0, n_dash.as_mut_ptr()),
                n_dash.assume_init() as _,
            );
            ret
        }
    }

    #[doc(alias = "gsk_stroke_get_dash_offset")]
    #[doc(alias = "get_dash_offset")]
    pub fn dash_offset(&self) -> f32 {
        unsafe { ffi::gsk_stroke_get_dash_offset(self.to_glib_none().0) }
    }

    #[doc(alias = "gsk_stroke_get_line_cap")]
    #[doc(alias = "get_line_cap")]
    pub fn line_cap(&self) -> LineCap {
        unsafe { from_glib(ffi::gsk_stroke_get_line_cap(self.to_glib_none().0)) }
    }

    #[doc(alias = "gsk_stroke_get_line_join")]
    #[doc(alias = "get_line_join")]
    pub fn line_join(&self) -> LineJoin {
        unsafe { from_glib(ffi::gsk_stroke_get_line_join(self.to_glib_none().0)) }
    }

    #[doc(alias = "gsk_stroke_get_line_width")]
    #[doc(alias = "get_line_width")]
    pub fn line_width(&self) -> f32 {
        unsafe { ffi::gsk_stroke_get_line_width(self.to_glib_none().0) }
    }

    #[doc(alias = "gsk_stroke_get_miter_limit")]
    #[doc(alias = "get_miter_limit")]
    pub fn miter_limit(&self) -> f32 {
        unsafe { ffi::gsk_stroke_get_miter_limit(self.to_glib_none().0) }
    }

    #[doc(alias = "gsk_stroke_set_dash")]
    pub fn set_dash(&self, dash: &[f32]) {
        let n_dash = dash.len() as _;
        unsafe {
            ffi::gsk_stroke_set_dash(
                mut_override(self.to_glib_none().0),
                dash.to_glib_none().0,
                n_dash,
            );
        }
    }

    #[doc(alias = "gsk_stroke_set_dash_offset")]
    pub fn set_dash_offset(&self, offset: f32) {
        unsafe {
            ffi::gsk_stroke_set_dash_offset(mut_override(self.to_glib_none().0), offset);
        }
    }

    #[doc(alias = "gsk_stroke_set_line_cap")]
    pub fn set_line_cap(&self, line_cap: LineCap) {
        unsafe {
            ffi::gsk_stroke_set_line_cap(mut_override(self.to_glib_none().0), line_cap.into_glib());
        }
    }

    #[doc(alias = "gsk_stroke_set_line_join")]
    pub fn set_line_join(&self, line_join: LineJoin) {
        unsafe {
            ffi::gsk_stroke_set_line_join(
                mut_override(self.to_glib_none().0),
                line_join.into_glib(),
            );
        }
    }

    #[doc(alias = "gsk_stroke_set_line_width")]
    pub fn set_line_width(&self, line_width: f32) {
        unsafe {
            ffi::gsk_stroke_set_line_width(mut_override(self.to_glib_none().0), line_width);
        }
    }

    #[doc(alias = "gsk_stroke_set_miter_limit")]
    pub fn set_miter_limit(&self, limit: f32) {
        unsafe {
            ffi::gsk_stroke_set_miter_limit(mut_override(self.to_glib_none().0), limit);
        }
    }

    #[doc(alias = "gsk_stroke_to_cairo")]
    pub fn to_cairo(&self, cr: &cairo::Context) {
        unsafe {
            ffi::gsk_stroke_to_cairo(self.to_glib_none().0, mut_override(cr.to_glib_none().0));
        }
    }

    #[doc(alias = "gsk_stroke_equal")]
    fn equal(&self, stroke2: &Stroke) -> bool {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gsk_stroke_equal(
                ToGlibPtr::<*const ffi::GskStroke>::to_glib_none(self).0
                    as glib::ffi::gconstpointer,
                ToGlibPtr::<*const ffi::GskStroke>::to_glib_none(stroke2).0
                    as glib::ffi::gconstpointer,
            ))
        }
    }
}

impl PartialEq for Stroke {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.equal(other)
    }
}

impl Eq for Stroke {}
