/*
   libaio Linux async I/O interface
   Copyright 2018 Christoph Hellwig.
   Copyright 2024 Guillem Jover <guillem@hadrons.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <libaio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>
#include "aio_time.h"

int io_pgetevents(io_context_t ctx, long min_nr, long nr,
		struct io_event *events, struct timespec *timeout,
		sigset_t *sigmask)
{
	struct __kernel_timespec ts;

	if (timeout)
		aio_get_timespec(&ts, timeout);
	return aio_pgetevents(ctx, min_nr, nr, events, timeout ? &ts : NULL,
			sigmask);
}
