/*
   libaio Linux async I/O interface
   Copyright 2024 Guillem Jover <guillem@hadrons.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#ifndef _AIO_TIME_H
#define _AIO_TIME_H

#include <linux/time_types.h>

#if __BITS_PER_LONG == 32
# define sys_timespec __kernel_old_timespec
# define sys_get_timespec(sys_ts, kern_ts) \
	aio_get_old_timespec(sys_ts, kern_ts)
#else
# define sys_timespec __kernel_timespec
# define sys_get_timespec(sys_ts, kern_ts) *sys_ts = *kern_ts
#endif

static inline void aio_get_timespec(struct __kernel_timespec *kts,
		const struct timespec *uts)
{
	kts->tv_sec = uts->tv_sec;
	kts->tv_nsec = uts->tv_nsec;
}

static inline void aio_get_old_timespec(struct __kernel_old_timespec *ots,
		const struct __kernel_timespec *kts)
{
	ots->tv_sec = kts->tv_sec;
	ots->tv_nsec = kts->tv_nsec;
}

int aio_pgetevents(io_context_t ctx, long min_nr, long nr,
		struct io_event *events, struct __kernel_timespec *timeout,
		sigset_t *sigmask);

int aio_getevents(io_context_t ctx, long min_nr, long nr,
		struct io_event * events, struct __kernel_timespec * timeout);

#endif /* _AIO_TIME_H */
