% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{splitSwish}
\alias{splitSwish}
\title{Function for splitting SummarizedExperiment into separate RDS files}
\usage{
splitSwish(y, nsplits, prefix = "swish", snakefile = NULL, overwrite = FALSE)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{nsplits}{integer, how many pieces to break \code{y} into}

\item{prefix}{character, the path of the RDS files to write out,
e.g. \code{prefix="/path/to/swish"} will generate \code{swish.rds}
files at this path}

\item{snakefile}{character, the path of a Snakemake file, e.g.
\code{Snakefile}, that should be written out. If \code{NULL},
then no \code{Snakefile} is written out}

\item{overwrite}{logical, whether the \code{snakefile} and
RDS files (\code{swish1.rds}, ...) should overwrite existing files}
}
\value{
nothing, files are written out
}
\description{
The \code{splitSwish} function splits up the \code{y} object
along genes and writes a \code{Snakefile} that can be used with
Snakemake to distribute running \code{swish} across genes.
This workflow is primarily designed for large single cell datasets,
and so the default is to not perform length correction
within the distributed jobs.
See the alevin section of the vignette for an example. See
the Snakemake documention for details on how to run and customize
a \code{Snakefile}: \url{https://snakemake.readthedocs.io}
}
\references{
Compression and splitting across jobs:

Van Buren, S., Sarkar, H., Srivastava, A., Rashid, N.U.,
Patro, R., Love, M.I. (2020)
Compression of quantification uncertainty for scRNA-seq counts.
bioRxiv.
\url{https://doi.org/10.1101/2020.07.06.189639}

Snakemake:

Koster, J., Rahmann, S. (2012)
Snakemake - a scalable bioinformatics workflow engine.
Bioinformatics.
\url{https://doi.org/10.1093/bioinformatics/bts480}
}
