% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_branches.R
\name{leaf_Colors}
\alias{leaf_Colors}
\alias{leaf_colors}
\title{Return the leaf Colors of a dendrogram}
\usage{
leaf_Colors(d, col_to_return = c("edge", "node", "label"))
}
\arguments{
\item{d}{the dendrogram}

\item{col_to_return}{Character scalar - kind of Color attribute to return}
}
\value{
named character vector of Colors, NA_character_ where missing
}
\description{
The returned Colors will be in dendrogram order.
}
\examples{
dend <- USArrests \%>\%
  dist() \%>\%
  hclust(method = "ave") \%>\%
  as.dendrogram()
d5 <- color_branches(dend, 5)
leaf_Colors(d5)
}
\seealso{
\code{\link[dendroextras]{slice},\link{color_branches}}
}
\author{
jefferis
}
