% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatterhist.R
\name{ggscatterhist}
\alias{ggscatterhist}
\alias{print.ggscatterhist}
\title{Scatter Plot with Marginal Histograms}
\usage{
ggscatterhist(
  data,
  x,
  y,
  group = NULL,
  color = "black",
  fill = NA,
  palette = NULL,
  shape = 19,
  size = 2,
  linetype = "solid",
  bins = 30,
  margin.plot = c("density", "histogram", "boxplot"),
  margin.params = list(),
  margin.ggtheme = theme_void(),
  margin.space = FALSE,
  main.plot.size = 2,
  margin.plot.size = 1,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend = "top",
  ggtheme = theme_pubr(),
  print = TRUE,
  ...
)

\method{print}{ggscatterhist}(
  x,
  margin.space = FALSE,
  main.plot.size = 2,
  margin.plot.size = 1,
  title = NULL,
  legend = "top",
  ...
)
}
\arguments{
\item{data}{a data frame}

\item{x}{an object of class \code{ggscatterhist}.}

\item{y}{x and y variables for drawing.}

\item{group}{a grouping variable. Change points color and shape by groups if
the options \code{color} and \code{shape} are missing. Should be also
specified when you want to create a marginal box plot that is grouped.}

\item{color}{point colors.}

\item{fill}{point colors.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{shape}{point shape. See \code{\link{show_point_shapes}}.}

\item{size}{Numeric value (e.g.: size = 1). change the size of points and
outlines.}

\item{linetype}{line type ("solid", "dashed", ...)}

\item{bins}{Number of histogram bins. Defaults to 30. Pick a better value that
fit to your data.}

\item{margin.plot}{the type of the marginal plot. Default is "hist".}

\item{margin.params}{parameters to be applied to the marginal plots.}

\item{margin.ggtheme}{the theme of the marginal plot. Default is
\code{\link[ggplot2:ggtheme]{theme_void}()}.}

\item{margin.space}{logical value. If TRUE, adds space between the main plot
and the marginal plot.}

\item{main.plot.size}{the width of the main plot. Default is 2.}

\item{margin.plot.size}{the width of the marginal plot. Default is 1.}

\item{title}{plot main title.}

\item{xlab}{character vector specifying x axis labels. Use xlab = FALSE to
hide xlab.}

\item{ylab}{character vector specifying y axis labels. Use ylab = FALSE to
hide ylab.}

\item{legend}{specify the legend position. Allowed values include: "top",
"bottom", "left", "right".}

\item{ggtheme}{the theme to be used for the scatter plot. Default is
\code{\link{theme_pubr}()}.}

\item{print}{logical value. If \code{TRUE} (default), print the plot.}

\item{...}{other arguments passed to the function \code{\link{ggscatter}()}.}
}
\value{
an object of class \code{ggscatterhist}, which is list of ggplots,
 including the following elements: \itemize{\item sp: main scatter plot;
 \item xplot: marginal x-axis plot; \item yplot: marginal y-axis plot. }.

 User can modify each of plot before printing.
}
\description{
Create a scatter plot with marginal histograms, density plots or
 box plots.
}
\examples{
# Basic scatter plot with marginal density plot
ggscatterhist(iris, x = "Sepal.Length", y = "Sepal.Width",
              color = "#00AFBB",
              margin.params = list(fill = "lightgray"))


# Grouped data
ggscatterhist(
 iris, x = "Sepal.Length", y = "Sepal.Width",
 color = "Species", size = 3, alpha = 0.6,
 palette = c("#00AFBB", "#E7B800", "#FC4E07"),
 margin.params = list(fill = "Species", color = "black", size = 0.2)
)

# Use boxplot as marginal
ggscatterhist(
 iris, x = "Sepal.Length", y = "Sepal.Width",
 color = "Species", size = 3, alpha = 0.6,
 palette = c("#00AFBB", "#E7B800", "#FC4E07"),
 margin.plot = "boxplot",
 ggtheme = theme_bw()
)

# Add vertical and horizontal line to a ggscatterhist
plots <- ggscatterhist(iris, x = "Sepal.Length", y = "Sepal.Width", print = FALSE)
plots$sp <- plots$sp +
 geom_hline(yintercept = 3, linetype = "dashed", color = "blue") +
 geom_vline(xintercept = 6, linetype = "dashed", color = "red")
plots

}
